varying vec3 v;
varying vec3 N;

uniform sampler2D tex;
uniform sampler2D tex2;
uniform float t;
uniform float xwidth;
uniform float fact;
uniform float concut;


uniform int effect;

#ifndef PI
#define PI 3.14159265358979323846
#endif

float cosInterpolate(in float x , in float y, in float mu){
		float mu2 = (1.0 - cos(mu * PI)) / 2.0;
		return (x * (1.0 - mu2) + y * mu2);
}

float linInterpolate(in float x , in float y, in float mu2){
		return (x * (1.0 - mu2) + y * mu2);
}

void xray0(in float t, inout float texCoord, in float width){
	width = clamp(width, .0, 1.0);
	texCoord = -t + clamp( (texCoord - .5), -width, width);
}

void xray1(in float t, inout float texCoord, in float width){
	width = clamp(width / 2.0, .0, 1.0);
	t = clamp(t, 0.0, 1.0);
	texCoord = clamp( (texCoord - .5), -width, width) + .5;
}

float contrast(inout float level, in float amount){
	float l = level ;
	level = clamp(((1.0 + amount) * l) - amount, .0, 1.0);
	return level ;
} 

void main()
{
	float tl = t/ 200.0;
	
	float ts0 = gl_TexCoord[0].s;
	float tt0 = gl_TexCoord[0].t;
	
	float c = 1.0;
	
	if( effect == 0){
		xray0(tl, tt0, xwidth);
	} else if(effect == 1) {
		xray1(tl, tt0, xwidth);
	} else if(effect == 3) {
		xray0(tl, tt0, xwidth);
		ts0 += fact;
	} else if(effect == 4) {
		xray0(tl, tt0, xwidth);
		ts0 += fact;
		vec4 foo = texture2D(tex, vec2(ts0, tt0));
		c = (foo.r + foo.g + foo.b + foo.a)/4.0;
		c = contrast(c, concut);
	}
	
	vec4 glow = texture2D(tex2, vec2(gl_TexCoord[1]));
	vec4 texture = c * texture2D(tex, vec2(ts0, tt0));	
	vec4 texComb = texture;

 	gl_FragColor = gl_Color * texComb;
}