/* 
   a demo for Meggy Jr RGB
   - the portable opensource console by evilmadscience
   Music  by frequent
   Code by v3nomsoup 
   Demo or Die!
*/

#include <MeggyJrSimple.h>  //includes Library by evilmadscience (GPL)
#include <avr/pgmspace.h>   //includes library to load data into programspace 

const byte font_table[27][6] PROGMEM = {
  {B110011,B110011,B111111,B110001,B110001,B11110},  //A
  {B111110,B110001,B111111,B110001,B110001,B11110},  //B
  {B11111,B111111,B110000,B110000,B110000,B11111},   //C
  {B111110,B111111,B110001,B110001,B110001,B111110}, //D
  {B111111,B110000,B111110,B111100,B110000,B11111},  //E
  {B110000,B110000,B111100,B111110,B110000,B11111},  //F
  {B11110,B110011,B110111,B110000,B110000,B11111},   //G
  {B110001,B110001,B111111,B111111,B110001,B110001}, //H
  {B111110,B11100,B11100,B11100,B11100,B111111},     //I
  {B11100,B11110,B100110,B110,B110,B111111},         //J 
  {B110111,B110110,B111100,B111100,B110110,B110011}, //K
  {B11111,B111110,B110000,B110000,B110000,B10000},   //L
  {B110001,B110001,B110001,B110101,B111011,B10001},  //M
  {B110001,B110011,B110111,B111101,B111001,B10001},  //N
  {B11110,B110001,B110001,B110001,B110001,B11110},   //O
  {B110000,B110000,B111110,B110001,B110001,B11110},  //P
  {B11101,B110010,B110001,B110001,B100001,B11110},   //Q
  {B110011,B110110,B111110,B110001,B110001,B11110},  //R
  {B111100,B10,B111111,B110000,B110000,B11111},      //S
  {B11000,B11000,B11000,B11000,B11110,B111111},      //T
  {B11110,B110001,B110001,B110001,B110001,B10001},   //U
  {B1110,B11011,B110001,B100001,B100001,B100001},    //V
  {B10001,B111011,B110101,B110001,B110001,B100001},  //W
  {B110011,B11110,B1100,B11110,B110011,B100001},     //X
  {B1100,B1100,B1100,B11110,B110011,B100001},        //Y
  {B111111,B110000,B11000,B1100,B110,B111111},       //Z
  {0,0,0,0,0,0}                                      //SPACE
};  

const byte small_font_table[27][2] PROGMEM = {
  {B11111010,B11110000},{B11110101,B1110000},  //A B
  {B11111001,B10010000},{B11111001,B1100000},  //C D
  {B11111011,B10010000},{B11111010,B10000000}, //E F
  {B11111001,B10110000},{B11110100,B11110000}, //G H
  {B10011111,B10010000},{B10101001,B11110000}, //I J
  {B11110110,B10010000},{B11110001,B10000},    //K L
  {B11110100,B11110000},{B11110100,B110000},   //M N 
  {B11111001,B11110000},{B11111010,B11100000}, //O P
  {B11111001,B11100000},{B11111010,B11010000}, //Q R
  {B11011111,B10110000},{B10001111,B10000000}, //S T
  {B11110001,B11110000},{B11100001,B11100000}, //U V
  {B11110010,B11110000},{B10010110,B10010000}, //W X
  {B11000111,B11000000},{B10011011,B11010000}, //Y Z
  {0,0}  //SPACE
};
  
const char Scroll1[] = "THE RED SCARVES ARE BACK WITH A DEMO FOR MEGGY JR RGB  ";
const char Scroll2[] = "PARTYCODING BY VENOMSOUP  MELODIES BY FREQUENT OF EPH  ";

const char Scroll3[] = "FIRE EFFECT COMING UP  ";
const char Scroll4[] = "FIRE EFFECT COMING UP  ";

const char Scroll5[] = "GREETINGS TO UD PRD CNS BRS EPH FXT NPL GRV EOF";
//const char Scroll6[] = "  END;";

const unsigned int melody[50] = {12135,10204,8099,7645,8099,9091,12135,9091,7645,13626,9091,8099,12135,10204,8099,7645,8099,9091,12135,9091,7645,13626,9091,8099,0,13626,10204,9091,8581,9091,10204,13626,10204,8581,15289,10204,9091,13626,10204,9091,8581,9091,10204,13626,10204,9091,15289,11454,10204,0};
byte note = 0;  
byte cursor = 0;

int currcolors[4] = {0,0,0,0}; //fr colorcycling

const byte fire_palette[60] = {00,00,00,00,00,00,10,20,30,40,50,60,70,21,31,41,51,42,52,53,61,71,81,91,62,63,72,73,82,92,83,64,74,93,94,75,85,95,86,96,97,22,33,33,44,34,44,45,55,55,56,66,66,77,68,77,88,78,88,99};
byte fire_buffer[8][8];
byte red;
byte green;
byte blue;
byte customcolor[3];

boolean demo_running = true;
  
// define variables for SNEGGY
byte snakeX[64];
byte snakeY[64];
byte orientation;
byte length;
byte EggX;
byte EggY;
long LastTime;
boolean isgameover = true;
int delaytime = 200; 
  
void setup()              
{
   MeggyJrSimpleSetup();  // initialize library
   randomSeed(5835721);
   //setup fire_buffer
   for (int i = 0;i<8;i++){
     fire_buffer[i][i] = 0;
   }
}

void loop()                   
{ 
  //Serial.begin(9600);
  //ClearSlate();
  //upndownscroll();
  //TODO: Pacman in the beginning
  if (demo_running){
    rightleftscroll(5,4,Scroll2,Scroll1,55);
    rightleftscroll(1,2,Scroll4,Scroll3,23);
    for (int i=0; i<120;i++){
      fire_effect();
    }
  
    for (int i=0; i<5;i++){
      colorcycler();
    }
    upndownscroll(Scroll5);
    delay(300);
    ClearSlate();
    DisplaySlate();
    //upndownscroll(Scroll6);
    demo_running = false;
  }
  else
  {
    CheckButtonsPress();
    if (Button_A){
      //color cycling?, TODO
      if (isgameover)
          StartGame();
    }
    if (Button_B){
      // what do you want to do today? (on button-press)
      if (isgameover)
          StartGame();
    }
    if (Button_Up){
        orientation = 1; //north
    }
    if (Button_Down){
        orientation = 3; //south
    }
    if (Button_Left){
        orientation = 0; //west
    }
    if (Button_Right){
        orientation = 2; //east
    }
    if (((millis() - LastTime) > delaytime) && !isgameover){
        if (update_snake() || isgameover){
            LastTime = millis();
            isgameover = true;
            dogameover();
        }
        else
        {
            drawsnake();
            LastTime = millis();
        }
    }
  }
  //play_tune();
  //TODO : snake in the end
  //rightleftscroll
}

void upndownscroll(const char Scrolltext[])
{
  ClearSlate();
  char ScrollChar;
  int CharNr;
  int Color = 1;
  unsigned int ScrollPos = 0; 
  ScrollChar = Scrolltext[ScrollPos];
  while (ScrollPos < 47){
    if (ScrollChar == ' '){
      CharNr = 26;
      if (Color++ > 7)
      Color = 1;
    }
    else
    {
      CharNr = ScrollChar - 'A';
    }
    putchar(CharNr,Color,50);
    //delay(300);
    play_notes(6);
    ScrollPos++;
    ScrollChar = Scrolltext[ScrollPos];
  }
}

void putchar(int charnr, int color, int scrollspeed)
{
  byte charline;
  scrolldown(1,true);
  //delay(scrollspeed);
  play_notes(1);
  for (int y=0;y<6;y++){
    scrolldown(1,false);
    //read it from the progmem
    charline = (uint8_t)pgm_read_word(&font_table[charnr][y]); 
    //charline = font_table[charnr][y];
    for (int i=0;i<7;i++){
      if (bitRead(charline,6-i) == 1)
        DrawPx(i,7,color);
        DisplaySlate();
    }
    //delay(scrollspeed);
    play_notes(1);
  }
  scrolldown(1,true);
}

void scrolldown(int rows, boolean displayit)
{
  for (int i=0; i<rows; i++){
    //move rows 0-6 one down
    for (int y=0; y<7;y++){
      for (int x=0; x<8;x++){
        DrawPx(x,y,ReadPx(x,y+1));
      }
    }
    //clear top row
    for (int x=0; x<8;x++){
      DrawPx(x,7,0);
    }
  }
  if (displayit)
    DisplaySlate();
}
      
void rightleftscroll(byte colorA, byte colorB, const char ScrollA[], const char ScrollB[], byte anzahlchars)
{
  ClearSlate(); //nicht unbedingt notwendig
  int l;
  byte charA;
  byte charB;
  //byte colorA = 1;
  //byte colorB = 2;
  //unsigned int scrolldelay = 1000;
  unsigned int nrA;
  unsigned int nrB;
  //const char ScrollA[] = "HELLOILOVEYOU"; //unten 
  //const char ScrollB[] = "HELLOILOVEYOU"; //oben
  for (int i=0; i<anzahlchars; i++){
    if (ScrollA[i] == ' ')
      nrA = 26;
    else
      nrA = ScrollA[i] - 'A';
    if (ScrollB[i] == ' ')
      nrB = 26;
    else  
      nrB = ScrollB[i] - 'A';
    for (int j=0; j<=1; j++){
      if (j == 0)
        l = 1;
      else
        l = 0;
      charA = (uint8_t)pgm_read_word(&small_font_table[nrA][l]); //unten 
      charB = (uint8_t)pgm_read_word(&small_font_table[nrB][j]); //oben
      scroll_rl();
      for (int k=7; k>=4; k--){
        if (bitRead(charA,7-k) == 1)
          DrawPx(0,7-k,colorA);
        else
          DrawPx(0,7-k,0);
        if (bitRead(charB,k) == 1)
        {
          DrawPx(7,k,colorB);
        }
        else
        {
          DrawPx(7,k,0);
        }  
      }
      DisplaySlate();
      //delay(scrolldelay);
      play_notes(3);
      scroll_rl();
      
      for(int m=3;m>=0;m--){
        if (bitRead(charA,7-m) == 1)
           DrawPx(0,3-m,colorA);
        else
           DrawPx(0,3-m,0);
        if (bitRead(charB,m) == 1){
           DrawPx(7,m+4,colorB);
        }
        else
        {
           DrawPx(7,m+4,0);
        }
      } 
      DisplaySlate();
      play_notes(3);
      //delay(scrolldelay);
    }
  }
}

void scroll_rl()
{
  for (int y1=0; y1<4; y1++){
    //push pixels
    for (int x1=7; x1>0; x1--){
      DrawPx(x1,y1,ReadPx(x1-1,y1));
    }
    DrawPx(0,y1,0); //clear line
  }  
  for (int y2=4; y2<=7; y2++){
    //push pixels
    for (int x2=0; x2<7; x2++){
      DrawPx(x2,y2,ReadPx(x2+1,y2));
    }
    DrawPx(7,y2,0); //clear line
  }
}

void play_tune() //lovely melody by frequent/ephidrena
{
  unsigned int firstpart[26] = {12135,10204,8099,7645,8099,9091,12135,9091,7645,13626,9091,8099,12135,10204,8099,7645,8099,9091,12135,9091,7645,13626,9091,8099,0,0};
  unsigned int secondpart[26] = {13626,10204,9091,8581,9091,10204,13626,10204,8581,15289,10204,9091,13626,10204,9091,8581,9091,10204,13626,10204,9091,15289,11454,10204,0,0};
  unsigned int secondpart2[24] = {12135,10204,8099,7645,8099,9091,12135,9091,7645,13626,9091,8099,12135,10204,8099,7645,8099,9091,12135, 0, 0, 0, 0, 0};
  play_melody(firstpart);
  play_melody(secondpart2);
  play_melody(secondpart);
}

void play_melody(unsigned int melody[26])
{
 byte i = 0;  
 while (i < 25)
  {
    Tone_Start(melody[i], 200); 
    while (MakingSound)   {}  
    Tone_Start(0,50);
    while (MakingSound) {}
    i++;
  }
}

void play_notes(byte anzahl){
  for (int i=0; i<anzahl; i++){
    if (cursor == 4){
      Tone_Start(0,50);
      while (MakingSound)   {} 
      cursor = 0;
      note++;
    }
    else
    {
      Tone_Start(melody[note],50);
      while (MakingSound)   {}
      cursor++;
      if (note == 50)
        note = 0;
    }
  }
}

void colorcycler()
{
  ClearSlate();
  for (int nextcolor = 1 ; nextcolor < 16; nextcolor++){
    play_notes(4);
    currcolors[0] = currcolors[1];
    currcolors[1] = currcolors[2];
    currcolors[2] = currcolors[3];
    currcolors[3] = nextcolor;
    cycle_colors_static();
    DisplaySlate();
  }
}
/*
void cycle_colors(byte newcolor)
{
  //move corona
  for (int yc = 0; yc<3; yc++){
    if (yc == 0){
      for (int ii = 0; ii<8; ii++){
        DrawPx(0,ii,ReadPx(3,1));
        DrawPx(7,ii,ReadPx(3,1));
      }
    }  
    for (int xc = 1;xc<7; xc++){
      DrawPx(xc,yc,ReadPx(3,yc+1));
    }
  }
  for (int yd = 7; yd>4;yd--){
     for (int xd = 1;xd<7; xd++){
       DrawPx(xd,yd,ReadPx(3,yd-1));
     }
  }
  //draw center
  DrawPx(3,3,newcolor);
  DrawPx(3,4,newcolor);
  DrawPx(4,3,newcolor);
  DrawPx(4,4,newcolor); 
} */

void cycle_colors_static(){
  for (int ii=0; ii<4; ii++){
    for (int xc = 0+ii; xc<(8-ii);xc++){
      DrawPx(xc,0+ii,currcolors[ii]); //horizontal
      DrawPx(xc,7-ii,currcolors[ii]); //horizontal2
      for (int yc = ii+1; yc<7-ii;yc++){
        DrawPx(0+ii,yc,currcolors[ii]); //vertikal
        DrawPx(7-ii,yc,currcolors[ii]); //vertikal2
      }
    }
  } 
}

void fire_frame()
{
  int randomnr;
  //create random bottom_row
  for(int i=0;i<8;i++){
    fire_buffer[i][0] = random(0,60);
  }
  //calculate the rows
  for (int y=1;y<8;y++){
    for (int x=0;x<8;x++){
      if (y == 1){ //first row
        switch (x){
          case 0:
              fire_buffer[0][y] = round((fire_buffer[0][y-1] + fire_buffer[1][y-1]) / (3.5+(y/2))); //left corner
            break;
          case 7:
              fire_buffer[7][y] = round((fire_buffer[7][y-1] + fire_buffer[6][y-1]) / (3.5+(y/2))); //right corner
            break;
          default:
            fire_buffer[x][1] = round((fire_buffer[x-1][0] + fire_buffer[x][0] + fire_buffer[x+1][0]) / (4.5)); //middle
        }
      }
      else // other rows
      {
        switch (x){
          case 0:
              fire_buffer[0][y] = round((fire_buffer[0][y-1] + fire_buffer[1][y-1]) / (3.5+(y/1.4))); //left corner
            break;
          case 7:
              fire_buffer[7][y] = round((fire_buffer[7][y-1] + fire_buffer[6][y-1]) / (3.5+(y/1.4))); //right corner
            break;
          default:
              fire_buffer[x][y] = round((fire_buffer[x-1][y-1] + fire_buffer[x][y-1] + fire_buffer[x+1][y-1] + fire_buffer[x][y-2]) / (5.3+y/1.6));
        }
      }
    }
  }
}

void fire_effect()
{
   int color;
   //ClearSlate();
   fire_frame(); //calculate frame to buffer
   //translate buffer to screen
   for (int x=0;x<8;x++){
     for (int y=0;y<8;y++){
       color = fire_buffer[8][8];
       //Serial.println(color);
       //TODO: translate int to rgb
       red = fire_buffer[x][y];
       red = red % 10;
       green = fire_buffer[x][y];
       green = green / 10;
       blue = 0;
       if (red < green)
         red = green;
       customcolor[0] = red;
       customcolor[1] = green;
       customcolor[2] = blue;
       Meg.SetPxClr(x,y,customcolor); 
     }
   }
   //DisplaySlate();
   play_notes(2);
   //delay(100);
}

// --------------------------------------
// HERE STARTS A COPY OF THE SNEGGY CODE.

//generates random egg, checks if it isn't in the snake's stomach atm
void next_egg()
{
    boolean EggOk = false;
    while(!EggOk){
        EggX = random(0,8);
        EggY = random(0,8);
        boolean found = false;
        for (int i=0; i < length && !found; i++){
            if ((snakeX[i] == EggX) && (snakeY[i] == EggY)){
                found = true;
            }
        }
        if (!found) {
          EggOk = true;
        }
    }
}

//updates snake array, plus "collision-detection", sort of
boolean update_snake()
{
    //initialize variables
    byte headX = snakeX[length-1];
    byte headY = snakeY[length-1];
    byte newheadX = headX;
    byte newheadY = headY;
    boolean collision = true;
    boolean foundEgg = false;
    //calculate new head, check for collisions with the borders
    switch (orientation) {
        case 0: //west
            if (headX > 0){
                newheadX--;
                collision = false;
            }
            break;
        case 1: //north
            if (headY < 7){
                newheadY++;
                collision = false;
            }
            break;
        case 2: //east
            if (headX < 7){
                newheadX++;
                collision = false;
            }
            break;
        case 3: //south
            if (headY > 0){
                newheadY--;
                collision = false;
            }
            break;
        default :
            break;
    }
    //if there was no collision so far, check if the snake has biten itself - urgs
    if (!collision){
        for (int i=0; i < length && !collision; i++){
            if ((snakeX[i] == newheadX) && (snakeY[i] == newheadY)){
                collision = true;
            }
        }
    }
    //if there was now collision in the end, check if the snake found it's egg - yummy
    if ((newheadX == EggX) && (newheadY == EggY)){
        foundEgg = true;
        length ++;
    }
    else
    {
        for (int i=0; i < length-1;i++){
            snakeX[i] = snakeX[i+1];
            snakeY[i] = snakeY[i+1];
        }    
    }
    snakeX[length-1] = newheadX;
    snakeY[length-1] = newheadY;
    if (foundEgg){
        Tone_Start(ToneE7, 50); //play sound
        while (MakingSound)
        {}
        Tone_Start(ToneG7, 50);
        next_egg();
    }
    //result of the function is if there was a collision or not
    return collision;
}

void dogameover()
{
  //play soundeffect
  DieNoise();
  //blink snake
  for (int i = 0; i < 2; i++){
      ClearSlate();
      DisplaySlate();
      delay(800);
      drawsnake();
      delay(800);
  }
}

void drawsnake()
{
    ClearSlate();
    //draw Snake - body red, head orange
    for (int i=0;i<length-1;i++){
        DrawPx(snakeX[i],snakeY[i], Red);
    }
    DrawPx(snakeX[length-1],snakeY[length-1], Orange);
    //draw egg
    DrawPx(EggX,EggY,Green);
    DisplaySlate();
    SetAuxLEDs(length);
}

void StartGame()
{
    //Play sound effect
    HappyFrog();
    delay(300);
    //initialize snake array
    length = 2;
    for (int i=0; i < 64; i++){
        snakeX[i] = 9;
        snakeY[i] = 9;
    }
    snakeX[0] = 1;
    snakeY[0] = 4;
    snakeX[1] = 2;
    snakeY[1] = 4;
    randomSeed(37489);
    orientation = 2;
    next_egg();
    drawsnake();
    //initialize Timer
    LastTime = millis();
    isgameover = false;
    //GAME START! :-)
    SetAuxLEDs(2);
}

void HappyFrog(void)
//Routine to make sound effect
//taken from the example game FroggyJr by Evil Mad Science
{
  byte i = 0;  
  unsigned int freqs[5] = { 7648,0,5730, 0,4048    };

  while (i < 5)
  {
    Tone_Start(freqs[i], 50); 
    while (MakingSound)   {}     
    i++;
  }
}

void DieNoise(void)
//Routine to make sound effect
//taken from the example game FroggyJr by Evil Mad Science - slightly modified
{
  Tone_Start(ToneB4, 100); 
  while (MakingSound)
    {}
  Tone_Start(0, 100); 
  while (MakingSound)
    {}
  Tone_Start(ToneB2, 300); 
  while (MakingSound)
    {}
  Tone_Start(0, 100); 
  while (MakingSound)
    {}  
  Tone_Start(ToneB2, 600); 
  while (MakingSound)
    {}
}
