/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libvorbis;

import org.xiph.libvorbis.envelope_band;
import org.xiph.libvorbis.envelope_filter_state;
import org.xiph.libvorbis.mdct_lookup;
import org.xiph.libvorbis.vorbis_constants.integer_constants;
import org.xiph.libvorbis.vorbis_info;
import org.xiph.libvorbis.vorbis_info_psy_global;

class envelope_lookup {
    int ch;
    int winlength;
    int searchstep;
    float minenergy;
    mdct_lookup mdct;
    float[] mdct_win;
    envelope_band[] band;
    envelope_filter_state[] filter;
    int stretch;
    int[] mark;
    int storage;
    int current;
    int curmark;
    int cursor;

    public envelope_lookup(int _ch, int _winlength, int _searchstep, float _minenergy, mdct_lookup _mdct, float[] _mdct_win, envelope_band[] _band, envelope_filter_state[] _filter, int _stretch, int[] _mark, int _storage, int _current, int _curmark, int _cursor) {
        this.ch = _ch;
        this.winlength = _winlength;
        this.searchstep = _searchstep;
        this.minenergy = _minenergy;
        this.mdct = _mdct;
        this.mdct_win = new float[_mdct_win.length];
        System.arraycopy(_mdct_win, 0, this.mdct_win, 0, _mdct_win.length);
        this.band = new envelope_band[7];
        System.arraycopy(_band, 0, this.band, 0, _band.length);
        this.filter = _filter;
        this.stretch = _stretch;
        this.mark = new int[_mark.length];
        System.arraycopy(_mark, 0, this.mark, 0, _mark.length);
        this.storage = _storage;
        this.current = _current;
        this.curmark = _curmark;
        this.cursor = _cursor;
    }

    public envelope_lookup(envelope_lookup src) {
        this(src.ch, src.winlength, src.searchstep, src.minenergy, src.mdct, src.mdct_win, src.band, src.filter, src.stretch, src.mark, src.storage, src.current, src.curmark, src.cursor);
    }

    public envelope_lookup(vorbis_info _vi) {
        this.ch = _vi.channels;
        this.winlength = 128;
        this.searchstep = 64;
        this.minenergy = _vi.codec_setup.psy_g_param.preecho_minenergy;
        int n = this.winlength;
        this.storage = 128;
        this.cursor = _vi.codec_setup.blocksizes[1] / 2;
        this.mdct_win = new float[n];
        this.mdct = new mdct_lookup();
        this.mdct.mdct_init(n);
        int i = 0;
        while (i < n) {
            this.mdct_win[i] = new Double(Math.sin((double)i / ((double)n - 1.0) * 3.1415927410125732)).floatValue();
            int n2 = i;
            this.mdct_win[n2] = this.mdct_win[n2] * this.mdct_win[i];
            ++i;
        }
        this.band = new envelope_band[7];
        i = 0;
        while (i < 7) {
            this.band[i] = new envelope_band();
            ++i;
        }
        this.band[0].begin = 2;
        this.band[0].end = 4;
        this.band[1].begin = 4;
        this.band[1].end = 5;
        this.band[2].begin = 6;
        this.band[2].end = 6;
        this.band[3].begin = 9;
        this.band[3].end = 8;
        this.band[4].begin = 13;
        this.band[4].end = 8;
        this.band[5].begin = 17;
        this.band[5].end = 8;
        this.band[6].begin = 22;
        this.band[6].end = 8;
        int j = 0;
        while (j < 7) {
            n = this.band[j].end;
            this.band[j].window = new float[n];
            int i2 = 0;
            while (i2 < n) {
                this.band[j].window[i2] = new Double(Math.sin(((double)i2 + 0.5) / (double)n * 3.1415927410125732)).floatValue();
                this.band[j].total += this.band[j].window[i2];
                ++i2;
            }
            this.band[j].total = 1.0f / this.band[j].total;
            ++j;
        }
        this.filter = new envelope_filter_state[7 * this.ch];
        i = 0;
        while (i < 7 * this.ch) {
            this.filter[i] = new envelope_filter_state();
            ++i;
        }
        this.mark = new int[this.storage];
    }

    public int _ve_amp(vorbis_info_psy_global gi, float[] data, int offset1, envelope_band[] bands, envelope_filter_state[] filters, int offset2, int pos) {
        float decay;
        int n = this.winlength;
        int ret = 0;
        float minV = this.minenergy;
        float[] vec = new float[n];
        int stretch_local = Math.max(2, this.stretch / 2);
        float penalty = gi.stretch_penalty - (float)(this.stretch / 2 - 2);
        if (penalty < 0.0f) {
            penalty = 0.0f;
        }
        if (penalty > gi.stretch_penalty) {
            penalty = gi.stretch_penalty;
        }
        int i = 0;
        while (i < n) {
            vec[i] = data[offset1 + i] * this.mdct_win[i];
            ++i;
        }
        this.mdct.mdct_forward(vec, vec);
        float temp = vec[0] * vec[0] + 0.7f * vec[1] * vec[1] + 0.2f * vec[2] * vec[2];
        int ptr = filters[offset2].nearptr;
        if (ptr == 0) {
            decay = filters[offset2].nearDC_acc = filters[offset2].nearDC_partialacc + temp;
            filters[offset2].nearDC_partialacc = temp;
        } else {
            decay = filters[offset2].nearDC_acc += temp;
            filters[offset2].nearDC_partialacc += temp;
        }
        filters[offset2].nearDC_acc -= filters[offset2].nearDC[ptr];
        filters[offset2].nearDC[ptr] = temp;
        decay = (float)((double)decay * 0.0625);
        ++filters[offset2].nearptr;
        if (filters[offset2].nearptr >= 15) {
            filters[offset2].nearptr = 0;
        }
        decay = integer_constants.todB(decay) * 0.5f - 15.0f;
        i = 0;
        while (i < n / 2) {
            float val = vec[i] * vec[i] + vec[i + 1] * vec[i + 1];
            if ((val = integer_constants.todB(val) * 0.5f) < decay) {
                val = decay;
            }
            if (val < minV) {
                val = minV;
            }
            vec[i >> 1] = val;
            decay = (float)((double)decay - 8.0);
            i += 2;
        }
        int j = 0;
        while (j < 7) {
            float acc = 0.0f;
            i = 0;
            while (i < bands[j].end) {
                acc += vec[i + bands[j].begin] * bands[j].window[i];
                ++i;
            }
            acc *= bands[j].total;
            int _this = filters[offset2 + j].ampptr;
            float premax = -99999.0f;
            float premin = 99999.0f;
            int p = _this;
            if (--p < 0) {
                p += 17;
            }
            float postmax = Math.max(acc, filters[offset2 + j].ampbuf[p]);
            float postmin = Math.min(acc, filters[offset2 + j].ampbuf[p]);
            i = 0;
            while (i < stretch_local) {
                if (--p < 0) {
                    p += 17;
                }
                premax = Math.max(premax, filters[offset2 + j].ampbuf[p]);
                premin = Math.min(premin, filters[offset2 + j].ampbuf[p]);
                ++i;
            }
            float valmin = postmin - premin;
            float valmax = postmax - premax;
            filters[offset2 + j].ampbuf[_this] = acc;
            ++filters[offset2 + j].ampptr;
            if (filters[offset2 + j].ampptr >= 17) {
                filters[offset2 + j].ampptr = 0;
            }
            if (valmax > gi.preecho_thresh[j] + penalty) {
                ret |= 1;
                ret |= 4;
            }
            if (valmin < gi.postecho_thresh[j] - penalty) {
                ret |= 2;
            }
            ++j;
        }
        return ret;
    }

    public void _ve_envelope_shift(int shift) {
        int smallsize = this.current / this.searchstep + 2;
        int smallshift = shift / this.searchstep;
        System.arraycopy(this.mark, smallshift, this.mark, 0, smallsize - smallshift);
        this.current -= shift;
        if (this.curmark >= 0) {
            this.curmark -= shift;
        }
        this.cursor -= shift;
    }
}

