/*
 * Decompiled with CFR 0.152.
 */
package slicks.ui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class Slider {
    private Image base;
    private Image handle;
    private int x2;
    private int y2;
    private int x;
    private int y;
    private int handleOffset_x;
    private int handleOffset_y;
    private int width;
    private int lowerLimitX;
    private int upperLimitX;
    private int height;
    private int range;
    private int offset_x;
    private boolean dragging;

    public boolean isDragging() {
        return this.dragging;
    }

    public Slider(int base_x, int base_y, int handle_x, int handle_y, Image base, Image handle, int range) {
        this.handleOffset_x = handle_x;
        this.handleOffset_y = handle_y;
        this.x = base_x;
        this.y = base_y;
        this.x2 = this.x + handle_x;
        this.y2 = this.y + handle_y;
        this.base = base;
        this.handle = handle;
        this.range = range;
        this.width = handle.getWidth(null);
        this.height = handle.getHeight(null);
        this.lowerLimitX = this.x + base.getWidth(null) / 2 - range / 2;
        this.upperLimitX = this.x + base.getWidth(null) / 2 + range / 2 - this.width;
    }

    public Point getSize() {
        Point pt = new Point(this.width, this.height);
        return pt;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.x2 = this.handleOffset_x + x;
        this.y2 = this.handleOffset_y + y;
    }

    public Point getPosition() {
        Point pt = new Point(this.x, this.y);
        return pt;
    }

    public void paint(Graphics g) {
        if (this.base != null) {
            g.drawImage(this.base, this.x, this.y, null);
        }
        if (this.handle != null) {
            g.drawImage(this.handle, this.x2, this.y2, null);
        }
    }

    public void drag(int mouseX) {
        int temp = mouseX + this.offset_x;
        if (this.dragging && temp > this.lowerLimitX && temp < this.upperLimitX) {
            this.x2 = mouseX + this.offset_x;
        }
    }

    public boolean startDrag(int mouseX, int mouseY) {
        boolean xHit = false;
        boolean yHit = false;
        if (mouseX >= this.x2 && mouseX <= this.x2 + this.width) {
            xHit = true;
        }
        if (mouseY >= this.y2 && mouseY <= this.y2 + this.height) {
            yHit = true;
        }
        if (xHit && yHit) {
            this.dragging = true;
            this.offset_x = this.x2 - mouseX;
            return true;
        }
        return false;
    }

    public void stopDrag() {
        this.dragging = false;
    }

    public int getAmount() {
        double amount = this.x2 - this.lowerLimitX;
        double temp2 = amount / (double)(this.range - this.width);
        return (int)(100.0 * temp2);
    }
}

