/*
 * Decompiled with CFR 0.152.
 */
package slicks.ui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Vector;
import other.Console;
import other.HotSpot;
import other.SimpleFont;
import slicks.client.SlicksApplet;
import slicks.engine.ControlInterface;
import slicks.engine.Engine;
import slicks.engine.ImageLoader;
import slicks.model.Model;
import slicks.model.Track;
import slicks.model.Vector2;
import slicks.sound.SoundMan;
import slicks.ui.ResultsScreen;
import slicks.ui.Slider;
import slicks.ui.TrackSelection;

public class Menu {
    public Model model;
    public boolean enableTournaments = false;
    public SimpleFont font;
    public static int scrWidth;
    public static int scrHeight;
    public HotSpot menuSpot;
    public Vector<HotSpot> activeButtons;
    public static int scrCenter;
    public static int thirdHeight;
    public static int bigbuttonWidth;
    int bigbuttonHeight = 150;
    int buttonSpacing = 60;
    int defaultWidth = 80;
    int defaultHeight = 60;
    int smallbuttonWidth = 200;
    int smallbuttonHeight = 128;
    private int squareButtonwh = 128;
    private int smallSquareButtonwh = 64;
    private boolean soundIconSwapped = false;
    public HotSpot[] playerNameButton;
    public HotSpot[] playerCarButton;
    public HotSpot localGameButton;
    public HotSpot onePlayerButton;
    public HotSpot twoPlayerButton;
    public HotSpot threePlayerButton;
    public HotSpot fourPlayerButton;
    public HotSpot localSettingsButton;
    public HotSpot chooseCarPlayerOneRightButton;
    public HotSpot chooseCarPlayerOneLeftButton;
    public HotSpot chooseCarPlayerTwoRightButton;
    public HotSpot chooseCarPlayerTwoLeftButton;
    public HotSpot trackChoiceButtonRight;
    public HotSpot trackChoiceButtonLeft;
    public HotSpot[] trackChoice;
    public HotSpot soundsOnOffButton;
    public HotSpot restartRaceButton;
    TrackSelection trackSelector;
    public HotSpot startRaceButton;
    public HotSpot networkGameButton;
    public HotSpot networkSettingsButton;
    public HotSpot tournamentButton;
    public HotSpot singleRaceButton;
    public HotSpot realRaceButton;
    public HotSpot playRaceButton;
    public HotSpot privateRaceButton;
    public HotSpot settingsButton;
    public HotSpot carColorButton;
    public HotSpot assignControlsPlayerOneButton;
    public HotSpot assignControlsPlayerTwoButton;
    public HotSpot resetSettingsButton;
    public HotSpot saveSettingsButton;
    public HotSpot screenSizeLarger;
    public HotSpot screenSizeSmaller;
    public HotSpot soundButton;
    public HotSpot backButton;
    public Vector<HotSpot> filmstrip;
    public Image emptyKey;
    public int emptyKeyWidth;
    public int emptyKeyHeight;
    public int emptyKeyP1PositionX;
    public int emptyKeyP1PositionY;
    public int emptyKeyP2PositionX;
    public int emptyKeyP2PositionY;
    public Image background;
    public Image logo;
    public int logoWidth;
    public int logoHeight;
    public int backgrndScrollerX = 0;
    public int backgrndScrollerY = 0;
    public int backgrndWidth;
    public int backgrndHeight;
    private SoundMan sm;
    public ResultsScreen results;
    private Slider slider_effects;
    private Slider slider_player;

    static {
        scrCenter = SlicksApplet.WIDTH / 2;
        thirdHeight = SlicksApplet.HEIGHT / 3;
        bigbuttonWidth = 200;
    }

    public Menu(ImageLoader il, SimpleFont font, SoundMan sm) {
        Console.print("Load Menu");
        this.activeButtons = new Vector();
        Console.print("Load Menu BackGround");
        this.loadMenuBackGroundAndLogo(il);
        Console.print("Load StartMenu");
        this.loadStartMenu(il);
        Console.print("Load LocalMenu");
        this.loadLocalMenu(il);
        Console.print("Load SettingsMenu");
        this.loadSettingsMenu(il);
        Console.print("Load PreRace Menu");
        this.loadLocalPreRaceMenu(il);
        Console.print("Load RaceResult Menu");
        this.loadRaceResultsMenu(il);
        Console.print("Load Sounds if sm !null");
        if (sm != null) {
            this.sm = sm;
        }
        if (font == null) {
            Console.print("no font for menu!");
        } else {
            this.font = font;
        }
        Console.print("ACTIVATE TRACKCHOICE");
        Track track = new Track();
        this.trackSelector = new TrackSelection();
        this.trackSelector.getTrackChoices(track);
        this.resizeMenu();
    }

    public void loadMenuBackGroundAndLogo(ImageLoader il) {
        this.background = il.getImage("/background/bg.png");
        this.backgrndHeight = this.background.getHeight(null);
        this.backgrndWidth = this.background.getWidth(null);
        this.logo = il.getImage("/extras/logo.png");
        this.logoHeight = this.logo.getHeight(null);
        this.logoWidth = this.logo.getWidth(null);
    }

    public void loadStartMenu(ImageLoader il) {
        this.localGameButton = new HotSpot();
        this.localGameButton.setImage(il.getImage("/buttons/localGame_default.png"), 1);
        this.localGameButton.setSize(bigbuttonWidth, this.bigbuttonHeight);
        this.localGameButton.setName("localGame");
        this.networkGameButton = new HotSpot();
        this.networkGameButton.setImage(il.getImage("/buttons/netGame_default.png"), 1);
        this.networkGameButton.setSize(bigbuttonWidth, this.bigbuttonHeight);
        this.networkGameButton.setName("networkGame");
        this.activeButtons.add(this.networkGameButton);
        this.activeButtons.add(this.localGameButton);
        this.screenSizeLarger = new HotSpot();
        this.screenSizeLarger.setImage(il.getImage("/buttons/screenbigF6_default.png"), 1);
        this.screenSizeLarger.setSize(this.smallSquareButtonwh, this.smallSquareButtonwh);
        this.screenSizeLarger.setName("larger");
        this.screenSizeSmaller = new HotSpot();
        this.screenSizeSmaller.setImage(il.getImage("/buttons/screensmallF5_default.png"), 1);
        this.screenSizeSmaller.setSize(this.smallSquareButtonwh, this.smallSquareButtonwh);
        this.screenSizeSmaller.setName("smaller");
        this.soundsOnOffButton = new HotSpot();
        this.soundsOnOffButton.setImage(il.getImage("/buttons/nuotti_green_music_on.png"), 1);
        this.soundsOnOffButton.setImage(il.getImage("/buttons/nuotti_red_music_off.png"), 2);
        this.soundsOnOffButton.setSize(30, 30);
        this.soundsOnOffButton.setName("mute");
        this.slider_effects = new Slider(200, 30, 100, 0, il.getImage("/buttons/settings/slaideri_feideri_pohja.png"), il.getImage("/buttons/settings/slaideri_feideri_fader_button.png"), 200);
        this.slider_player = new Slider(400, 30, 100, 0, il.getImage("/buttons/settings/slaideri_feideri_pohja.png"), il.getImage("/buttons/settings/slaideri_feideri_fader_button.png"), 200);
    }

    public void loadLocalMenu(ImageLoader il) {
        this.onePlayerButton = new HotSpot();
        this.onePlayerButton.setImage(il.getImage("/buttons/localmenu/OnePlayer_default.png"), 1);
        this.onePlayerButton.setSize(bigbuttonWidth, this.bigbuttonHeight);
        this.onePlayerButton.setName("onePlayerGame");
        this.twoPlayerButton = new HotSpot();
        this.twoPlayerButton.setImage(il.getImage("/buttons/localmenu/TwoPlayer_default.png"), 1);
        this.twoPlayerButton.setSize(bigbuttonWidth, this.bigbuttonHeight);
        this.twoPlayerButton.setName("twoPlayerGame");
        this.localSettingsButton = new HotSpot();
        this.localSettingsButton.setImage(il.getImage("/buttons/localmenu/settings_default.png"), 1);
        this.localSettingsButton.setSize(this.smallbuttonWidth, this.smallbuttonHeight);
        this.localSettingsButton.setName("localSettings");
        this.backButton = new HotSpot();
        this.backButton.setImage(il.getImage("/buttons/backArrow_default.png"), 1);
        this.backButton.setSize(this.squareButtonwh, this.squareButtonwh);
        this.backButton.setName("back");
    }

    public void loadSettingsMenu(ImageLoader il) {
        this.assignControlsPlayerOneButton = new HotSpot();
        this.assignControlsPlayerOneButton.setImage(il.getImage("/buttons/settings/controlsP1_default.png"), 1);
        this.assignControlsPlayerOneButton.setSize(this.smallbuttonWidth, this.smallbuttonHeight);
        this.assignControlsPlayerOneButton.setName("controlsP1");
        this.assignControlsPlayerTwoButton = new HotSpot();
        this.assignControlsPlayerTwoButton.setImage(il.getImage("/buttons/settings/controlsP2_default.png"), 1);
        this.assignControlsPlayerTwoButton.setSize(this.smallbuttonWidth, this.smallbuttonHeight);
        this.assignControlsPlayerTwoButton.setName("controlsP2");
        this.resetSettingsButton = new HotSpot();
        this.resetSettingsButton.setImage(il.getImage("/buttons/settings/reset_default.png"), 1);
        this.resetSettingsButton.setSize(this.smallbuttonWidth, this.smallbuttonHeight);
        this.resetSettingsButton.setName("resetSettings");
        this.saveSettingsButton = new HotSpot();
        this.saveSettingsButton.setImage(il.getImage("/buttons/settings/saveSettings_default.png"), 1);
        this.saveSettingsButton.setSize(this.smallbuttonWidth, this.smallbuttonHeight);
        this.saveSettingsButton.setName("saveSettings");
        this.emptyKey = il.getImage("/buttons/blankbuttons/blank_key.png");
        this.emptyKeyHeight = this.emptyKey.getHeight(null);
        this.emptyKeyWidth = this.emptyKey.getWidth(null);
    }

    public void loadRaceResultsMenu(ImageLoader il) {
        this.restartRaceButton = new HotSpot();
        this.restartRaceButton.setImage(il.getImage("/buttons/localmenu/playAgain_default.png"), 1);
        this.restartRaceButton.setSize(bigbuttonWidth, this.bigbuttonHeight);
        this.restartRaceButton.setName("restart");
    }

    public void loadLocalPreRaceMenu(ImageLoader il) {
        this.trackSelector = new TrackSelection();
        Console.print("need reload for menu at some point to get players?!");
        this.trackChoiceButtonLeft = new HotSpot();
        this.trackChoiceButtonLeft.setImage(il.getImage("/buttons/button_left_default.png"), 1);
        this.trackChoiceButtonLeft.setSize(this.defaultWidth, this.defaultHeight);
        this.trackChoiceButtonLeft.setName("left");
        this.trackChoiceButtonRight = new HotSpot();
        this.trackChoiceButtonRight.setImage(il.getImage("/buttons/button_right_default.png"), 1);
        this.trackChoiceButtonRight.setSize(this.defaultWidth, this.defaultHeight);
        this.trackChoiceButtonRight.setName("right");
        this.trackChoice = new HotSpot[this.trackSelector.numSelectionsShown];
        int i = 0;
        while (i < this.trackSelector.numSelectionsShown) {
            this.trackChoice[i] = new HotSpot();
            this.trackChoice[i].setImage(il.getImage("/buttons/blankbuttons/button_blue_base_default.png"), 1);
            this.trackChoice[i].setSize(bigbuttonWidth, this.bigbuttonHeight);
            this.trackChoice[i].setName("track" + i);
            ++i;
        }
    }

    public void activateStartMenu() {
        this.activeButtons.add(this.networkGameButton);
        this.activeButtons.add(this.localGameButton);
        if (this.sm != null) {
            this.activeButtons.add(this.soundsOnOffButton);
        }
    }

    public void activateLocalMenu() {
        this.activeButtons.add(this.onePlayerButton);
        this.activeButtons.add(this.twoPlayerButton);
        this.activeButtons.add(this.localSettingsButton);
        if (this.sm != null) {
            this.activeButtons.add(this.soundsOnOffButton);
        }
    }

    public void activateRaceResultsMenu() {
        this.activeButtons.add(this.backButton);
        this.activeButtons.add(this.restartRaceButton);
    }

    public void activateLocalPreRaceMenu() {
        this.activeButtons.removeAllElements();
        int i = 0;
        while (i < this.trackSelector.numSelectionsShown) {
            this.activeButtons.add(this.trackChoice[i]);
            Console.print("adding trackchoice buttons: " + i);
            ++i;
        }
        if (this.trackSelector.leftArrow) {
            this.activeButtons.add(this.trackChoiceButtonLeft);
        }
        if (this.trackSelector.rightArrow) {
            this.activeButtons.add(this.trackChoiceButtonRight);
            Console.print("right arrow should be visible");
        }
        if (this.sm != null) {
            this.activeButtons.add(this.soundsOnOffButton);
        }
        this.activeButtons.add(this.backButton);
        Console.print("activate, buttons size now: " + this.activeButtons.size());
    }

    public void refreshTrackSelection() {
        this.activeButtons.removeAllElements();
        int i = 0;
        while (i < this.trackSelector.numSelectionsShown) {
            this.activeButtons.add(this.trackChoice[i]);
            ++i;
        }
        if (this.trackSelector.leftArrow) {
            this.activeButtons.add(this.trackChoiceButtonLeft);
        }
        if (this.trackSelector.rightArrow) {
            this.activeButtons.add(this.trackChoiceButtonRight);
        }
        if (this.sm != null) {
            this.activeButtons.add(this.soundsOnOffButton);
        }
    }

    public void activateSettingsMenu() {
        this.activeButtons.add(this.assignControlsPlayerTwoButton);
        this.activeButtons.add(this.assignControlsPlayerOneButton);
        this.activeButtons.add(this.backButton);
        if (this.sm != null) {
            this.activeButtons.add(this.soundsOnOffButton);
        }
    }

    public void resizeMenu() {
        scrCenter = SlicksApplet.WIDTH / 2;
        thirdHeight = SlicksApplet.HEIGHT / 3;
        this.localGameButton.setPosition(scrCenter - this.buttonSpacing / 2 - bigbuttonWidth, thirdHeight);
        this.networkGameButton.setPosition(scrCenter + this.buttonSpacing / 2, thirdHeight);
        this.backButton.setPosition(0 + this.buttonSpacing / 2, 0 + this.buttonSpacing / 2);
        this.screenSizeLarger.setPosition(SlicksApplet.WIDTH - 2 * this.smallSquareButtonwh, SlicksApplet.HEIGHT - this.smallSquareButtonwh);
        this.screenSizeSmaller.setPosition(SlicksApplet.WIDTH - this.smallSquareButtonwh, SlicksApplet.HEIGHT - this.smallSquareButtonwh);
        this.onePlayerButton.setPosition(scrCenter - this.buttonSpacing - bigbuttonWidth, thirdHeight);
        this.twoPlayerButton.setPosition(scrCenter + this.buttonSpacing, thirdHeight);
        this.localSettingsButton.setPosition(scrCenter - this.smallbuttonWidth / 2, thirdHeight * 2);
        this.saveSettingsButton.setPosition(scrCenter + this.buttonSpacing, thirdHeight * 2);
        this.resetSettingsButton.setPosition(scrCenter - this.buttonSpacing - this.smallbuttonWidth, thirdHeight * 2);
        this.assignControlsPlayerTwoButton.setPosition(scrCenter + this.buttonSpacing, thirdHeight);
        this.assignControlsPlayerOneButton.setPosition(scrCenter - this.buttonSpacing - this.smallbuttonWidth, thirdHeight);
        this.emptyKeyP1PositionX = scrCenter - this.buttonSpacing - this.smallbuttonWidth / 2;
        this.emptyKeyP1PositionY = SlicksApplet.HEIGHT / 2 + this.emptyKeyHeight;
        this.emptyKeyP2PositionX = scrCenter + this.buttonSpacing + this.smallbuttonWidth / 2;
        this.emptyKeyP2PositionY = SlicksApplet.HEIGHT / 2 + this.emptyKeyHeight;
        this.soundsOnOffButton.setPosition(SlicksApplet.WIDTH - 50, 20);
        this.restartRaceButton.setPosition(scrCenter - bigbuttonWidth / 2, thirdHeight * 2);
        if (Engine.state == 5) {
            this.refreshTrackSelection();
        }
        int choicestartX = scrCenter - 2 * bigbuttonWidth;
        int choiceendX = 0;
        if (this.trackChoice != null) {
            int i = 0;
            while (i < this.trackSelector.numSelectionsShown) {
                this.trackChoice[i].setPosition(choicestartX, 2 * thirdHeight);
                choiceendX = choicestartX += bigbuttonWidth;
                ++i;
            }
        }
        choicestartX = scrCenter - 2 * bigbuttonWidth;
        this.trackChoiceButtonLeft.setPosition(choicestartX - this.defaultWidth, 2 * thirdHeight);
        this.trackChoiceButtonRight.setPosition(choiceendX, 2 * thirdHeight);
        Console.print("buttonleftX: " + (choicestartX - this.defaultWidth) + ", rightx: " + choiceendX);
    }

    public void drawMenu(Graphics g) {
        this.drawBackGround(g);
        this.drawLogo(g);
        try {
            int i = 0;
            while (i < this.activeButtons.size()) {
                if (this.activeButtons.elementAt(i) != null) {
                    this.activeButtons.elementAt(i).paint(g);
                }
                ++i;
            }
        }
        catch (NullPointerException e) {
            Console.print("null pointer?? " + e);
        }
        if (Engine.state == 1 || Engine.state == 2) {
            this.drawControls(g);
            if (this.activeButtons.size() == 0) {
                if (Engine.state == 1) {
                    this.activateStartMenu();
                }
                if (Engine.state == 2) {
                    this.activateLocalMenu();
                }
            }
        }
        if (Engine.state == 4) {
            if (this.sm != null) {
                this.slider_effects.paint(g);
                this.slider_player.paint(g);
            }
            this.drawControls(g);
        }
        if (Engine.state == 5) {
            int i = 0;
            while (i < this.trackSelector.numSelectionsShown) {
                Point xy = this.trackChoice[i].getPosition();
                Point size = this.trackChoice[i].getSize();
                this.font.PrintString(g, xy.x + size.x / 2, xy.y + size.y / 2, this.trackSelector.trackNames.elementAt(this.trackSelector.offset + i), SimpleFont.HCENTER, SimpleFont.BOTTOM);
                ++i;
            }
        }
        if (Engine.state == 8) {
            if (this.results == null) {
                Console.print("results is null!");
            } else {
                this.results.drawResults(g);
            }
        }
        if (this.sm != null) {
            if (this.sm.getMute() && !this.soundIconSwapped) {
                this.soundsOnOffButton.swapImage();
                this.soundIconSwapped = true;
            } else if (!this.sm.getMute() && this.soundIconSwapped) {
                this.soundsOnOffButton.swapImage();
                this.soundIconSwapped = false;
            }
        }
    }

    public void drawControls(Graphics g) {
        g.drawImage(this.emptyKey, this.emptyKeyP1PositionX - this.emptyKeyWidth / 2, this.emptyKeyP1PositionY, null);
        this.font.PrintChar(g, this.emptyKeyP1PositionX, this.emptyKeyP1PositionY + this.emptyKeyHeight / 2, ControlInterface.P1_UP, SimpleFont.HCENTER, SimpleFont.VCENTER);
        g.drawImage(this.emptyKey, this.emptyKeyP1PositionX - this.emptyKeyWidth / 2, this.emptyKeyP1PositionY + this.emptyKeyHeight, null);
        this.font.PrintChar(g, this.emptyKeyP1PositionX, this.emptyKeyP1PositionY + this.emptyKeyHeight + this.emptyKeyHeight / 2, ControlInterface.P1_DOWN, SimpleFont.HCENTER, SimpleFont.VCENTER);
        g.drawImage(this.emptyKey, this.emptyKeyP1PositionX - this.emptyKeyWidth / 2 - this.emptyKeyWidth, this.emptyKeyP1PositionY + this.emptyKeyHeight, null);
        this.font.PrintChar(g, this.emptyKeyP1PositionX - this.emptyKeyWidth, this.emptyKeyP1PositionY + this.emptyKeyHeight + this.emptyKeyHeight / 2, ControlInterface.P1_LEFT, SimpleFont.HCENTER, SimpleFont.VCENTER);
        g.drawImage(this.emptyKey, this.emptyKeyP1PositionX - this.emptyKeyWidth / 2 + this.emptyKeyWidth, this.emptyKeyP1PositionY + this.emptyKeyHeight, null);
        this.font.PrintChar(g, this.emptyKeyP1PositionX + this.emptyKeyWidth, this.emptyKeyP1PositionY + this.emptyKeyHeight + this.emptyKeyHeight / 2, ControlInterface.P1_RIGHT, SimpleFont.HCENTER, SimpleFont.VCENTER);
        g.drawImage(this.emptyKey, this.emptyKeyP2PositionX - this.emptyKeyWidth / 2, this.emptyKeyP2PositionY, null);
        this.font.PrintChar(g, this.emptyKeyP2PositionX, this.emptyKeyP2PositionY + this.emptyKeyHeight / 2, ControlInterface.P2_UP, SimpleFont.HCENTER, SimpleFont.VCENTER);
        g.drawImage(this.emptyKey, this.emptyKeyP2PositionX - this.emptyKeyWidth / 2, this.emptyKeyP2PositionY + this.emptyKeyHeight, null);
        this.font.PrintChar(g, this.emptyKeyP2PositionX, this.emptyKeyP2PositionY + this.emptyKeyHeight + this.emptyKeyHeight / 2, ControlInterface.P2_DOWN, SimpleFont.HCENTER, SimpleFont.VCENTER);
        g.drawImage(this.emptyKey, this.emptyKeyP2PositionX - this.emptyKeyWidth / 2 - this.emptyKeyWidth, this.emptyKeyP2PositionY + this.emptyKeyHeight, null);
        this.font.PrintChar(g, this.emptyKeyP2PositionX - this.emptyKeyWidth, this.emptyKeyP2PositionY + this.emptyKeyHeight + this.emptyKeyHeight / 2, ControlInterface.P2_LEFT, SimpleFont.HCENTER, SimpleFont.VCENTER);
        g.drawImage(this.emptyKey, this.emptyKeyP2PositionX - this.emptyKeyWidth / 2 + this.emptyKeyWidth, this.emptyKeyP2PositionY + this.emptyKeyHeight, null);
        this.font.PrintChar(g, this.emptyKeyP2PositionX + this.emptyKeyWidth, this.emptyKeyP2PositionY + this.emptyKeyHeight + this.emptyKeyHeight / 2, ControlInterface.P2_RIGHT, SimpleFont.HCENTER, SimpleFont.VCENTER);
    }

    public void scrollBackGround(Vector2 vec) {
        if (!(vec.getX() > (double)this.backgrndWidth || vec.getY() > (double)this.backgrndHeight || vec.getX() < (double)(-this.backgrndWidth) || vec.getY() < (double)(-this.backgrndHeight))) {
            this.backgrndScrollerX = (int)((double)this.backgrndScrollerX - vec.getX() * 1.5);
            this.backgrndScrollerY = (int)((double)this.backgrndScrollerY - vec.getY() * 1.5);
            if (this.backgrndScrollerX > this.backgrndWidth) {
                this.backgrndScrollerX -= this.backgrndWidth;
            }
            if (this.backgrndScrollerY > this.backgrndHeight) {
                this.backgrndScrollerY -= this.backgrndHeight;
            }
            if (this.backgrndScrollerX < -this.backgrndWidth) {
                this.backgrndScrollerX += this.backgrndWidth;
            }
            if (this.backgrndScrollerY < -this.backgrndHeight) {
                this.backgrndScrollerY += this.backgrndHeight;
            }
        }
    }

    public void drawLogo(Graphics g) {
        g.drawImage(this.logo, SlicksApplet.WIDTH / 2 - this.logoWidth / 2, thirdHeight / 4, null);
    }

    public void drawBackGround(Graphics g) {
        int tileW = this.background.getWidth(null);
        int tileH = this.background.getHeight(null);
        int i = -1;
        while (i < SlicksApplet.WIDTH / tileW + 2) {
            int j = -1;
            while (j < SlicksApplet.HEIGHT / tileH + 2) {
                g.drawImage(this.background, tileW * i + this.backgrndScrollerX, tileH * j + this.backgrndScrollerY, null);
                ++j;
            }
            ++i;
        }
    }

    public void menuMouseAndButtonGraphics(MouseEvent evt) {
        int curX = evt.getX();
        int curY = evt.getY();
        int i = 0;
        while (i < this.activeButtons.size()) {
            this.activeButtons.elementAt(i).checkMouseOver(curX, curY);
            ++i;
        }
        this.slider_effects.startDrag(curX, curY);
        this.slider_player.startDrag(curX, curY);
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.sm != null) {
            if (this.slider_effects.isDragging()) {
                this.sm.playSound("plik");
                this.slider_effects.stopDrag();
            }
            if (this.slider_player.isDragging()) {
                this.slider_player.stopDrag();
            }
        }
        this.doMouseClick(evt);
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void doMouseClick(MouseEvent evt) {
        int curX = evt.getX();
        int curY = evt.getY();
        Iterator<HotSpot> i = this.activeButtons.iterator();
        switch (Engine.state) {
            case 1: {
                try {
                    while (i.hasNext()) {
                        HotSpot hs = i.next();
                        if (!hs.checkMouseOver(curX, curY)) continue;
                        hs.setMousePressed();
                        if (evt.getButton() != 1) continue;
                        if (hs.name == "mute") {
                            this.mute();
                        }
                        if (hs.name == "localGame") {
                            if (this.sm != null) {
                                this.sm.playSound("plik");
                            }
                            Engine.state = 2;
                            this.activeButtons.removeAllElements();
                            this.activateLocalMenu();
                        }
                        if (hs.name != "netGame") continue;
                        if (this.sm != null) {
                            this.sm.playSound("plik");
                        }
                        Engine.state = 11;
                    }
                }
                catch (ConcurrentModificationException hs) {}
                break;
            }
            case 2: {
                Console.print("state local game");
                if (this.activeButtons.size() == 0) {
                    this.activateLocalMenu();
                }
                try {
                    while (i.hasNext()) {
                        HotSpot hs = i.next();
                        if (!hs.checkMouseOver(curX, curY)) continue;
                        hs.setMousePressed();
                        if (evt.getButton() != 1) continue;
                        if (hs.name == "mute") {
                            this.mute();
                        }
                        if (hs.name == "onePlayerGame") {
                            if (this.sm != null) {
                                this.sm.playSound("plik");
                            }
                            Console.print("state_local_num_players clicked");
                            Engine.numPlayers = 1;
                            this.activateLocalPreRaceMenu();
                            Engine.state = 5;
                            continue;
                        }
                        if (hs.name == "twoPlayerGame") {
                            if (this.sm != null) {
                                this.sm.playSound("plik");
                            }
                            Console.print("state_local_num_players clicked");
                            Engine.numPlayers = 2;
                            this.activateLocalPreRaceMenu();
                            Engine.state = 5;
                            continue;
                        }
                        if (hs.name == "back") {
                            if (this.sm != null) {
                                this.sm.playSound("plik");
                            }
                            Console.print("back");
                            Engine.state = 2;
                            this.activeButtons.removeAllElements();
                            this.activateStartMenu();
                            continue;
                        }
                        if (hs.name != "localSettings") continue;
                        if (this.sm != null) {
                            this.sm.playSound("plik");
                        }
                        Engine.state = 4;
                        this.activeButtons.removeAllElements();
                        this.activateSettingsMenu();
                    }
                }
                catch (ConcurrentModificationException hs) {}
                break;
            }
            case 4: {
                try {
                    while (i.hasNext()) {
                        HotSpot hs = i.next();
                        if (!hs.checkMouseOver(curX, curY)) continue;
                        hs.setMousePressed();
                        if (evt.getButton() != 1) continue;
                        if (hs.name == "mute") {
                            this.mute();
                        }
                        if (hs.name != "back") continue;
                        Console.print("back");
                        if (this.sm != null) {
                            this.sm.playSound("plik");
                        }
                        Engine.state = 2;
                        this.activeButtons.removeAllElements();
                        this.activateLocalMenu();
                    }
                }
                catch (ConcurrentModificationException hs) {}
                break;
            }
            case 5: {
                try {
                    Console.print("state_local_trackselect_mouseclicked");
                    while (i.hasNext()) {
                        HotSpot hs = i.next();
                        if (!hs.checkMouseOver(curX, curY)) continue;
                        Console.print("found button:" + hs.name);
                        hs.setMousePressed();
                        if (evt.getButton() != 1) continue;
                        if (hs.name == "mute") {
                            this.mute();
                        }
                        if (hs.name.contains("track")) {
                            if (this.sm != null) {
                                this.sm.playSound("plik");
                            }
                            char c = hs.name.charAt(5);
                            String num = String.valueOf(c);
                            int numberVal = Integer.parseInt(num);
                            Console.print("track button " + numberVal + ", offset " + this.trackSelector.offset);
                            try {
                                TrackSelection.selectedTrack = this.trackSelector.trackNamesWithExtensions.elementAt(numberVal + this.trackSelector.offset);
                            }
                            catch (Exception e) {
                                Console.print("no track??");
                            }
                            if (TrackSelection.selectedTrack == null) {
                                Console.print("null selectedTrack");
                            }
                            if (this.trackSelector.trackNamesWithExtensions == null) {
                                Console.print("null selectedTrack");
                            }
                            Console.print("selected track name " + TrackSelection.selectedTrack);
                            Engine.state = 6;
                            this.activeButtons.removeAllElements();
                        }
                        if (hs.name == "left") {
                            if (this.sm != null) {
                                this.sm.playSound("plik");
                            }
                            this.trackSelector.moveLeft();
                            this.refreshTrackSelection();
                        }
                        if (hs.name == "right") {
                            if (this.sm != null) {
                                this.sm.playSound("plik");
                            }
                            this.trackSelector.moveRight();
                            this.refreshTrackSelection();
                            continue;
                        }
                        if (hs.name != "back") continue;
                        if (this.sm != null) {
                            this.sm.playSound("plik");
                        }
                        Console.print("back");
                        Engine.state = 2;
                        this.activeButtons.removeAllElements();
                        this.activateLocalMenu();
                    }
                }
                catch (ConcurrentModificationException hs) {}
                break;
            }
            case 8: {
                try {
                    while (i.hasNext()) {
                        HotSpot hs = i.next();
                        if (!hs.checkMouseOver(curX, curY)) continue;
                        hs.setMousePressed();
                        if (evt.getButton() != 1) continue;
                        if (hs.name == "back") {
                            Console.print("back");
                            Engine.state = 2;
                            this.activeButtons.removeAllElements();
                            this.activateLocalMenu();
                            Engine.nullModel();
                        }
                        if (hs.name != "restart") continue;
                        Console.print("restart!");
                        Engine.nullModel();
                        Engine.state = 9;
                        this.activeButtons.removeAllElements();
                    }
                    break;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
        }
    }

    public void mute() {
        if (this.sm != null) {
            if (this.sm.getMute()) {
                this.sm.setMute(false);
                this.soundIconSwapped = false;
                this.sm.playSound("plik");
                this.soundsOnOffButton.swapImage();
            } else {
                this.sm.setMute(true);
                this.soundIconSwapped = true;
                this.soundsOnOffButton.swapImage();
            }
        }
    }

    public void mouseMoved(MouseEvent evt) {
        int curX = evt.getX();
        if (this.sm != null) {
            if (this.slider_effects.isDragging()) {
                this.slider_effects.drag(curX);
                this.sm.setEffectsVolume(this.slider_effects.getAmount());
            }
            if (this.slider_player.isDragging()) {
                this.slider_player.drag(curX);
                this.sm.setPlayerGain(this.slider_player.getAmount());
            }
        }
    }
}

