/*
 * Decompiled with CFR 0.152.
 */
package slicks.ui;

import java.awt.Point;
import slicks.engine.Engine;
import slicks.model.Player;
import slicks.ui.Renderer;

public class Camera {
    Player pCam;
    Point cameraPosition;
    Point trackSize;
    Point screenSize;
    public int cameraAdjustmentX;
    public int cameraAdjustmentY;

    public Camera(Player defaultPlayer) {
        this.pCam = defaultPlayer;
        this.cameraPosition = this.pCam.myCar.getPos();
    }

    public void setTrackSize(Point trackdim) {
        this.trackSize = trackdim;
    }

    public void setScreenSize(Point screendim) {
        this.screenSize = screendim;
    }

    public void adjustPosition() {
        int pPosX = (int)((double)(this.pCam.myCar.getPos().x / Engine.COORD_FACTOR) * Renderer.screenRatio[Renderer.resolution]);
        int pPosY = (int)((double)(this.pCam.myCar.getPos().y / Engine.COORD_FACTOR) * Renderer.screenRatio[Renderer.resolution]);
        int screenShiftX = this.screenSize.x / 2 - pPosX;
        int screenShiftY = this.screenSize.y / 2 - pPosY;
        if (screenShiftX > 0) {
            screenShiftX = 0;
        }
        if (screenShiftX < -(this.trackSize.x - this.screenSize.x)) {
            screenShiftX = -(this.trackSize.x - this.screenSize.x);
        }
        if (screenShiftY > 0) {
            screenShiftY = 0;
        }
        if (screenShiftY < -(this.trackSize.y - this.screenSize.y)) {
            screenShiftY = -(this.trackSize.y - this.screenSize.y);
        }
        this.cameraAdjustmentX = screenShiftX;
        this.cameraAdjustmentY = screenShiftY;
    }
}

