/*
 * Decompiled with CFR 0.152.
 */
package slicks.sound;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.java.games.joal.AL;
import net.java.games.joal.ALC;
import net.java.games.joal.ALFactory;
import net.java.games.joal.util.ALut;
import slicks.sound.OggStreamer;
import slicks.sound.SoundClip;
import slicks.sound.SoundList;
import slicks.sound.SoundMan;

public class SoundManager
implements SoundList,
SoundMan {
    public static final int PLAY = 1;
    public static final int PAUSE = 2;
    public static final int NEXT = 3;
    public static final int PREVIOUS = 4;
    public static final int STOP = 0;
    public static final int EXIT = 5;
    private float[] listenerPos = new float[]{0.0f, 0.0f, 0.0f};
    private float[] listenerVel = new float[]{0.0f, 0.0f, 0.0f};
    private float[] listenerOri = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f};
    private static AL al;
    private ALC alc;
    private static Vector<String> loadedFiles;
    private static Vector<Integer> buffers;
    private static Vector<Integer> sources;
    private int effectsVolume = 100;
    private int playerVolume = 100;
    private Hashtable<String, SoundClip> sounds = new Hashtable(100);
    private boolean muted = false;
    public static OggStreamer player;

    static {
        loadedFiles = new Vector();
        buffers = new Vector();
        sources = new Vector();
    }

    public SoundManager() throws Exception {
        this.init();
        player = new OggStreamer(al);
        player.setTrack(0);
        player.start();
        try {
            this.loadALData();
        }
        catch (IOException err) {
            err.printStackTrace();
        }
        this.setListenerValues();
    }

    @Override
    public void loadALData() throws IOException {
        int i = 0;
        while (i < CLIPS.length) {
            String name = CLIPS[i][0];
            String path = CLIPS[i][1];
            Float pitch = new Float(CLIPS[i][2]);
            int volume = new Integer(CLIPS[i][3]);
            boolean loop = false;
            if (CLIPS[i][4] == "true") {
                loop = true;
            }
            this.loadALSample(name, path, pitch.floatValue(), volume, loop);
            ++i;
        }
        this.killALLoadedTempData();
    }

    private void killALLoadedTempData() {
        loadedFiles.clear();
    }

    private void setListenerValues() {
        al.alListenerfv(4100, this.listenerPos, 0);
        al.alListenerfv(4102, this.listenerVel, 0);
        al.alListenerfv(4111, this.listenerOri, 0);
    }

    @Override
    public void killALData() {
        this.sounds.clear();
        Iterator<Integer> iter = buffers.iterator();
        while (iter.hasNext()) {
            al.alDeleteBuffers(1, new int[]{iter.next()}, 0);
        }
        iter = sources.iterator();
        while (iter.hasNext()) {
            al.alDeleteSources(1, new int[]{iter.next()}, 0);
        }
        buffers.clear();
        sources.clear();
        ALut.alutExit();
    }

    @Override
    public void init() throws Exception {
        ALut.alutInit();
        al = ALFactory.getAL();
        al.alGetError();
    }

    private static int getLoadedALBuffer(String path) throws IOException {
        Iterator<String> iter = loadedFiles.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String str = iter.next();
            if (str.equals(path)) {
                return buffers.get(i);
            }
            ++i;
        }
        int buffer = SoundManager.loadALBuffer(path);
        buffers.add(new Integer(buffer));
        loadedFiles.add(path);
        return buffer;
    }

    private static int loadALBuffer(String path) throws IOException {
        int[] format = new int[1];
        int[] size = new int[1];
        ByteBuffer[] data = new ByteBuffer[1];
        int[] freq = new int[1];
        int[] loop = new int[1];
        int[] buffer = new int[1];
        al.alGenBuffers(1, buffer, 0);
        SoundManager.check();
        ALut.alutLoadWAVFile(path, format, data, size, freq, loop);
        SoundManager.check();
        al.alBufferData(buffer[0], format[0], data[0], size[0], freq[0]);
        SoundManager.check();
        return buffer[0];
    }

    public int loadALSample(String name, String path, float pitch, int clipsVolume, boolean loop) throws IOException {
        int[] source = new int[1];
        int buffer = SoundManager.getLoadedALBuffer(path);
        al.alGenSources(1, source, 0);
        SoundManager.check();
        this.sounds.put(name, new SoundClip(this, al, source[0], buffer, 1.0f, 10, loop));
        sources.add(new Integer(source[0]));
        return source[0];
    }

    private static String getALErrorString(int err) {
        switch (err) {
            case 0: {
                return "AL_NO_ERROR";
            }
            case 40961: {
                return "AL_INVALID_NAME";
            }
            case 40962: {
                return "AL_INVALID_ENUM";
            }
            case 40963: {
                return "AL_INVALID_VALUE";
            }
            case 40964: {
                return "AL_INVALID_OPERATION";
            }
            case 40965: {
                return "AL_OUT_OF_MEMORY";
            }
        }
        return null;
    }

    private static String getALCErrorString(int err) {
        switch (err) {
            case 0: {
                return "ALC_NO_ERROR";
            }
            case 40961: {
                return "ALC_INVALID_DEVICE";
            }
            case 40962: {
                return "ALC_INVALID_CONTEXT";
            }
            case 40963: {
                return "ALC_INVALID_ENUM";
            }
            case 40964: {
                return "ALC_INVALID_VALUE";
            }
            case 40965: {
                return "ALC_OUT_OF_MEMORY";
            }
        }
        return null;
    }

    @Override
    public int getEffectsVolume() {
        return this.effectsVolume;
    }

    @Override
    public void setEffectsVolume(int volume) {
        this.effectsVolume = volume;
        if (this.muted) {
            volume = 0;
        }
        Iterator<Integer> iter = sources.iterator();
        while (iter.hasNext()) {
            al.alSourcef(iter.next(), 4106, 0.01f * (float)volume);
        }
    }

    @Override
    public void setListenerPos(float x, float y, float z) {
        al.alListener3f(4100, x, y, z);
    }

    @Override
    public float[] getListenerPos() {
        float[] result = new float[3];
        al.alGetListenerfv(4100, result, 0);
        return result;
    }

    @Override
    public void setListenerVel(float x, float y, float z) {
        al.alListener3f(4102, x, y, z);
    }

    @Override
    public float[] getListenerVel() {
        float[] result = new float[3];
        al.alGetListenerfv(4102, result, 0);
        return result;
    }

    @Override
    public void playSound(String sound) {
        this.sounds.get(sound).play();
    }

    @Override
    public void stopSound(String sound) {
        this.sounds.get(sound).stop();
    }

    @Override
    public void pauseSound(String sound) {
        this.sounds.get(sound).pause();
    }

    @Override
    public SoundClip getSoundObject(String sound) {
        return this.sounds.get(sound);
    }

    @Override
    public boolean isPlaying(String sound) {
        return this.sounds.get(sound).isPlaying();
    }

    private static void check() throws IOException {
        int result = al.alGetError();
        if (result != 0) {
            throw new IOException(SoundManager.getALErrorString(result));
        }
    }

    @Override
    public void setMute(boolean mute) {
        this.muted = mute;
        this.setEffectsVolume(this.effectsVolume);
        player.setGain(this.playerVolume, mute);
    }

    @Override
    public boolean getMute() {
        return this.muted;
    }

    @Override
    public void prevTrack() {
        player.setPlayerState(4);
    }

    @Override
    public void nextTrack() {
        player.setPlayerState(3);
    }

    @Override
    public void play() {
        player.setPlayerState(1);
    }

    @Override
    public void pause() {
        player.setPlayerState(2);
    }

    @Override
    public void stopPaying() {
        player.setPlayerState(0);
    }

    @Override
    public void exit() {
        player.setPlayerState(5);
    }

    @Override
    public void setPlayerGain(int vol) {
        this.playerVolume = vol;
        player.setGain(this.playerVolume, false);
    }
}

