/*
 * Decompiled with CFR 0.152.
 */
package slicks.sound;

import java.io.ByteArrayInputStream;
import java.io.IOException;

public class LoopingByteInputStream
extends ByteArrayInputStream {
    private boolean closed = false;

    public LoopingByteInputStream(byte[] buffer) {
        super(buffer);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) {
        if (this.closed) {
            return -1;
        }
        int totalBytesRead = 0;
        while (totalBytesRead < length) {
            int numBytesRead = super.read(buffer, offset + totalBytesRead, length - totalBytesRead);
            if (numBytesRead > 0) {
                totalBytesRead += numBytesRead;
                continue;
            }
            this.reset();
        }
        return totalBytesRead;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }
}

