/*
 * Decompiled with CFR 0.152.
 */
package slicks.sound;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import slicks.sound.FilteredSoundStream;
import slicks.sound.LoopingByteInputStream;
import slicks.sound.Sound;
import slicks.sound.SoundFilter;
import slicks.sound.ThreadPool;

public class JSoundManager
extends ThreadPool {
    private AudioFormat playbackFormat;
    private ThreadLocal<SourceDataLine> localLine;
    private ThreadLocal<byte[]> localBuffer;
    private Object pausedLock;
    private boolean paused;
    private Mixer mixer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSoundManager(AudioFormat playbackFormat, int maxSimultaneousSounds) {
        super(maxSimultaneousSounds);
        this.playbackFormat = playbackFormat;
        this.localLine = new ThreadLocal();
        this.localBuffer = new ThreadLocal();
        this.pausedLock = new Object();
        this.mixer = AudioSystem.getMixer(null);
        JSoundManager jSoundManager = this;
        synchronized (jSoundManager) {
            this.notifyAll();
        }
    }

    protected void cleanUp() {
        this.setPaused(false);
        if (this.mixer.isOpen()) {
            this.mixer.close();
        }
    }

    @Override
    public void close() {
        this.cleanUp();
        super.close();
    }

    @Override
    public void join() {
        this.cleanUp();
        super.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean paused) {
        if (this.paused != paused) {
            Object object = this.pausedLock;
            synchronized (object) {
                this.paused = paused;
                if (!paused) {
                    this.pausedLock.notifyAll();
                }
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public Sound getSound(String filename) {
        AudioInputStream audioStream = null;
        try {
            audioStream = AudioSystem.getAudioInputStream(new File(filename));
            audioStream = AudioSystem.getAudioInputStream(this.playbackFormat, audioStream);
        }
        catch (UnsupportedAudioFileException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        if (audioStream == null) {
            return null;
        }
        int length = (int)(audioStream.getFrameLength() * (long)audioStream.getFormat().getFrameSize());
        byte[] buffer = new byte[length];
        DataInputStream is = new DataInputStream(audioStream);
        try {
            is.readFully(buffer);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return new Sound(buffer);
    }

    public InputStream play(Sound sound) {
        return this.play(sound, null, false);
    }

    public InputStream play(Sound sound, SoundFilter filter, boolean loop) {
        if (sound != null) {
            ByteArrayInputStream is = loop ? new LoopingByteInputStream(sound.getSamples()) : new ByteArrayInputStream(sound.getSamples());
            return this.play(is, filter);
        }
        return null;
    }

    public InputStream play(InputStream is, SoundFilter filter) {
        if (is != null) {
            if (filter != null) {
                is = new FilteredSoundStream(is, filter);
            }
            this.runTask(new SoundPlayer(is));
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void threadStarted() {
        SourceDataLine line;
        JSoundManager jSoundManager = this;
        synchronized (jSoundManager) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int bufferSize = this.playbackFormat.getFrameSize() * Math.round(this.playbackFormat.getSampleRate() / 10.0f);
        DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, this.playbackFormat);
        try {
            line = (SourceDataLine)AudioSystem.getLine(lineInfo);
            line.open(this.playbackFormat, bufferSize);
        }
        catch (LineUnavailableException ex) {
            Thread.currentThread().interrupt();
            return;
        }
        line.start();
        byte[] buffer = new byte[bufferSize];
        this.localLine.set(line);
        this.localBuffer.set(buffer);
    }

    @Override
    protected void threadStopped() {
        SourceDataLine line = this.localLine.get();
        if (line != null) {
            line.drain();
            line.close();
        }
    }

    protected class SoundPlayer
    implements Runnable {
        private InputStream source;

        public SoundPlayer(InputStream source) {
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SourceDataLine line = (SourceDataLine)JSoundManager.this.localLine.get();
            byte[] buffer = (byte[])JSoundManager.this.localBuffer.get();
            if (line == null || buffer == null) {
                return;
            }
            try {
                int numBytesRead = 0;
                while (numBytesRead != -1) {
                    Object object = JSoundManager.this.pausedLock;
                    synchronized (object) {
                        if (JSoundManager.this.paused) {
                            try {
                                JSoundManager.this.pausedLock.wait();
                            }
                            catch (InterruptedException ex) {
                                return;
                            }
                        }
                    }
                    numBytesRead = this.source.read(buffer, 0, buffer.length);
                    if (numBytesRead == -1) continue;
                    line.write(buffer, 0, numBytesRead);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

