/*
 * Decompiled with CFR 0.152.
 */
package slicks.model;

import editor.TrackPanel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import other.Console;
import slicks.model.Track;
import slicks.model.TrackBlock;
import slicks.model.TrackMarker;

public class TrackReadWrite {
    public int currentVersion = 3;
    public int loadingVersion = 0;

    public void writeTrack(Track track, String name) throws IOException {
        FileOutputStream fos = new FileOutputStream(name);
        DataOutputStream s = new DataOutputStream(fos);
        s.writeUTF("VERSION");
        s.writeInt(this.currentVersion);
        s.writeUTF("WIDTH");
        s.writeInt(track.width);
        s.writeUTF("HEIGHT");
        s.writeInt(track.height);
        s.writeUTF("NAME");
        s.writeUTF(track.trackName);
        Console.print("bkgrounds");
        s.writeUTF("BACKGROUNDS");
        this.writeVectorBlock03(track.backgroundpieces, s);
        s.writeUTF("/BACKGROUNDS");
        Console.print("trackpieces");
        s.writeUTF("TRACKPIECES");
        this.writeVectorBlock03(track.trackpieces, s);
        s.writeUTF("/TRACKPIECES");
        Console.print("solids");
        s.writeUTF("SOLIDPIECES");
        this.writeVectorBlock03(track.solidpieces, s);
        s.writeUTF("/SOLIDPIECES");
        Console.print("objects");
        s.writeUTF("OBJECTPIECES");
        this.writeVectorBlock03(track.objectpieces, s);
        s.writeUTF("/OBJECTPIECES");
        Console.print("markers");
        s.writeUTF("MARKERPIECES");
        this.writeVectorMarker02(track.markerpieces, s);
        s.writeUTF("/MARKERPIECES");
        Console.print("created");
        s.writeUTF("CREATEDPIECES");
        this.writeVectorBlock03(track.createdpieces, s);
        s.writeUTF("/CREATEDPIECES");
        Console.print("shadows");
        s.writeUTF("SHADOWPIECES");
        this.writeVectorBlock03(track.shadowpieces, s);
        s.writeUTF("/SHADOWPIECES");
        Console.print("invisibles");
        s.writeUTF("INVISIBLEPIECES");
        this.writeVectorMarker02(track.invisiblepieces, s);
        s.writeUTF("/INVISIBLEPIECES");
        s.flush();
        s.close();
    }

    public void chooseVersion(URL url, Track track) throws IOException {
        Console.print("URL: " + url);
        DataInputStream s = new DataInputStream(url.openStream());
        s.readUTF();
        track.version = s.readInt();
        if (track.version == 1) {
            this.loadingVersion = 1;
        }
        if (track.version == 2) {
            this.loadingVersion = 2;
        }
        if (track.version == 3) {
            this.loadingVersion = 3;
        }
        this.readVersion(s, track);
    }

    public void readBasicHeader(DataInputStream s, Track track) throws IOException {
        s.readUTF();
        track.width = s.readInt();
        s.readUTF();
        track.height = s.readInt();
        s.readUTF();
        track.trackName = s.readUTF();
        Console.print("version: " + track.version);
        Console.print("width: " + track.width);
        Console.print("height: " + track.height);
        Console.print("trackName: " + track.trackName);
    }

    public void readTrackPieces(DataInputStream s, Track track) throws IOException {
        boolean size = false;
        Track.numControlPoints = 0;
        Console.print("bkgrnds");
        s.readUTF();
        this.readBlockIntoVector(track.backgroundpieces, s);
        s.readUTF();
        Console.print("pieces");
        s.readUTF();
        this.readBlockIntoVector(track.trackpieces, s);
        s.readUTF();
        Console.print("solid");
        s.readUTF();
        this.readBlockIntoVector(track.solidpieces, s);
        s.readUTF();
        Console.print("objects");
        s.readUTF();
        this.readBlockIntoVector(track.objectpieces, s);
        s.readUTF();
        Console.print("markers");
        s.readUTF();
        this.readMarkerIntoVector(track.markerpieces, s);
        s.readUTF();
        Console.print("created");
        s.readUTF();
        this.readBlockIntoVector(track.createdpieces, s);
        s.readUTF();
        Console.print("shadow");
        s.readUTF();
        this.readBlockIntoVector(track.shadowpieces, s);
        s.readUTF();
        Console.print("invisible");
        s.readUTF();
        this.readMarkerIntoVector(track.invisiblepieces, s);
        s.readUTF();
    }

    public void readVersion(DataInputStream s, Track track) throws IOException {
        this.readBasicHeader(s, track);
        this.readTrackPieces(s, track);
        s.close();
    }

    public void readBlockIntoVector(Vector vec, DataInputStream s) throws IOException {
        if (vec != null) {
            s.readUTF();
            int size = s.readInt();
            Console.print("block vecsize: " + size);
            while (size > 0) {
                TrackBlock bl = new TrackBlock();
                if (this.loadingVersion == 1 || this.loadingVersion == 2) {
                    this.readVectorBlock01(s, bl);
                }
                if (this.loadingVersion == 3) {
                    this.readVectorBlock03(s, bl);
                }
                vec.add(bl);
                --size;
            }
        } else {
            Console.print("Vector WAS NULL!");
        }
    }

    public void readMarkerIntoVector(Vector vec, DataInputStream s) throws IOException {
        if (vec != null) {
            s.readUTF();
            int size = s.readInt();
            Console.print("marker vecsize: " + size);
            while (size > 0) {
                TrackMarker bl = new TrackMarker();
                if (this.loadingVersion == 1) {
                    this.readVectorMarker01(s, bl);
                }
                if (this.loadingVersion == 2 || this.loadingVersion == 3) {
                    this.readVectorMarker02(s, bl);
                }
                if (bl.markerType == 1) {
                    Console.print("Found Starting Grid");
                    Track.startgrid = new TrackMarker(bl);
                }
                if (bl.markerType == 2 || bl.markerType == 3) {
                    ++Track.numControlPoints;
                }
                Console.print("adding " + bl.name + " at " + bl.x + "," + bl.y);
                vec.add(bl);
                --size;
            }
        }
    }

    public void writeVectorBlock01(Vector<TrackBlock> vec, DataOutputStream s) throws IOException {
        if (vec != null) {
            int size = vec.size();
            Console.print("write block1 vecsize: " + size);
            s.writeUTF("VECSIZE");
            s.writeInt(size);
            int i = 0;
            while (i < size) {
                s.writeUTF("BLOCK");
                TrackBlock block = vec.elementAt(i);
                s.writeUTF("NAME");
                s.writeUTF(block.name);
                s.writeUTF("FILENAME");
                s.writeUTF(block.filename);
                s.writeUTF("TYPE");
                s.writeInt(block.type);
                s.writeUTF("X");
                s.writeInt(block.x);
                s.writeUTF("Y");
                s.writeInt(block.y);
                ++i;
            }
        }
    }

    public void writeVectorBlock03(Vector<TrackBlock> vec, DataOutputStream s) throws IOException {
        if (vec != null) {
            int size = vec.size();
            Console.print("write block3 vecsize: " + size);
            s.writeUTF("VECSIZE");
            s.writeInt(size);
            int i = 0;
            while (i < size) {
                s.writeUTF("BLOCK");
                TrackBlock block = vec.elementAt(i);
                s.writeUTF("NAME");
                s.writeUTF(block.name);
                s.writeUTF("FILENAME");
                s.writeUTF(block.filename);
                s.writeUTF("TYPE");
                s.writeInt(block.type);
                s.writeUTF("X");
                s.writeInt(block.x);
                s.writeUTF("Y");
                s.writeInt(block.y);
                s.writeUTF("ROTATION");
                s.writeFloat(block.rotationDegree);
                ++i;
            }
        }
    }

    public void writeVectorMarker01(Vector<TrackMarker> vec, DataOutputStream s) throws IOException {
        if (vec != null) {
            int size = vec.size();
            s.writeUTF("VECSIZE");
            s.writeInt(size);
            int i = 0;
            while (i < size) {
                s.writeUTF("MARKER");
                TrackMarker marker = vec.elementAt(i);
                s.writeUTF("NAME");
                s.writeUTF(marker.name);
                s.writeUTF("FILENAME");
                s.writeUTF(marker.filename);
                s.writeUTF("TYPE");
                s.writeInt(marker.type);
                s.writeUTF("MARKERTYPE");
                s.writeInt(marker.markerType);
                s.writeUTF("X");
                s.writeInt(marker.x);
                s.writeUTF("Y");
                s.writeInt(marker.y);
                ++i;
            }
        }
    }

    public void writeVectorMarker02(Vector<TrackMarker> vec, DataOutputStream s) throws IOException {
        if (vec != null) {
            int size = vec.size();
            Console.print("write marker2 vecsize: " + size);
            s.writeUTF("VECSIZE");
            s.writeInt(size);
            int i = 0;
            while (i < size) {
                s.writeUTF("MARKER");
                TrackMarker marker = vec.elementAt(i);
                s.writeUTF("NAME");
                s.writeUTF(marker.name);
                s.writeUTF("FILENAME");
                s.writeUTF(marker.filename);
                s.writeUTF("TYPE");
                s.writeInt(marker.type);
                s.writeUTF("MARKERTYPE");
                s.writeInt(marker.markerType);
                Console.print("WRITING MARKERTYPE: " + marker.markerType);
                s.writeUTF("X");
                s.writeInt(marker.x);
                s.writeUTF("Y");
                s.writeInt(marker.y);
                s.writeUTF("ControlPointWidth");
                s.writeInt(marker.controlPointWidth);
                s.writeUTF("ControlPointHeight");
                s.writeInt(marker.controlPointHeight);
                ++i;
            }
        }
    }

    public void readVectorBlock01(DataInputStream s, TrackBlock block) throws IOException {
        s.readUTF();
        s.readUTF();
        block.name = s.readUTF();
        s.readUTF();
        block.filename = s.readUTF();
        s.readUTF();
        block.type = s.readInt();
        s.readUTF();
        block.x = s.readInt();
        s.readUTF();
        block.y = s.readInt();
    }

    public void readVectorBlock03(DataInputStream s, TrackBlock block) throws IOException {
        s.readUTF();
        s.readUTF();
        block.name = s.readUTF();
        s.readUTF();
        block.filename = s.readUTF();
        s.readUTF();
        block.type = s.readInt();
        s.readUTF();
        block.x = s.readInt();
        s.readUTF();
        block.y = s.readInt();
        s.readUTF();
        block.rotationDegree = s.readFloat();
    }

    public void readVectorMarker01(DataInputStream s, TrackMarker marker) throws IOException {
        s.readUTF();
        s.readUTF();
        marker.name = s.readUTF();
        s.readUTF();
        marker.filename = s.readUTF();
        s.readUTF();
        marker.type = s.readInt();
        s.readUTF();
        marker.markerType = s.readInt();
        s.readUTF();
        marker.x = s.readInt();
        s.readUTF();
        marker.y = s.readInt();
        Console.print("read marker: " + marker.name + "," + marker.type + "," + marker.x + "," + marker.y);
    }

    public void readVectorMarker02(DataInputStream s, TrackMarker marker) throws IOException {
        s.readUTF();
        s.readUTF();
        marker.name = s.readUTF();
        s.readUTF();
        marker.filename = s.readUTF();
        s.readUTF();
        marker.type = s.readInt();
        s.readUTF();
        marker.markerType = s.readInt();
        Console.print("MARKERTYPE ON LOAD :" + marker.markerType);
        s.readUTF();
        marker.x = s.readInt();
        s.readUTF();
        marker.y = s.readInt();
        s.readUTF();
        marker.controlPointWidth = s.readInt();
        s.readUTF();
        marker.controlPointHeight = s.readInt();
        if (marker.markerType == 2 || marker.markerType == 3) {
            ++TrackPanel.numControlPoints;
        }
        Console.print("Read marker: " + marker.name + "," + marker.type + "," + marker.x + "," + marker.y + " cpWH " + marker.controlPointWidth + "," + marker.controlPointHeight);
    }
}

