/*
 * Decompiled with CFR 0.152.
 */
package slicks.model;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import slicks.model.TrackBlock;

public class TrackMarker
extends TrackBlock {
    public static final int MARKER_TYPE_STARTING_POSITION_PIECE = 1;
    public static final int MARKER_TYPE_CHECKPOINT_HORIZONTAL = 2;
    public static final int MARKER_TYPE_CHECKPOINT_VERTICAL = 3;
    public static final int MARKER_TYPE_UNDERBRIDGE = 4;
    public int markerType;
    public int controlPointWidth = 0;
    public int controlPointHeight = 0;

    public TrackMarker() {
    }

    public TrackMarker(String name) {
        this.name = name;
    }

    public TrackMarker(TrackBlock selectedPiece) {
        this.name = new String(selectedPiece.name);
        this.type = new Integer(selectedPiece.type);
        this.x = new Integer(selectedPiece.x);
        this.y = new Integer(selectedPiece.y);
        this.localX = new Integer(selectedPiece.localX);
        this.localY = new Integer(selectedPiece.localY);
        this.width = new Integer(selectedPiece.width);
        this.height = new Integer(selectedPiece.height);
        this.blockImg = selectedPiece.blockImg;
        this.filename = new String(selectedPiece.filename);
        try {
            this.heightmapname = new String(selectedPiece.heightmapname);
            this.collisionname = new String(selectedPiece.collisionname);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Vector<Point> findStartingPositions() {
        Vector<Point> points = new Vector<Point>();
        int i = 0;
        while (i < 20) {
            Point pt = new Point(0, 0);
            points.add(pt);
            ++i;
        }
        int widthscan = 0;
        while (widthscan < this.width) {
            int heightscan = 0;
            while (heightscan < this.height) {
                int c = this.blockImg.getRGB(widthscan, heightscan);
                Color color = new Color(c);
                if (c != 0) {
                    if (color.getRed() > 0) {
                        // empty if block
                    }
                    int redvalue = color.getRed();
                    int pos = redvalue / 5 - 1;
                    points.elementAt((int)pos).x = widthscan + this.x;
                    points.elementAt((int)pos).y = heightscan + this.y;
                }
                ++heightscan;
            }
            ++widthscan;
        }
        return points;
    }

    public void setMarkerType(int markerType) {
        this.type = markerType;
    }

    public Line2D.Double makeControlLineFromMarker() {
        Point2D.Double pt1 = new Point2D.Double(this.x, this.y);
        Point2D.Double pt2 = null;
        pt2 = this.controlPointHeight == 0 ? new Point2D.Double(this.x + this.controlPointWidth, this.y) : new Point2D.Double(this.x, this.y + this.controlPointHeight);
        Line2D.Double line = new Line2D.Double(pt1, pt2);
        return line;
    }

    public void drawControlPoints(Graphics g, int offsetX, int offsetY, boolean selected) {
        if (selected) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.blue);
        }
        g.drawString(this.name, offsetX + this.x, offsetY + this.y);
        if (this.markerType == 2) {
            g.drawLine(offsetX + this.x, offsetY + this.y, offsetX + this.x + this.controlPointWidth, offsetY + this.y);
            g.drawString(this.name, offsetX + this.x + this.controlPointWidth + 1, offsetY + this.y - 1);
        }
        if (this.markerType == 3) {
            g.drawLine(offsetX + this.x, offsetY + this.y, offsetX + this.x, offsetY + this.y + this.controlPointHeight);
            g.drawString(this.name, offsetX + this.x + 1, offsetY + this.y + this.controlPointHeight);
        }
    }
}

