/*
 * Decompiled with CFR 0.152.
 */
package slicks.model;

import java.awt.Point;
import java.awt.geom.Line2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Vector;
import other.Console;
import slicks.client.SlicksApplet;
import slicks.engine.Engine;
import slicks.model.GroundType;
import slicks.model.TrackBlock;
import slicks.model.TrackMarker;
import slicks.ui.Renderer;

public class Track {
    private static final long serialVersionUID = 1L;
    public int version;
    GroundType gtAsphalt;
    GroundType gtSolid;
    GroundType gtSand;
    GroundType gtTurf;
    GroundType gtVoid;
    public int width = 1280;
    public int height = 720;
    public int localW;
    public int localH;
    public String trackName;
    public Vector<TrackBlock> backgroundpieces = new Vector();
    public Vector<TrackBlock> trackpieces = new Vector();
    public Vector<TrackBlock> solidpieces;
    public Vector<TrackBlock> objectpieces;
    public Vector<TrackMarker> markerpieces;
    public Vector<TrackBlock> createdpieces;
    public Vector<TrackBlock> overcarspieces;
    public Vector<TrackBlock> shadowpieces;
    public Vector<TrackMarker> invisiblepieces = new Vector();
    public static TrackMarker startgrid;
    public static int numControlPoints;
    public static Vector<Line2D.Double> controlPointLines;

    static {
        numControlPoints = 0;
    }

    public Track() {
        this.markerpieces = new Vector();
        this.solidpieces = new Vector();
        this.shadowpieces = new Vector();
        this.overcarspieces = new Vector();
        this.createdpieces = new Vector();
        this.objectpieces = new Vector();
        controlPointLines = new Vector();
        this.gtAsphalt = GroundType.createAsphalt();
        this.gtSolid = GroundType.createSolid();
        this.gtSand = GroundType.createSand();
        this.gtTurf = GroundType.createTurf();
        this.gtVoid = GroundType.createVoid();
    }

    public void removePiece(TrackBlock block) {
        if (block.type == TrackBlock.BLOCK_TYPE_MARKER) {
            this.markerpieces.remove(block);
        }
        if (block.type == TrackBlock.BLOCK_TYPE_TRACK) {
            this.trackpieces.remove(block);
        }
        if (block.type == TrackBlock.BLOCK_TYPE_BACKGROUND) {
            this.backgroundpieces.remove(block);
        }
        if (block.type == TrackBlock.BLOCK_TYPE_INVISIBLE) {
            this.invisiblepieces.remove(block);
        }
        if (block.type == TrackBlock.BLOCK_TYPE_CREATED) {
            this.createdpieces.remove(block);
        }
        if (block.type == TrackBlock.BLOCK_TYPE_SOLID) {
            this.solidpieces.remove(block);
        }
    }

    public void checkForBackSlashes(Vector objvec) {
        if (!objvec.isEmpty()) {
            int i = 0;
            while (i < objvec.size()) {
                TrackBlock block = (TrackBlock)objvec.elementAt(i);
                if (block.filename.contains("\\")) {
                    block.filename.replace("\\", "/");
                    Console.print("filename replaced, new: " + block.filename);
                }
                ++i;
            }
        }
    }

    public String replaceBackSlashes(String path) {
        if (path.contains("\\")) {
            String newpath = path.replace("\\", "/");
            return newpath;
        }
        return null;
    }

    public String readStringFromURL(URL resource) {
        try {
            return this.readString(resource.openStream());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public String readString(InputStream is) {
        try {
            ObjectInputStream in = new ObjectInputStream(is);
            String trackstr = (String)in.readObject();
            in.close();
            return trackstr;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public Point setScaledWH(double ratio) {
        Point p = new Point(this.width, this.height);
        p.x = (int)((double)p.x * ratio);
        p.y = (int)((double)p.y * ratio);
        this.localW = p.x;
        this.localH = p.y;
        return p;
    }

    public GroundType getGroundType(int posX, int posY) {
        int pixelX = posX / Engine.COORD_FACTOR;
        int pixelY = posY / Engine.COORD_FACTOR;
        if (Renderer.resolution != Renderer.RES_1280x720) {
            pixelX = (int)((double)pixelX * Renderer.screenRatio[Renderer.resolution]);
            pixelY = (int)((double)pixelY * Renderer.screenRatio[Renderer.resolution]);
        }
        if (posX < 0 || posY < 0) {
            return this.gtSolid;
        }
        if (pixelX > this.localW || pixelY > this.localH) {
            return this.gtSolid;
        }
        GroundType seek = null;
        seek = this.checkLayer(this.trackpieces, pixelX, pixelY);
        if (seek != null) {
            return seek;
        }
        seek = this.checkLayer(this.solidpieces, pixelX, pixelY);
        if (seek != null) {
            return seek;
        }
        return this.gtTurf;
    }

    public GroundType checkLayer(Vector<TrackBlock> pieces, int pixelX, int pixelY) {
        int i = 0;
        while (i < pieces.size()) {
            TrackBlock piece = pieces.elementAt(i);
            Point piecexy = piece.getLocalXY();
            if (piecexy.x <= pixelX && piecexy.y <= pixelY) {
                Point piecewh = piece.getWH();
                if (pixelX <= piecexy.x + piecewh.x && pixelY <= piecexy.y + piecewh.y) {
                    int posXOnPiece = pixelX - piecexy.x;
                    int posYOnPiece = pixelY - piecexy.y;
                    if (posXOnPiece < piecewh.x && posYOnPiece < piecewh.y) {
                        int j = 0;
                        try {
                            j = pieces.elementAt((int)i).blockImg.getRGB(posXOnPiece, posYOnPiece);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            Console.print("OOB!" + posXOnPiece + "," + posYOnPiece);
                        }
                        if (j != 0) {
                            if (piece.type == TrackBlock.BLOCK_TYPE_TRACK) {
                                return this.gtAsphalt;
                            }
                            if (piece.type == TrackBlock.BLOCK_TYPE_SOLID) {
                                return this.gtSolid;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public Vector<String> getAvailableTrackNames() {
        String cleanpath = null;
        try {
            cleanpath = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String modifiedPath = cleanpath;
        modifiedPath = String.valueOf(modifiedPath) + "\\tracks";
        File dir = new File(modifiedPath);
        if (dir.isDirectory()) {
            Console.print("found dir");
        } else {
            URL url = SlicksApplet.class.getResource("/tracks");
            Console.print("Location: " + url);
            modifiedPath = cleanpath;
            modifiedPath = String.valueOf(modifiedPath) + "\\bin\\tracks";
            dir = new File(modifiedPath);
            if (dir.isDirectory()) {
                Console.print("found in bin build, eclipse launch");
            } else {
                url = this.getClass().getResource("/tracks/mini.dat");
                Console.print("Found File!: " + url);
                dir = new File(url.toString());
                if (dir.isDirectory()) {
                    Console.print("found in bin build, eclipse launch");
                } else {
                    Console.print("fuck how to do this again..");
                }
            }
        }
        Vector<String> tracknames = new Vector<String>();
        String[] tmp = dir.list();
        if (tmp != null) {
            int i = 0;
            while (i < tmp.length) {
                tracknames.addElement(tmp[i]);
                Console.print("adding trackname" + tmp[i]);
                ++i;
            }
            Collections.sort(tracknames, String.CASE_INSENSITIVE_ORDER);
            return tracknames;
        }
        Console.print("NO TRACKNAMES FOUND!");
        return null;
    }

    public Vector<String> getAvailableTrackNamesWithoutExtension() {
        String cleanpath = null;
        try {
            cleanpath = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String modifiedPath = cleanpath;
        modifiedPath = String.valueOf(modifiedPath) + "\\tracks";
        File dir = new File(modifiedPath);
        if (dir.isDirectory()) {
            Console.print("found dir");
        } else {
            URL url = SlicksApplet.class.getResource("/tracks");
            Console.print("Location: " + url);
            modifiedPath = cleanpath;
            modifiedPath = String.valueOf(modifiedPath) + "\\bin\\tracks";
            dir = new File(modifiedPath);
            if (dir.isDirectory()) {
                Console.print("found in bin build, eclipse launch");
            } else {
                String classDir = null;
                try {
                    classDir = this.getClassDirectory();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Console.print("dir :" + classDir);
                url = this.getClass().getResource("/tracks");
                Console.print("Found File!: " + url);
                String urlAsString = url.toString();
                Console.print("newURL: " + urlAsString);
                File file = new File(urlAsString);
                if (file.isDirectory()) {
                    Console.print("XXXXXXXXfound in bin build, eclipse launch");
                }
            }
        }
        Vector<String> tracknames = new Vector<String>();
        String[] tmp = dir.list();
        if (tmp != null) {
            int i = 0;
            while (i < tmp.length) {
                String temp;
                tmp[i] = temp = tmp[i].replace(".dat", "");
                tracknames.addElement(tmp[i]);
                ++i;
            }
            Collections.sort(tracknames, String.CASE_INSENSITIVE_ORDER);
            return tracknames;
        }
        Console.print("COULD NOT GET TRACK DIRECTORY!!");
        return null;
    }

    public String getClassDirectory() throws IOException {
        File f = new File(".");
        return f.getCanonicalPath();
    }
}

