/*
 * Decompiled with CFR 0.152.
 */
package slicks.model;

import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import other.Console;
import other.LineSegmentIntersection;
import slicks.engine.CommandStack;
import slicks.engine.Engine;
import slicks.engine.RaceTime;
import slicks.model.GroundType;
import slicks.model.Player;
import slicks.model.Track;
import slicks.ui.ResultsScreen;
import slicks.ui.TimeGraphics;

public class RaceCarAndCollision {
    public static final int BLUE_CAR = 1;
    public static final int YELLOW_CAR = 2;
    public static final int ROTATION_SPEED = 5;
    public static final int PEDAL_ACC = 150;
    public static final int MAX_DIRECTION = 256;
    public static final int MAX_PEDAL = 10000;
    public static final int COLLISION_UNKNOWN = 0;
    public static final int COLLISION_X = 1;
    public static final int COLLISION_Y = 2;
    public static final int COLLISION_XY = 3;
    public static final int COLLISION_YX = 4;
    boolean raceFinishedForThiscar = false;
    int nextCheckPoint = 0;
    Line2D.Double checkLine;
    Track track;
    Player player;
    Point velocity;
    private Point centerPos;
    int pedal;
    boolean pedalDown;
    int direction;
    public int carType;
    public int carColor;
    public int keys;
    public Image[] carImgs;
    public Point collisionCheck;
    public ResultsScreen result;

    public RaceCarAndCollision(Player p) {
        Console.print("init centerPos!!!!");
        this.centerPos = new Point(0, 0);
        this.velocity = new Point(0, 0);
        this.collisionCheck = new Point(0, 0);
        this.player = p;
    }

    public void assignTracktoCar(Track track) {
        this.track = track;
    }

    public void assignResulttoCar(ResultsScreen rs) {
        this.result = rs;
    }

    public void setCarType(int type) {
        this.carType = type;
    }

    public void setCarColor(int color) {
        this.carColor = color;
    }

    public void setStartDirection(int direction) {
        this.direction = direction;
    }

    public void receiveCommand(CommandStack.Command command) {
        this.keys = command.keys;
    }

    public void update() {
        GroundType groundType = this.getGroundType(this.centerPos.x, this.centerPos.y);
        float friction = groundType.getFriction();
        this.pedalDown = false;
        if ((this.keys & CommandStack.COMMAND_UP) != 0) {
            this.pedal += 150;
            if (this.pedal > 10000) {
                this.pedal = 10000;
            }
            this.pedalDown = true;
        } else if ((this.keys & CommandStack.COMMAND_DOWN) != 0) {
            this.pedal = 0;
            this.pedalDown = true;
        }
        int speed = this.pedal = (int)((double)this.pedal * 0.9);
        if ((this.keys & CommandStack.COMMAND_LEFT) != 0) {
            this.direction -= 5;
            if (this.direction < 0) {
                this.direction += 256;
            }
        }
        if ((this.keys & CommandStack.COMMAND_RIGHT) != 0) {
            this.direction += 5;
            if (this.direction >= 256) {
                this.direction -= 256;
            }
        }
        if (this.pedalDown) {
            double direction2 = Math.PI * 2 * (double)this.direction / 256.0;
            this.velocity.x += (int)((double)speed * Math.cos(direction2));
            this.velocity.y += (int)((double)speed * Math.sin(direction2));
        }
        this.velocity.x = (int)((float)this.velocity.x * friction);
        this.velocity.y = (int)((float)this.velocity.y * friction);
        Point newPos = new Point();
        newPos.x = this.centerPos.x + this.velocity.x;
        newPos.y = this.centerPos.y + this.velocity.y;
        this.doCollisionCheck(newPos);
    }

    GroundType getGroundType(int x, int y) {
        return this.track.getGroundType(x, y);
    }

    int getCollisionPlane(int x, int y, int speedX, int speedY) {
        int coordShift = Engine.COORD_FACTOR;
        boolean coll0 = this.getGroundType(x - coordShift, y).isSolid();
        boolean coll2 = this.getGroundType(x + coordShift, y).isSolid();
        if (coll0 && coll2) {
            return 1;
        }
        boolean coll1 = this.getGroundType(x, y - coordShift).isSolid();
        boolean coll3 = this.getGroundType(x, y + coordShift).isSolid();
        if (coll1 && coll3) {
            return 2;
        }
        int absSpeedX = Math.abs(speedX);
        int absSpeedY = Math.abs(speedY);
        if (coll0 && coll1 && (-speedX > absSpeedY || -speedY > absSpeedX)) {
            return 3;
        }
        if (coll2 && coll3 && (speedX > absSpeedY || speedY > absSpeedX)) {
            return 3;
        }
        if (coll1 && coll2 && (speedX > absSpeedY || -speedY > absSpeedX)) {
            return 4;
        }
        if (coll0 && coll3 && (-speedX > absSpeedY || speedY > absSpeedX)) {
            return 4;
        }
        if (coll1 || coll3) {
            return 1;
        }
        if (coll0 || coll2) {
            return 2;
        }
        return 0;
    }

    boolean doCollisionCheck(Point newPos) {
        int pixY;
        if (newPos.x == this.centerPos.x && newPos.y == this.centerPos.y) {
            return false;
        }
        Point nowPos = new Point();
        int diffX = newPos.x - this.centerPos.x;
        int diffY = newPos.y - this.centerPos.y;
        int pixX = Math.abs(diffX) * 3 / Engine.COORD_FACTOR;
        int steps = pixX > (pixY = Math.abs(diffY) * 3 / Engine.COORD_FACTOR) ? pixX : pixY;
        int prevX = this.centerPos.x;
        int prevY = this.centerPos.y;
        Line2D.Double moveLine = new Line2D.Double(this.centerPos.x / Engine.COORD_FACTOR, this.centerPos.y / Engine.COORD_FACTOR, newPos.x / Engine.COORD_FACTOR, newPos.y / Engine.COORD_FACTOR);
        this.checkLine = Track.controlPointLines.elementAt(this.nextCheckPoint);
        Point2D.Double intersection = new Point2D.Double(0.0, 0.0);
        boolean intersects = LineSegmentIntersection.getLineLineIntersection(this.checkLine, moveLine, intersection);
        if (intersects) {
            Console.print("crossed");
            if (this.nextCheckPoint == 0) {
                Console.print("Pl. " + this.player.myName + " LAP " + this.player.laps);
                ++this.player.laps;
                if (this.player.laps > Engine.numLaps) {
                    this.player.raceFinishtime = System.nanoTime() - RaceTime.localStartTime;
                    RaceTime.timeLastPlayerFinishedMilSecs = System.currentTimeMillis();
                    String parsedTime = new String(TimeGraphics.convertNanoSecsToString(this.player.raceFinishtime));
                    this.result.addResult(this.player.myName, parsedTime);
                    Console.print("player Finished Race at " + this.player.raceFinishtime / 1000000000L + " secs");
                }
            }
            ++this.nextCheckPoint;
            if (this.nextCheckPoint >= Track.numControlPoints) {
                Console.print("0 checkpoint next");
                this.nextCheckPoint = 0;
            }
        }
        int i = 1;
        while (i <= steps) {
            nowPos.x = this.centerPos.x + diffX * i / steps;
            nowPos.y = this.centerPos.y + diffY * i / steps;
            GroundType nowPosGround = this.getGroundType(nowPos.x, nowPos.y);
            if (nowPosGround.isSolid()) {
                this.centerPos.x = prevX;
                this.centerPos.y = prevY;
                float bumpFriction = nowPosGround.getBumpFriction();
                int planeDirection = this.getCollisionPlane(nowPos.x, nowPos.y, diffX, diffY);
                int prevVelocityX = this.velocity.x;
                if (planeDirection == 1) {
                    this.velocity.y *= -1;
                } else if (planeDirection == 2) {
                    this.velocity.x *= -1;
                } else if (planeDirection == 3) {
                    this.velocity.x = -this.velocity.y;
                    this.velocity.y = -prevVelocityX;
                } else if (planeDirection == 4) {
                    this.velocity.x = this.velocity.y;
                    this.velocity.y = prevVelocityX;
                } else {
                    this.velocity.x *= -1;
                    this.velocity.y *= -1;
                }
                this.velocity.x = (int)((float)this.velocity.x * bumpFriction);
                this.velocity.y = (int)((float)this.velocity.y * bumpFriction);
                return true;
            }
            prevX = nowPos.x;
            prevY = nowPos.y;
            ++i;
        }
        this.centerPos = newPos;
        return false;
    }

    public boolean nextCheckPoint() {
        return false;
    }

    public void lapComplete() {
    }

    public int getDirection() {
        return this.direction;
    }

    public Point getPos() {
        return this.centerPos;
    }

    public void setPositionWithEngineFactor(Point p) {
        p.x *= Engine.COORD_FACTOR;
        p.y *= Engine.COORD_FACTOR;
        this.centerPos = p;
    }

    public void setPosition(Point p) {
        Console.print("setPos: " + p.x + "," + p.y);
        this.centerPos = p;
    }
}

