/*
 * Decompiled with CFR 0.152.
 */
package slicks.engine;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import other.AverageTimeForTask;
import other.Console;
import slicks.client.KeyboardInput;
import slicks.engine.ControlInterface;
import slicks.engine.Multiplayer;
import slicks.engine.MultiplayerObserver;
import slicks.engine.RaceTime;
import slicks.model.Model;
import slicks.model.Player;
import slicks.model.RaceCarAndCollision;
import slicks.model.Track;
import slicks.model.TrackReadWrite;
import slicks.sound.SoundMan;
import slicks.ui.Renderer;
import slicks.ui.ResultsScreen;
import slicks.ui.StartLamps;
import slicks.ui.TrackGraphics;
import slicks.ui.TrackSelection;

public class Engine
implements MultiplayerObserver {
    public static Model model;
    public static String trackName;
    Renderer renderer;
    Multiplayer mp = new Multiplayer();
    ControlInterface ci = new ControlInterface();
    KeyboardInput kb;
    public static int COORD_FACTOR;
    public static boolean running;
    public static int state;
    public static int numPlayers;
    public static int numLaps;
    public static int player_Final_position;
    public static AverageTimeForTask avgEngine;
    public SoundMan sm;

    static {
        trackName = null;
        COORD_FACTOR = 4096;
        running = true;
        state = 0;
        numPlayers = 1;
        numLaps = 2;
        player_Final_position = 1;
    }

    public Engine(Renderer renderer, KeyboardInput keyboard, SoundMan sm) {
        this.kb = keyboard;
        this.renderer = renderer;
        this.sm = sm;
        avgEngine = new AverageTimeForTask();
    }

    public void update(int ticks) {
        avgEngine.logStartSample();
        switch (state) {
            case 30: {
                this.renderer.menu.activeButtons.clear();
                state = 2;
                break;
            }
            case 9: {
                this.initRace();
                state = 6;
                break;
            }
            case 7: {
                boolean start = StartLamps.advanceLampsLocal();
                if (this.sm != null && !this.sm.isPlaying("startLamps")) {
                    this.sm.playSound("startLamps");
                }
                if (!start) break;
                state = 3;
                RaceTime.localStartTime = System.nanoTime();
                break;
            }
            case 3: {
                if (!StartLamps.turnOffLamps) {
                    StartLamps.advanceLampsLocal();
                }
                RaceTime.elapsedTime = System.nanoTime() - RaceTime.localStartTime;
                this.ci.assignCommandsFromLocalControl(this.kb.currentKeys, Engine.model.players);
                for (Player p : Engine.model.players) {
                    try {
                        p.myCar.receiveCommand(p.commands.getLatestCommand());
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    p.commands.removeCommands();
                }
                int i = 0;
                while (i < ticks) {
                    int i2 = 0;
                    while (i2 < Engine.model.players.size()) {
                        Player p;
                        p = Engine.model.players.elementAt(i2);
                        p.myCar.update();
                        ++i2;
                    }
                    ++i;
                }
                this.checkRaceProgress();
                break;
            }
            case 6: {
                Console.print("loading track");
                if (model == null) {
                    this.initRace();
                    break;
                }
                Engine.model.trackDataLoaded = false;
                if (false) {
                    Console.print("loading track data, engine waits");
                }
                Engine.model.trackGraphicsLoaded = false;
                if (false) {
                    Console.print("loading track images, engine waits");
                    break;
                }
                state = 7;
                StartLamps.waitStartTime = System.nanoTime();
            }
        }
        avgEngine.logEndSample();
    }

    public static void nullModel() {
        model = null;
        RaceTime.elapsedTime = 0L;
    }

    void initRace() {
        model = new Model();
        Engine.model.track = new Track();
        String selectedTrack = TrackSelection.getSelectedTrackName();
        Console.print("trackname: " + selectedTrack);
        URL url = this.getClass().getResource("/tracks/" + selectedTrack);
        TrackReadWrite tr = new TrackReadWrite();
        try {
            tr.chooseVersion(url, Engine.model.track);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (Track.startgrid == null) {
            Console.print("NO GRID");
        }
        TrackGraphics tempG = new TrackGraphics();
        tempG.loadStartGridImage(this.renderer.myLoader, Track.startgrid);
        Vector<Point> pts = Track.startgrid.findStartingPositions();
        if (this.renderer.menu == null) {
            Console.print("ah menu null");
        }
        if (this.renderer.menu.font == null) {
            Console.print("ah menu.font null");
        }
        this.renderer.menu.results = new ResultsScreen(this.renderer.menu.font);
        int i = 0;
        while (i < numPlayers) {
            Console.print("adding player " + i);
            Player player = null;
            player = i == 0 ? new Player("Frank") : (i == 1 ? new Player("Matti") : new Player("P " + (i + 1)));
            player.myCar = new RaceCarAndCollision(player);
            player.myCar.setCarColor(i);
            if (this.renderer.menu.results == null) {
                Console.print("results is null!");
            }
            player.myCar.result = this.renderer.menu.results;
            player.setTrackAndStartingPosition(i, Engine.model.track);
            player.myCar.setPositionWithEngineFactor(pts.elementAt(i));
            model.addPlayer(player);
            ++i;
        }
        StartLamps.resetLamps();
        this.renderer.modelLoaded = true;
        Console.print("model, track and player data ready, pass model to gfx load");
        this.renderer.passModelToRenderer(model);
    }

    void checkRaceProgress() {
        int numPlayersFinished = 0;
        int i = 0;
        while (i < Engine.model.players.size()) {
            Player p = Engine.model.players.elementAt(i);
            if (p.raceFinishtime != 0L) {
                Console.print("p:" + i + " has finished");
                ++numPlayersFinished;
            }
            ++i;
        }
        if (numPlayersFinished == numPlayers && RaceTime.timeLastPlayerFinishedMilSecs + RaceTime.LAST_TO_FINISH_DELAY_millisecs < System.currentTimeMillis()) {
            Console.print("All Done + 2seconds at " + System.currentTimeMillis() / 1000L + " secs");
            Console.print("OK, END GAME");
            this.renderer.menu.activateRaceResultsMenu();
            state = 8;
        }
        if (numPlayersFinished > 0 && state != 8 && RaceTime.timeLastPlayerFinishedMilSecs + RaceTime.NEXT_TO_FINISH_DELAY_millisecs < System.currentTimeMillis()) {
            Console.print("Late Comers, + 10 seconds at " + System.currentTimeMillis() / 1000L + " secs");
            Console.print("NOBODY IN FOR 10 SECONDS");
            this.renderer.menu.activateRaceResultsMenu();
            state = 8;
        }
    }

    void playerDropped(Player player) {
    }

    @Override
    public void playerDropped(Player player, int reason) {
    }

    @Override
    public void playerJoined(Player player) {
    }

    public void mouseMoved(MouseEvent evt) {
        this.renderer.mouseMoved(evt);
    }

    public void mouseClicked(MouseEvent evt) {
        this.renderer.mouseClicked(evt);
    }

    public void mousePressed(MouseEvent evt) {
        this.renderer.mousePressed(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.renderer.mouseReleased(evt);
    }
}

