/*
 * Decompiled with CFR 0.152.
 */
package slicks.client;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import other.Console;
import slicks.client.SlicksApplet;
import slicks.engine.Engine;
import slicks.sound.SoundMan;

public class KeyboardInput
implements KeyListener {
    public static final int KEY_COUNT = 256;
    public boolean[] currentKeys = null;
    public KeyState[] keys = null;
    private SoundMan sm;
    private boolean soundsOn = true;

    public KeyboardInput(SoundMan sm) {
        this.sm = sm;
        if (sm == null) {
            this.soundsOn = false;
        }
        this.currentKeys = new boolean[256];
        this.keys = new KeyState[256];
        int i = 0;
        while (i < 256) {
            this.keys[i] = KeyState.RELEASED;
            ++i;
        }
    }

    public synchronized void poll() {
        int i = 0;
        while (i < 256) {
            this.keys[i] = this.currentKeys[i] ? (this.keys[i] == KeyState.RELEASED ? KeyState.ONCE : KeyState.PRESSED) : KeyState.RELEASED;
            ++i;
        }
    }

    public boolean keyDown(int keyCode) {
        return this.keys[keyCode] == KeyState.ONCE || this.keys[keyCode] == KeyState.PRESSED;
    }

    public boolean keyDownOnce(int keyCode) {
        Console.print("once - not working?");
        return this.keys[keyCode] == KeyState.ONCE;
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode >= 0 && keyCode < 256) {
            this.currentKeys[keyCode] = true;
            if (keyCode == 27) {
                if (Engine.state != 2) {
                    Console.print("go to game menu from Keyboard Input, this may null controls? from settings?");
                    Engine.nullModel();
                    Engine.state = 30;
                } else {
                    Console.print("killgame from KeyBoardInput");
                    SlicksApplet.running = false;
                }
            }
        }
    }

    @Override
    public synchronized void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode >= 0 && keyCode < 256) {
            this.currentKeys[keyCode] = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private static enum KeyState {
        RELEASED,
        PRESSED,
        ONCE;

    }
}

