/*
 * Decompiled with CFR 0.152.
 */
package other;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import other.Console;

public class Font59 {
    private Toolkit tk;
    private int imgHeight;
    private char[] chars;
    private byte[] charsWidth;
    private BufferedImage[] charImage;
    private BufferedImage[][] changedImage;
    int resultWidth;
    int maximumNumberOfFonts = 3;
    public static int HCENTER = 1;
    public static int RIGHT = 2;
    public static int LEFT = 0;
    public static int TOP = 1;
    public static int BOTTOM = 2;
    public static int VCENTER = 3;
    int prevLen = -1;
    int[] indxs;
    String prevStr = "*'#";
    int val;
    int width;
    int previousFont = 1;
    int enableChange = 1;
    byte leftOnSpecial = 0;
    int charIndexI;
    int[] newColourArray;
    int newColourCount;
    int originalColour = -1;

    public Font59(String imgFile, Graphics g, Toolkit tool) {
        try {
            this.tk = tool;
            this.initialize(g, imgFile);
        }
        catch (Exception ee) {
            System.out.println("Could Not Create Font, e:" + ee);
            ee.printStackTrace();
        }
    }

    public void createColouredText(Graphics g, String text, int colour) {
    }

    public void initialize(Graphics g, String fileName) throws IOException {
        Image img = null;
        InputStream is = this.getClass().getResourceAsStream(fileName);
        DataInputStream dis = new DataInputStream(is);
        int len = dis.readInt();
        this.chars = new char[len];
        this.charImage = new BufferedImage[len];
        this.charsWidth = new byte[len];
        int i = 0;
        while (i < len) {
            this.chars[i] = dis.readChar();
            this.charsWidth[i] = dis.readByte();
            ++i;
        }
        int imgSize = dis.readInt();
        byte[] tmpBuffer = new byte[imgSize];
        dis.read(tmpBuffer, 0, imgSize);
        Console.print("processing img, imgSize: " + imgSize);
        img = this.tk.createImage(tmpBuffer, 0, imgSize);
        Console.print("processing img, imgHeight: " + img.getHeight(null));
        Console.print("processing img, imgWidth: " + img.getWidth(null));
        if (img != null) {
            this.imgHeight = img.getHeight(null);
            int x = 0;
            int i2 = 0;
            while (i2 < len) {
                this.charImage[i2] = new BufferedImage(this.charsWidth[i2], this.imgHeight, 2);
                Graphics gfx = this.charImage[i2].getGraphics();
                g.setColor(new Color(255, 255, 255));
                g.setClip(0, 0, this.charsWidth[i2], this.imgHeight);
                g.drawImage(img, -x, 0, null);
                x += this.charsWidth[i2];
                g = null;
                int[] temp = new int[this.charImage[i2].getWidth(null) * this.charImage[i2].getHeight(null)];
                this.charImage[i2].getRGB(0, 0, this.charImage[i2].getWidth(null), this.charImage[i2].getHeight(null), temp, 0, this.charImage[i2].getWidth(null));
                int first = temp[0];
                int j = 0;
                while (j < temp.length) {
                    if (temp[j] == first) {
                        temp[j] = 0xFFFFFF;
                    }
                    ++j;
                }
                this.charImage[i2].setRGB(0, 0, this.charImage[i2].getWidth(null), this.charImage[i2].getHeight(null), temp, 0, this.charImage[i2].getWidth(null));
                ++i2;
            }
            Console.print("finished processing img");
        }
        tmpBuffer = null;
        img = null;
    }

    public void deleteAllFonts() {
        this.changedImage = null;
        System.gc();
    }

    public int GetFontHeight() {
        return this.imgHeight;
    }

    public int GetStringWidth(String text) {
        int width = 0;
        int i = 0;
        while (i < text.length()) {
            int val = this.charIndex(text.charAt(i));
            if (val != -1) {
                width += this.charsWidth[val];
            }
            ++i;
        }
        return width;
    }

    public void PrintString(Graphics g, int x, int y, String text, int hPos, int VPos) {
        this.PrintString(g, x, y, text, hPos, VPos, -1);
    }

    public void PrintString(Graphics g, int x, int y, String text, int hPos, int VPos, int fontNum) {
        if (fontNum != -1 && (this.changedImage == null || this.changedImage[fontNum] == null)) {
            fontNum = -1;
        }
        if (text == null) {
            return;
        }
        if (!this.prevStr.equals(text)) {
            this.width = 0;
            int txtLength = text.length();
            if (txtLength != this.prevLen) {
                this.indxs = new int[txtLength];
            }
            this.prevLen = txtLength;
            int i = 0;
            while (i < txtLength) {
                if (text.charAt(i) == '|') {
                    this.indxs[i] = -10;
                } else {
                    this.indxs[i] = this.val = this.charIndex(text.charAt(i));
                    if (this.val >= 0) {
                        this.width += this.charsWidth[this.val];
                    }
                }
                ++i;
            }
            if (hPos == HCENTER) {
                x -= this.width / 2;
            }
            if (hPos == RIGHT) {
                x -= this.width;
            }
            if (VPos == BOTTOM) {
                y -= this.imgHeight;
            }
            if (VPos == VCENTER) {
                y -= this.imgHeight / 2;
            }
        }
        int i = 0;
        while (i < this.indxs.length) {
            this.val = this.indxs[i];
            if (this.val == -10) {
                if (this.enableChange != 0) {
                    if (fontNum == -1) {
                        fontNum = this.previousFont;
                        this.leftOnSpecial = 1;
                    } else if (fontNum != -1) {
                        this.previousFont = fontNum;
                        fontNum = -1;
                        this.leftOnSpecial = 0;
                    }
                }
            } else if (this.val != -1) {
                if (fontNum == -1) {
                    g.drawImage(this.charImage[this.val], x, y, null);
                } else {
                    g.drawImage(this.changedImage[fontNum][this.val], x, y, null);
                }
                x += this.charsWidth[this.val];
            }
            ++i;
        }
    }

    private int charIndex(char ch) {
        this.charIndexI = -1;
        this.charIndexI = 0;
        while (this.charIndexI < this.chars.length) {
            if (this.chars[this.charIndexI] == ch) break;
            ++this.charIndexI;
        }
        if (this.charIndexI == this.chars.length) {
            this.charIndexI = -1;
        }
        return this.charIndexI;
    }

    public int getFontHeight() {
        return this.imgHeight;
    }

    public int charWidth(char ch) {
        int index = this.charIndex(ch);
        if (index != -1) {
            return this.charsWidth[index];
        }
        return 0;
    }

    public int stringWidth(String str) {
        int sum = 0;
        return sum;
    }

    public int makeNewFont(int newColour) {
        return this.makeNewFont(newColour, false, 0);
    }

    public int makeNewFont(int newColour, int boldColour) {
        return this.makeNewFont(newColour, true, boldColour);
    }

    public int makeGradientFont(int topColour, int bottomColour) {
        if (this.changedImage == null) {
            this.changedImage = new BufferedImage[3][];
        }
        int fontNum = 0;
        while (fontNum < this.changedImage.length) {
            if (this.changedImage[fontNum] == null) break;
            ++fontNum;
        }
        this.changedImage[fontNum] = new BufferedImage[this.charImage.length];
        int i = 0;
        while (i < this.charImage.length) {
            this.changedImage[fontNum][i] = this.changeToGradient(topColour, bottomColour, this.charImage[i]);
            ++i;
        }
        return fontNum;
    }

    public int makeNewFont(int newColour, boolean bold, int boldColour) {
        if (this.changedImage == null) {
            this.changedImage = new BufferedImage[this.maximumNumberOfFonts][];
        }
        int fontNum = 0;
        while (fontNum < this.changedImage.length) {
            if (this.changedImage[fontNum] == null) break;
            ++fontNum;
        }
        this.changedImage[fontNum] = new BufferedImage[this.charImage.length];
        int i = 0;
        while (i < this.charImage.length) {
            this.changedImage[fontNum][i] = this.changeColour(newColour, i);
            if (bold) {
                this.changedImage[fontNum][i] = this.makeBold(this.changedImage[fontNum][i], newColour, boldColour);
            }
            ++i;
        }
        return fontNum;
    }

    public BufferedImage changeColour(int colour, int i) {
        if (this.newColourArray == null || this.newColourArray.length != this.charImage[i].getWidth(null) * this.charImage[i].getHeight(null)) {
            this.newColourArray = new int[this.charImage[i].getWidth(null) * this.charImage[i].getHeight(null)];
        }
        this.charImage[i].getRGB(0, 0, this.charImage[i].getWidth(null), this.charImage[i].getHeight(null), this.newColourArray, 0, this.charImage[i].getWidth(null));
        this.newColourCount = 0;
        while (this.newColourCount < this.newColourArray.length) {
            if (this.newColourArray[this.newColourCount] == this.originalColour) {
                this.newColourArray[this.newColourCount] = colour;
            }
            ++this.newColourCount;
        }
        BufferedImage img = new BufferedImage(this.charImage[i].getWidth(null), this.charImage[i].getHeight(null), 2);
        img.setRGB(0, 0, this.charImage[i].getWidth(null), this.charImage[i].getHeight(null), this.newColourArray, 0, this.charImage[i].getWidth(null));
        return img;
    }

    public BufferedImage changeToGradient(int topColour, int bottomColour, BufferedImage toMake) {
        int x;
        int rgb = topColour;
        int r1 = rgb >> 16 & 0xFF;
        int g1 = rgb >> 8 & 0xFF;
        int b1 = rgb & 0xFF;
        rgb = bottomColour;
        int r2 = rgb >> 16 & 0xFF;
        int g2 = rgb >> 8 & 0xFF;
        int b2 = rgb & 0xFF;
        int rstep = (r2 - r1) / this.imgHeight;
        int gstep = (g2 - g1) / this.imgHeight;
        int bstep = (b2 - b1) / this.imgHeight;
        this.newColourArray = new int[toMake.getWidth(null) * toMake.getHeight(null)];
        toMake.getRGB(0, 0, toMake.getWidth(null), toMake.getHeight(null), this.newColourArray, 0, toMake.getWidth(null));
        int[][] image2d = new int[toMake.getWidth(null)][toMake.getHeight(null)];
        int y = 0;
        while (y < toMake.getHeight(null)) {
            x = 0;
            while (x < toMake.getWidth(null)) {
                if (this.newColourArray[x + y * toMake.getWidth(null)] == this.originalColour) {
                    image2d[x][y] = 0xFF000000 | r1 << 16 | g1 << 8 | b1;
                }
                ++x;
            }
            r1 += rstep;
            g1 += gstep;
            b1 += bstep;
            ++y;
        }
        y = 0;
        while (y < toMake.getHeight(null)) {
            x = 0;
            while (x < toMake.getWidth(null)) {
                this.newColourArray[x + y * toMake.getWidth(null)] = image2d[x][y];
                ++x;
            }
            ++y;
        }
        BufferedImage img = new BufferedImage(toMake.getWidth(null), toMake.getHeight(null), 2);
        img.setRGB(0, 0, toMake.getWidth(null), toMake.getHeight(null), this.newColourArray, 0, toMake.getWidth(null));
        return img;
    }

    public BufferedImage makeBold(BufferedImage toMake, int colour, int boldColour) {
        int x;
        BufferedImage temp = new BufferedImage(toMake.getWidth(null) + 2, toMake.getHeight(null) + 2, 2);
        Graphics tempG = temp.getGraphics();
        if (colour == -1) {
            tempG.setColor(new Color(-65536));
            tempG.fillRect(0, 0, temp.getWidth(null), temp.getHeight(null));
        }
        toMake.getGraphics().drawImage(toMake, 1, 1, null);
        this.newColourArray = new int[temp.getWidth(null) * temp.getHeight(null)];
        temp.getRGB(0, 0, temp.getWidth(null), temp.getHeight(null), this.newColourArray, 0, temp.getWidth(null));
        int i = 0;
        while (i < this.newColourArray.length) {
            if (this.newColourArray[i] == -1) {
                this.newColourArray[i] = 0;
            }
            ++i;
        }
        toMake.setRGB(0, 0, temp.getWidth(null), temp.getHeight(null), this.newColourArray, 0, temp.getWidth(null));
        this.newColourArray = null;
        this.newColourArray = new int[toMake.getWidth(null) * toMake.getHeight(null)];
        toMake.getRGB(0, 0, toMake.getWidth(null), toMake.getHeight(null), this.newColourArray, 0, toMake.getWidth(null));
        int[][] image2d = new int[toMake.getWidth(null)][toMake.getHeight(null)];
        int y = 0;
        while (y < toMake.getHeight(null)) {
            x = 0;
            while (x < toMake.getWidth(null)) {
                image2d[x][y] = this.newColourArray[x + y * toMake.getWidth(null)];
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < toMake.getHeight(null) - 1) {
            x = 0;
            while (x < toMake.getWidth(null) - 1) {
                if (image2d[x][y] == 0 && image2d[x + 1][y] != 0) {
                    image2d[x][y] = boldColour;
                }
                if (image2d[x][y] == 0 && image2d[x][y + 1] != 0) {
                    image2d[x][y] = boldColour;
                }
                ++x;
            }
            ++y;
        }
        y = toMake.getHeight(null) - 1;
        while (y > 0) {
            x = toMake.getWidth(null) - 1;
            while (x > 0) {
                if (image2d[x][y] == 0 && image2d[x - 1][y] != 0) {
                    image2d[x][y] = boldColour;
                }
                if (image2d[x][y] == 0 && image2d[x][y - 1] != 0) {
                    image2d[x][y] = boldColour;
                }
                --x;
            }
            --y;
        }
        y = 0;
        while (y < toMake.getHeight(null)) {
            x = 0;
            while (x < toMake.getWidth(null)) {
                this.newColourArray[x + y * toMake.getWidth(null)] = image2d[x][y];
                ++x;
            }
            ++y;
        }
        BufferedImage img = new BufferedImage(toMake.getWidth(null), toMake.getHeight(null), 2);
        img.setRGB(0, 0, toMake.getWidth(null), toMake.getHeight(null), this.newColourArray, 0, toMake.getWidth(null));
        return img;
    }

    public static int getRGB(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

