/*
 * Decompiled with CFR 0.152.
 */
package other;

public class FPS {
    public int fps;
    public long[] usedTime = new long[this.sampleAmount];
    public boolean slowFrameFlag = false;
    private int sampleAmount = 60;
    private int slowMilliSecs = 33;
    private int counter = 0;
    private long lastFrame = 0L;
    public long slowFrame = 0L;

    public void logFPS() {
        long now = System.nanoTime();
        if (this.lastFrame != 0L) {
            long taken = now - this.lastFrame;
            this.logFPS(taken);
            if (taken > (long)(this.slowMilliSecs * 1000000)) {
                this.slowFrameFlag = true;
                this.slowFrame = taken;
            }
        }
        this.lastFrame = now;
    }

    public void logFPS(long time) {
        this.usedTime[this.counter] = time;
        if (this.counter == this.sampleAmount - 1) {
            this.slowFrameFlag = false;
            this.counter = 0;
            long total = 0L;
            int i = 0;
            while (i < this.sampleAmount) {
                long avgFrame = (total += this.usedTime[i]) / (long)this.sampleAmount;
                this.fps = (int)(1.0E9f / (float)avgFrame);
                ++i;
            }
        } else {
            ++this.counter;
        }
    }

    public void test() {
        System.nanoTime();
    }
}

