/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.joal.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.java.games.joal.ALConstants;
import net.java.games.joal.util.WAVData;

public class WAVLoader
implements ALConstants {
    private static final int BUFFER_SIZE = 128000;

    public static WAVData loadFromFile(String string) throws UnsupportedAudioFileException, IOException {
        Object var1_1 = null;
        File file = new File(string);
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
        return WAVLoader.readFromStream(audioInputStream);
    }

    public static WAVData loadFromStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        Object var1_1 = null;
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
        return WAVLoader.readFromStream(audioInputStream);
    }

    private static WAVData readFromStream(AudioInputStream audioInputStream) throws UnsupportedAudioFileException, IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(audioInputStream);
        AudioFormat audioFormat = audioInputStream.getFormat();
        int n = audioFormat.getChannels();
        int n2 = audioFormat.getSampleSizeInBits();
        int n3 = 4352;
        if (n2 == 8 && n == 1) {
            n3 = 4352;
        } else if (n2 == 16 && n == 1) {
            n3 = 4353;
        } else if (n2 == 8 && n == 2) {
            n3 = 4354;
        } else if (n2 == 16 && n == 2) {
            n3 = 4355;
        }
        int n4 = Math.round(audioFormat.getSampleRate());
        int n5 = audioInputStream.available();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5);
        while (byteBuffer.remaining() > 0) {
            readableByteChannel.read(byteBuffer);
        }
        byteBuffer.rewind();
        if (n2 == 16 && ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            int n6 = byteBuffer.remaining();
            for (int i = 0; i < n6; i += 2) {
                byte by = byteBuffer.get(i);
                byte by2 = byteBuffer.get(i + 1);
                byteBuffer.put(i, by2);
                byteBuffer.put(i + 1, by);
            }
        }
        WAVData wAVData = new WAVData(byteBuffer, n3, n5, n4, false);
        audioInputStream.close();
        return wAVData;
    }
}

