/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.text.MaskFormatter;
import other.Console;
import slicks.model.Track;

public class TextInput
extends JPanel
implements ActionListener,
FocusListener {
    public JTextField widthField;
    public JTextField heightField;
    JFormattedTextField zipField;
    boolean boundsSet = false;
    Font regularFont;
    Font italicFont;
    JLabel settingDisplay;
    static final int GAP = 10;
    Track track;

    public TextInput(Track track) {
        this.track = track;
        Console.print("created txt");
        this.setLayout(new BoxLayout(this, 2));
        JPanel leftHalf = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                Dimension pref = this.getPreferredSize();
                return new Dimension(Integer.MAX_VALUE, pref.height);
            }
        };
        leftHalf.setLayout(new BoxLayout(leftHalf, 3));
        leftHalf.add(this.createEntryFields());
        leftHalf.add(this.createButtons());
        this.add(leftHalf);
        this.add(this.createsettingDisplay());
    }

    protected JComponent createButtons() {
        JPanel panel = new JPanel(new FlowLayout(4));
        JButton button = new JButton("Set Bounds");
        button.addActionListener(this);
        panel.add(button);
        button = new JButton("Reset to 1280x720");
        button.addActionListener(this);
        button.setActionCommand("clear");
        panel.add(button);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("clear".equals(e.getActionCommand())) {
            this.boundsSet = true;
            this.widthField.setText("1280");
            this.heightField.setText("720");
        } else {
            this.boundsSet = true;
        }
        this.updateDisplays();
    }

    protected void updateDisplays() {
        this.settingDisplay.setText(this.formatBounds());
        if (this.boundsSet) {
            this.settingDisplay.setFont(this.regularFont);
        } else {
            this.settingDisplay.setFont(this.italicFont);
        }
    }

    protected JComponent createsettingDisplay() {
        JPanel panel = new JPanel(new BorderLayout());
        this.settingDisplay = new JLabel();
        this.settingDisplay.setHorizontalAlignment(0);
        this.regularFont = this.settingDisplay.getFont().deriveFont(0, 16.0f);
        this.italicFont = this.regularFont.deriveFont(2);
        this.updateDisplays();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add((Component)new JSeparator(1), "Before");
        panel.add((Component)this.settingDisplay, "Center");
        panel.setPreferredSize(new Dimension(200, 150));
        return panel;
    }

    protected String formatBounds() {
        if (!this.boundsSet) {
            return "No bounds set.";
        }
        String width = this.widthField.getText();
        String height = this.heightField.getText();
        int x = 0;
        int y = 0;
        try {
            x = Integer.parseInt(width);
            y = Integer.parseInt(height);
            if (x > 0 && y > 0) {
                this.track.width = x;
                this.track.height = y;
            }
        }
        catch (Exception e) {
            Console.print("e: " + e);
        }
        String empty = "";
        if (width == null || empty.equals(width)) {
            width = "<em>(no width specified)</em>";
        }
        if (height == null || empty.equals(height)) {
            height = "<em>(no height specified)</em>";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<html><p align=center>");
        sb.append(width);
        sb.append("<br>");
        sb.append(height);
        sb.append("</p></html>");
        return sb.toString();
    }

    protected MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return formatter;
    }

    @Override
    public void focusGained(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof JFormattedTextField) {
            this.selectItLater(c);
        } else if (c instanceof JTextField) {
            ((JTextField)c).selectAll();
        }
    }

    protected void selectItLater(Component c) {
        if (c instanceof JFormattedTextField) {
            final JFormattedTextField ftf = (JFormattedTextField)c;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ftf.selectAll();
                }
            });
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    protected JComponent createEntryFields() {
        JPanel panel = new JPanel(new SpringLayout());
        String[] labelStrings = new String[]{"Width: ", "Height: "};
        JLabel[] labels = new JLabel[labelStrings.length];
        JComponent[] fields = new JComponent[labelStrings.length];
        int fieldNum = 0;
        this.widthField = new JTextField();
        this.widthField.setColumns(20);
        fields[fieldNum++] = this.widthField;
        this.heightField = new JTextField();
        this.heightField.setColumns(20);
        fields[fieldNum++] = this.heightField;
        int i = 0;
        while (i < labelStrings.length) {
            labels[i] = new JLabel(labelStrings[i], 11);
            labels[i].setLabelFor(fields[i]);
            panel.add(labels[i]);
            panel.add(fields[i]);
            JTextField tf = null;
            tf = fields[i] instanceof JSpinner ? this.getTextField((JSpinner)fields[i]) : (JTextField)fields[i];
            tf.addActionListener(this);
            tf.addFocusListener(this);
            ++i;
        }
        SpringUtilities.makeCompactGrid(panel, labelStrings.length, 2, 10, 10, 10, 5);
        return panel;
    }

    public JFormattedTextField getTextField(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)editor).getTextField();
        }
        System.err.println("Unexpected editor type: " + spinner.getEditor().getClass() + " isn't a descendant of DefaultEditor");
        return null;
    }

    public static void createAndShowGUI(Track track) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("TextInput");
        frame.setDefaultCloseOperation(2);
        TextInput newContentPane = new TextInput(track);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }
}

