/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.EditorCommand;
import editor.EditorGraphics;
import editor.EditorMenuBar;
import editor.PiecePanel;
import editor.TextInput;
import editor.TrackNode;
import editor.TrackPanel;
import editor.TreePanel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import other.Console;
import other.FPS;
import slicks.client.KeyboardInput;
import slicks.engine.ImageLoader;
import slicks.model.Track;
import slicks.model.TrackBlock;
import slicks.model.TrackMarker;
import slicks.model.TrackReadWrite;

public class SlicksEditor
extends JPanel
implements ImageObserver,
TreeSelectionListener,
ImageLoader,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static boolean allowEdit = true;
    private JTree pieceTree;
    private DefaultTreeModel pieceModel;
    private DefaultMutableTreeNode pieceTop;
    public TreePanel treePanel;
    private JTree trackTree;
    DefaultTreeModel trackModel;
    TrackNode trackTop;
    public TrackPanel trackPanel;
    private static BufferStrategy bs = null;
    public EditorCommand lastCommand;
    public TextInput textInput;
    DefaultMutableTreeNode Background;
    DefaultMutableTreeNode Invisible;
    DefaultMutableTreeNode Blocks;
    DefaultMutableTreeNode Markers;
    DefaultMutableTreeNode Solids;
    private JSplitPane splitPanePieceListAndPiecePic;
    private JSplitPane splitPaneListAndView;
    private static JMenuBar jMenuBar;
    String path = null;
    public Toolkit tk = this.getToolkit();
    public MediaTracker mt = new MediaTracker(this);
    public ImageLoader myLoader;
    public EditorMenuBar menuBarObject;
    public PiecePanel singlePieceView;
    public KeyboardInput keyboard;
    public KeyListener trackKB;
    public Track track;
    public EditorGraphics editorGraphics;
    JScrollPane trackView;
    public static TrackBlock suggestedPiece;
    public static DefaultMutableTreeNode suggestedPieceNode;
    public static TrackBlock selectedPiece;
    public TrackBlock lastPlacedPiece;
    private static boolean playWithLineStyle;
    private static String lineStyle;
    private static boolean useSystemLookAndFeel;
    FPS framesPerSec;

    static {
        playWithLineStyle = false;
        lineStyle = "Horizontal";
        useSystemLookAndFeel = false;
    }

    public SlicksEditor() {
        super(new GridLayout(1, 1));
        this.initTrack();
        this.initMenus();
        this.initPieceTree();
        this.initTrackTree();
        this.initPanels();
        this.textInput = new TextInput(this.track);
        this.framesPerSec = new FPS();
    }

    public void initPanels() {
        this.treePanel = new TreePanel(this.pieceTree, this.trackTree);
        this.singlePieceView = new PiecePanel(this);
        this.trackPanel = new TrackPanel();
        this.trackPanel.setVisible(true);
        this.trackPanel.assignTrackToPanel(this.track, this.editorGraphics);
        this.trackPanel.setFocusable(true);
        Console.print("TrackPanel RequestFocus");
        this.trackPanel.requestFocus();
        this.trackPanel.passEditor(this);
        this.trackView = new JScrollPane(this.trackPanel);
        this.trackView.setFocusable(false);
        Dimension minimumSize = new Dimension(700, 600);
        this.trackView.setMinimumSize(minimumSize);
        this.splitPanePieceListAndPiecePic = new JSplitPane(0);
        this.splitPanePieceListAndPiecePic.setTopComponent(this.treePanel);
        this.splitPanePieceListAndPiecePic.setBottomComponent(this.singlePieceView);
        this.splitPanePieceListAndPiecePic.setFocusable(false);
        this.splitPaneListAndView = new JSplitPane(1);
        this.splitPaneListAndView.setLeftComponent(this.splitPanePieceListAndPiecePic);
        this.splitPaneListAndView.setRightComponent(this.trackView);
        this.splitPaneListAndView.setFocusable(false);
        minimumSize = new Dimension(100, 100);
        this.splitPanePieceListAndPiecePic.setDividerLocation(250);
        this.splitPanePieceListAndPiecePic.setPreferredSize(new Dimension(200, 600));
        this.splitPaneListAndView.setDividerLocation(200);
        this.splitPaneListAndView.setPreferredSize(new Dimension(1000, 600));
        this.add(this.splitPaneListAndView);
    }

    public void initTrack() {
        this.track = new Track();
        this.editorGraphics = new EditorGraphics(this);
        this.editorGraphics.assignTrack(this.track);
    }

    public void initMenus() {
        this.lastCommand = new EditorCommand();
        jMenuBar = new JMenuBar();
        this.menuBarObject = new EditorMenuBar(jMenuBar, this);
        this.menuBarObject.passEditorToMenu(this);
    }

    public void initTrackTree() {
        this.trackTop = new TrackNode("NewTrackSession");
        Console.print("initTrackTree");
        this.createTrackNodes(this.trackTop);
        this.trackModel = new DefaultTreeModel(this.trackTop);
        this.trackTree = new JTree(this.trackModel);
        this.trackTree.getSelectionModel().setSelectionMode(1);
        this.trackTree.addTreeSelectionListener(this);
        if (playWithLineStyle) {
            System.out.println("line style = " + lineStyle);
            this.pieceTree.putClientProperty("JTree.lineStyle", lineStyle);
        }
    }

    public void initPieceTree() {
        Console.print("creating pieceTree");
        this.pieceTop = new DefaultMutableTreeNode("TrackLibrary");
        this.createNodes(this.pieceTop);
        this.pieceModel = new DefaultTreeModel(this.pieceTop);
        this.pieceTree = new JTree(this.pieceModel);
        this.pieceTree.getSelectionModel().setSelectionMode(1);
        this.pieceTree.addTreeSelectionListener(this);
        if (playWithLineStyle) {
            System.out.println("line style = " + lineStyle);
            this.pieceTree.putClientProperty("JTree.lineStyle", lineStyle);
        }
    }

    public void createTrackNodes(DefaultMutableTreeNode top) {
        Console.print("createTrackNodes");
        top.removeAllChildren();
        Object filelist = null;
        this.Background = new DefaultMutableTreeNode("Background");
        top.add(this.Background);
        this.Blocks = new DefaultMutableTreeNode("Blocks");
        top.add(this.Blocks);
        this.Solids = new DefaultMutableTreeNode("Solids");
        top.add(this.Solids);
        this.Markers = new DefaultMutableTreeNode("Markers");
        top.add(this.Markers);
        this.Invisible = new DefaultMutableTreeNode("Invisible");
        top.add(this.Invisible);
    }

    public void loadTrackIntoTree(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode node;
        int blocks = this.Blocks.getChildCount();
        int i = blocks - 1;
        while (i > -1) {
            Console.print("rem " + i);
            node = (DefaultMutableTreeNode)this.Blocks.getChildAt(i);
            this.Blocks.remove(node);
            --i;
        }
        blocks = this.Markers.getChildCount();
        i = blocks - 1;
        while (i > -1) {
            Console.print("rem " + i);
            node = (DefaultMutableTreeNode)this.Markers.getChildAt(i);
            this.Markers.remove(node);
            --i;
        }
        blocks = this.Invisible.getChildCount();
        i = blocks - 1;
        while (i > -1) {
            Console.print("rem " + i);
            node = (DefaultMutableTreeNode)this.Invisible.getChildAt(i);
            this.Invisible.remove(node);
            --i;
        }
        blocks = this.Background.getChildCount();
        i = blocks - 1;
        while (i > -1) {
            Console.print("rem " + i);
            node = (DefaultMutableTreeNode)this.Background.getChildAt(i);
            this.Background.remove(node);
            --i;
        }
        blocks = this.Solids.getChildCount();
        i = blocks - 1;
        while (i > -1) {
            Console.print("rem " + i);
            node = (DefaultMutableTreeNode)this.Solids.getChildAt(i);
            this.Solids.remove(node);
            --i;
        }
        if (this.track.trackpieces != null) {
            i = 0;
            while (i < this.track.trackpieces.size()) {
                this.track.trackpieces.elementAt(i).setName(this.track.trackpieces.elementAt((int)i).filename);
                this.Blocks.add(new DefaultMutableTreeNode(this.track.trackpieces.elementAt(i)));
                ++i;
            }
        }
        if (this.track.markerpieces != null) {
            i = 0;
            while (i < this.track.markerpieces.size()) {
                this.track.markerpieces.elementAt(i).setName(this.track.markerpieces.elementAt((int)i).filename);
                this.Markers.add(new DefaultMutableTreeNode(this.track.markerpieces.elementAt(i)));
                ++i;
            }
        }
        if (this.track.invisiblepieces != null) {
            i = 0;
            while (i < this.track.invisiblepieces.size()) {
                this.track.invisiblepieces.elementAt(i).setName(this.track.invisiblepieces.elementAt((int)i).filename);
                this.Invisible.add(new DefaultMutableTreeNode(this.track.invisiblepieces.elementAt(i)));
                ++i;
            }
        }
        if (this.track.backgroundpieces != null) {
            i = 0;
            while (i < this.track.backgroundpieces.size()) {
                this.track.backgroundpieces.elementAt(i).setName(this.track.backgroundpieces.elementAt((int)i).filename);
                this.Background.add(new DefaultMutableTreeNode(this.track.backgroundpieces.elementAt(i)));
                ++i;
            }
        }
        if (this.track.solidpieces != null) {
            i = 0;
            while (i < this.track.solidpieces.size()) {
                this.track.solidpieces.elementAt(i).setName(this.track.solidpieces.elementAt((int)i).filename);
                this.Solids.add(new DefaultMutableTreeNode(this.track.solidpieces.elementAt(i)));
                ++i;
            }
        }
        this.trackModel.nodeStructureChanged(this.Blocks);
        this.trackModel.nodeStructureChanged(this.Markers);
        this.trackModel.nodeStructureChanged(this.Background);
        this.trackModel.nodeStructureChanged(this.Invisible);
        this.trackModel.nodeStructureChanged(this.Solids);
        this.editorGraphics.checkAndCreateVectors(this.track);
    }

    private void createNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode filelist = null;
        try {
            this.path = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File dir = new File(String.valueOf(this.path) + "/res/1280x720/");
        filelist = this.addNodes(top, dir);
    }

    DefaultMutableTreeNode addNodes(DefaultMutableTreeNode curTop, File dir) {
        String curPath = dir.getPath();
        if (curPath.toString().endsWith("CVS")) {
            return null;
        }
        DefaultMutableTreeNode curDir = new DefaultMutableTreeNode(curPath);
        if (curTop != null && dir.isDirectory()) {
            int pos = curDir.toString().lastIndexOf("\\");
            DefaultMutableTreeNode name = new DefaultMutableTreeNode(curDir.toString().substring(pos));
            curTop.add(name);
            curDir = name;
        }
        Vector<String> ol = new Vector<String>();
        String[] tmp = dir.list();
        int i = 0;
        while (i < tmp.length) {
            ol.addElement(tmp[i]);
            ++i;
        }
        Collections.sort(ol, String.CASE_INSENSITIVE_ORDER);
        Vector files = new Vector();
        Vector<TrackBlock> pieces = new Vector<TrackBlock>();
        int i2 = 0;
        while (i2 < ol.size()) {
            String thisObject = (String)ol.elementAt(i2);
            String newPath = curPath.equals(".") ? thisObject : String.valueOf(curPath) + File.separator + thisObject;
            File f = new File(newPath);
            if (f.isDirectory() && thisObject.compareToIgnoreCase("Entries") != 0 && thisObject.compareToIgnoreCase("Repository") != 0 && thisObject.compareToIgnoreCase("CVS") != 0 && thisObject.compareToIgnoreCase("Root") != 0) {
                this.addNodes(curDir, f);
            } else if (thisObject.compareToIgnoreCase("Entries") != 0 && thisObject.compareToIgnoreCase("Repository") != 0 && thisObject.compareToIgnoreCase("CVS") != 0 && thisObject.compareToIgnoreCase("Root") != 0) {
                TrackBlock piece;
                if (curDir.toString().contains("testSub")) {
                    boolean bl = false;
                }
                String filename = "";
                if (!curTop.toString().contains("1280x720")) {
                    filename = String.valueOf(filename) + curTop.toString();
                }
                filename = String.valueOf(filename) + curDir.toString();
                filename = String.valueOf(filename) + "\\" + thisObject;
                if ((filename = filename.replace("\\", "/")).contains("trackpieces")) {
                    Console.print("trackpiece, filename: " + filename);
                    piece = new TrackBlock(thisObject);
                    piece.setFilename(filename);
                    piece.type = TrackBlock.BLOCK_TYPE_TRACK;
                    Console.print("name: " + piece.name);
                    piece.blockImg = this.editorGraphics.loadBlockImage(piece.filename);
                    piece.width = piece.blockImg.getWidth();
                    piece.height = piece.blockImg.getHeight();
                    pieces.addElement(piece);
                } else if (filename.contains("solidpieces")) {
                    Console.print("solidpiece, filename: " + filename);
                    piece = new TrackBlock(thisObject);
                    piece.setFilename(filename);
                    piece.type = TrackBlock.BLOCK_TYPE_SOLID;
                    piece.blockImg = this.editorGraphics.loadBlockImage("/solidpieces/" + piece.name);
                    piece.width = piece.blockImg.getWidth();
                    piece.height = piece.blockImg.getHeight();
                    pieces.addElement(piece);
                } else if (filename.contains("markers")) {
                    Console.print("markerpiece, filename: " + filename);
                    piece = new TrackMarker(thisObject);
                    piece.setFilename(filename);
                    ((TrackMarker)piece).type = TrackBlock.BLOCK_TYPE_MARKER;
                    ((TrackMarker)piece).blockImg = this.editorGraphics.loadBlockImage("/markers/" + ((TrackMarker)piece).name);
                    ((TrackMarker)piece).width = ((TrackMarker)piece).blockImg.getWidth();
                    ((TrackMarker)piece).height = ((TrackMarker)piece).blockImg.getHeight();
                    pieces.addElement(piece);
                } else if (filename.contains("backgrounds")) {
                    Console.print("backgroundpiece, filename: " + filename);
                    piece = new TrackBlock(thisObject);
                    piece.setFilename(filename);
                    piece.type = TrackBlock.BLOCK_TYPE_BACKGROUND;
                    piece.blockImg = this.editorGraphics.loadBlockImage("/backgrounds/" + piece.name);
                    piece.width = piece.blockImg.getWidth();
                    piece.height = piece.blockImg.getHeight();
                    pieces.addElement(piece);
                } else if (filename.contains("invisible")) {
                    Console.print("invisiblepiece, filename: " + filename);
                    piece = new TrackMarker(thisObject);
                    piece.setFilename(filename);
                    ((TrackMarker)piece).type = TrackBlock.BLOCK_TYPE_INVISIBLE;
                    ((TrackMarker)piece).blockImg = this.editorGraphics.loadBlockImage("/invisiblepieces/" + ((TrackMarker)piece).name);
                    ((TrackMarker)piece).width = ((TrackMarker)piece).blockImg.getWidth();
                    ((TrackMarker)piece).height = ((TrackMarker)piece).blockImg.getHeight();
                    pieces.addElement(piece);
                } else {
                    piece = new TrackBlock(thisObject);
                    piece.setFilename(filename);
                    pieces.addElement(piece);
                }
            }
            ++i2;
        }
        int fnum = 0;
        while (fnum < pieces.size()) {
            curDir.add(new DefaultMutableTreeNode(pieces.elementAt(fnum)));
            ++fnum;
        }
        if (curDir.toString().endsWith("CVS")) {
            Console.print("returning null");
            return null;
        }
        return curDir;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        Console.print("obj: " + node.getUserObject().toString());
        if (e.getPath().toString().contains("TrackLibrary")) {
            try {
                TrackBlock userObj = (TrackBlock)node.getUserObject();
                suggestedPieceNode = node;
                TrackBlock tb = new TrackBlock((TrackBlock)node.getUserObject());
                Console.print("You selected " + node + " from path " + e.getPath());
                if (node.getUserObject().getClass() != String.class) {
                    this.singlePieceView.updateLabel(node);
                }
                tb.x = this.trackPanel.getWidth() / 2 - tb.width / 2;
                tb.y = this.trackPanel.getHeight() / 2 - tb.height / 2;
                suggestedPiece = tb;
                this.trackPanel.drawPanel();
            }
            catch (ClassCastException ee) {
                Console.print("known exception, " + ee);
            }
        } else {
            try {
                Console.print("selecting piece on existing track");
                selectedPiece = (TrackBlock)node.getUserObject();
                this.trackPanel.paintComponent(this.trackPanel.getGraphics());
            }
            catch (ClassCastException ee) {
                Console.print("known exception, " + ee);
            }
        }
    }

    private static void createAndShowGUI() {
        if (useSystemLookAndFeel) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                System.err.println("Couldn't use system look and feel.");
            }
        }
        JFrame frame = new JFrame("SlicksEditor");
        frame.setDefaultCloseOperation(3);
        SlicksEditor se = new SlicksEditor();
        frame.add(se);
        frame.setJMenuBar(jMenuBar);
        frame.pack();
        frame.setVisible(true);
        Console.print("Editor req focus");
        frame.requestFocus();
    }

    public void resize() {
        Console.print("are we resizing?");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SlicksEditor.createAndShowGUI();
                Console.print("created");
            }
        });
    }

    public URL getResourceURL(String path) {
        URL url = null;
        try {
            url = SlicksEditor.class.getResource(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    protected static ImageIcon createImageIcon(String path) {
        Console.print("getting images with path: " + path);
        URL imgURL = SlicksEditor.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + imgURL);
        return null;
    }

    @Override
    public Image getImage(String name) {
        URL url = this.getResourceURL(name);
        Toolkit tk = this.getToolkit();
        Image img = tk.getImage(url);
        if (img == null) {
            Console.print("img " + name + " is null");
        } else if (img.getWidth(null) <= 0) {
            this.mt.addImage(img, 1);
            try {
                this.mt.waitForAll();
            }
            catch (InterruptedException e) {
                System.out.println("getImage " + name + " ex: " + e);
            }
        }
        return img;
    }

    @Override
    public BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = SlicksEditor.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public void loadTrack(URL url) {
        this.track = new Track();
        TrackPanel.numControlPoints = 0;
        TrackReadWrite tr = new TrackReadWrite();
        try {
            Console.print("hello?");
            tr.chooseVersion(url, this.track);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Console.print("load track ready, getImages");
        this.editorGraphics.loadTrackImages(this.track);
        this.trackView.setSize(this.track.width, this.track.height);
        this.trackPanel.assignTrackToPanel(this.track, this.editorGraphics);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Console.print("action :" + e.getActionCommand());
    }

    protected JComponent makeTextPanel(String text) {
        JPanel panel = new JPanel(false);
        JLabel filler = new JLabel(text);
        filler.setHorizontalAlignment(0);
        panel.setLayout(new GridLayout(1, 1));
        panel.add(filler);
        return panel;
    }
}

