/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.SlicksEditor;
import editor.TrackPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Vector;
import other.Console;
import slicks.engine.ImageLoader;
import slicks.model.Track;
import slicks.model.TrackBlock;
import slicks.model.TrackMarker;

public class EditorGraphics {
    public static int resolution = 1;
    public static int RES_800x600 = 0;
    public static int RES_1280x720 = 1;
    public static int RES_1920x1080 = 2;
    public static boolean trackResUp = false;
    public static boolean trackResDown = false;
    public boolean trackLargerThanScreen = false;
    public boolean viewControlPoints = true;
    public boolean viewGuideBoxes = true;
    public static String[] resStr = new String[]{"800x600", "1280x720", "1920x1080"};
    public static double[] screenRatio = new double[]{0.625, 1.0, 1.5};
    public static int keypointX = 0;
    public static int keypointY = 0;
    public boolean drawInvisibleBlocks = true;
    public Track track;
    ImageLoader il;

    public EditorGraphics(ImageLoader il) {
        this.il = il;
        this.track = new Track();
    }

    public void assignTrack(Track track) {
        this.track = track;
    }

    public void checkAndCreateVectors(Track track) {
        if (track.markerpieces == null) {
            track.markerpieces = new Vector();
        }
        if (track.trackpieces == null) {
            track.trackpieces = new Vector();
        }
        if (track.invisiblepieces == null) {
            track.invisiblepieces = new Vector();
        }
        if (track.backgroundpieces == null) {
            track.backgroundpieces = new Vector();
        }
        if (track.solidpieces == null) {
            track.solidpieces = new Vector();
        }
    }

    public void drawBackGroundBounds(Graphics g) {
        g.setColor(Color.green);
        g.drawRect(0 + keypointX, 0 + keypointY, (int)((double)this.track.width * screenRatio[resolution]), (int)((double)this.track.height * screenRatio[resolution]));
    }

    public void drawBlock(Graphics g, TrackBlock trackObj) {
        g.drawImage(trackObj.blockImg, (int)((double)keypointX + (double)trackObj.x * screenRatio[resolution]), (int)((double)keypointY + (double)trackObj.y * screenRatio[resolution]), null);
        if (trackObj.tempImg != null) {
            g.drawImage(trackObj.tempImg, (int)((double)keypointX + (double)trackObj.x * screenRatio[resolution]), (int)((double)keypointY + (double)trackObj.y * screenRatio[resolution]), null);
        }
    }

    public void drawTrack(Graphics g, Track track) {
        this.drawBackGroundBounds(g);
        this.drawTrackBlocks(g, track.backgroundpieces);
        this.drawTrackBlocks(g, track.trackpieces);
        this.drawTrackBlocks(g, track.solidpieces);
        this.drawTrackBlocks(g, track.markerpieces);
        if (this.drawInvisibleBlocks) {
            this.drawTrackBlocks(g, track.invisiblepieces);
        }
        int y = 10;
        g.setClip(0, 0, 200, 200);
        g.setColor(Color.black);
        if (TrackPanel.mouseState == TrackPanel.STATE_EDIT_CONTROL_POINTS) {
            g.drawString("ControlPoint Create Mode ON", 10, y);
            y += 12;
        }
        if (this.viewControlPoints) {
            g.drawString("View ControlPoints ON", 10, y);
            y += 12;
        } else {
            g.drawString("View ControlPoints OFF", 10, y);
            y += 12;
        }
        if (this.viewGuideBoxes) {
            g.drawString("View Guides ON", 10, y);
            y += 12;
        } else {
            g.drawString("View Guides OFF", 10, y);
            y += 12;
        }
    }

    public void drawTrackBlocks(Graphics g, Vector blockVec) {
        TrackBlock selected = null;
        if (blockVec != null) {
            int i = 0;
            while (i < blockVec.size()) {
                TrackBlock block = (TrackBlock)blockVec.elementAt(i);
                g.drawImage(block.blockImg, (int)((double)keypointX + (double)block.x * screenRatio[resolution]), (int)((double)keypointY + (double)block.y * screenRatio[resolution]), null);
                if (block.equals(SlicksEditor.selectedPiece)) {
                    selected = SlicksEditor.selectedPiece;
                } else if (this.viewGuideBoxes) {
                    block.drawOutline(g, Color.blue, screenRatio[resolution], keypointX, keypointY);
                }
                if (block.type == TrackBlock.BLOCK_TYPE_MARKER && (((TrackMarker)block).markerType == 2 || ((TrackMarker)block).markerType == 3) && this.viewControlPoints) {
                    ((TrackMarker)block).drawControlPoints(g, keypointX, keypointY, false);
                }
                ++i;
            }
            if (selected != null) {
                if (this.viewGuideBoxes) {
                    selected.drawOutline(g, Color.red, screenRatio[resolution], keypointX, keypointY);
                }
                if (selected.type == TrackBlock.BLOCK_TYPE_MARKER && (((TrackMarker)selected).markerType == 2 || ((TrackMarker)selected).markerType == 3) && this.viewControlPoints) {
                    ((TrackMarker)selected).drawControlPoints(g, keypointX, keypointY, true);
                }
            }
        }
    }

    public boolean getBlock(int x, int y, Vector objvec) {
        if (!objvec.isEmpty()) {
            int i = objvec.size() - 1;
            while (i > -1) {
                TrackPanel.checkBlockPos.x = x;
                TrackPanel.checkBlockPos.y = y;
                TrackBlock b = (TrackBlock)objvec.elementAt(i);
                if (this.isInBounds(b, x, y)) {
                    Console.print("hitblock " + x + "," + y);
                    SlicksEditor.selectedPiece = b;
                    TrackPanel.dragPoint = this.getClickPoint(b, x, y);
                    Console.print("marker, dp " + TrackPanel.dragPoint.x + "," + TrackPanel.dragPoint.y);
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    public boolean getBlock(int x, int y) {
        if (this.getBlock(x, y, this.track.markerpieces)) {
            return true;
        }
        if (this.getBlock(x, y, this.track.invisiblepieces)) {
            return true;
        }
        if (this.getBlock(x, y, this.track.trackpieces)) {
            return true;
        }
        if (this.getBlock(x, y, this.track.solidpieces)) {
            return true;
        }
        return this.getBlock(x, y, this.track.backgroundpieces);
    }

    public Point getClickPoint(TrackBlock piece, int pixelX, int pixelY) {
        Point piecexy = piece.getXY();
        piecexy.x += keypointX;
        piecexy.y += keypointY;
        if (resolution != RES_1280x720) {
            piecexy.x = (int)((double)piecexy.x * screenRatio[resolution]);
            piecexy.y = (int)((double)piecexy.y * screenRatio[resolution]);
        }
        if (piecexy.x <= pixelX && piecexy.y <= pixelY) {
            Point piecewh = piece.getWH();
            if (pixelX <= piecexy.x + piecewh.x && pixelY <= piecexy.y + piecewh.y) {
                int posXOnPiece = pixelX - piecexy.x;
                int posYOnPiece = pixelY - piecexy.y;
                if (posXOnPiece < piecewh.x && posYOnPiece < piecewh.y) {
                    return new Point(posXOnPiece, posYOnPiece);
                }
            }
        }
        return null;
    }

    public boolean isInBounds(TrackBlock piece, int pixelX, int pixelY) {
        Point piecexy = piece.getXY();
        piecexy.x += keypointX;
        piecexy.y += keypointY;
        if (resolution != RES_1280x720) {
            piecexy.x = (int)((double)piecexy.x * screenRatio[resolution]);
            piecexy.y = (int)((double)piecexy.y * screenRatio[resolution]);
        }
        if (piecexy.x <= pixelX && piecexy.y <= pixelY) {
            Point piecewh = piece.getWH();
            if (pixelX <= piecexy.x + piecewh.x && pixelY <= piecexy.y + piecewh.y) {
                int posXOnPiece = pixelX - piecexy.x;
                int posYOnPiece = pixelY - piecexy.y;
                if (posXOnPiece < piecewh.x && posYOnPiece < piecewh.y) {
                    return true;
                }
            }
        }
        return false;
    }

    public BufferedImage loadBlockImage(String name) {
        Image tempImg = this.il.getImage("/" + resStr[resolution] + name);
        return this.il.toBufferedImage(tempImg);
    }

    public void loadImagesIntoVector(Vector objvec) {
        if (!objvec.isEmpty()) {
            int i = 0;
            while (i < objvec.size()) {
                TrackBlock block = (TrackBlock)objvec.elementAt(i);
                if (block.type != TrackBlock.BLOCK_TYPE_MARKER || ((TrackMarker)block).markerType != 2 && ((TrackMarker)block).markerType != 3) {
                    Image tempImg = null;
                    try {
                        tempImg = this.il.getImage("/" + resStr[resolution] + block.filename);
                    }
                    catch (NullPointerException e) {
                        Console.print("Ex: " + e);
                    }
                    if (tempImg != null) {
                        block.blockImg = this.il.toBufferedImage(tempImg);
                        if (block.rotationDegree != 0.0f) {
                            block.rotateOriginalImage(block.rotationDegree);
                        }
                        block.width = block.blockImg.getWidth(null);
                        block.height = block.blockImg.getHeight(null);
                    } else {
                        Console.print("missing gfx");
                    }
                }
                ++i;
            }
        }
    }

    public void loadTrackImages(Track trackObj) {
        this.checkAndCreateVectors(trackObj);
        Console.print("loadTrack, res: " + resolution);
        String loaderr = "0";
        try {
            loaderr = "Pieces";
            this.loadImagesIntoVector(trackObj.trackpieces);
            loaderr = "Markers";
            this.loadImagesIntoVector(trackObj.markerpieces);
            loaderr = "BackGounds";
            this.loadImagesIntoVector(trackObj.backgroundpieces);
            loaderr = "Invisibles";
            this.loadImagesIntoVector(trackObj.invisiblepieces);
            loaderr = "Solids";
            this.loadImagesIntoVector(trackObj.solidpieces);
        }
        catch (Exception e) {
            Console.print("exception loading track in " + loaderr + ", ex: " + e);
        }
    }

    public void unloadImagesFromVector(Vector objvec) {
        if (!objvec.isEmpty()) {
            int i = 0;
            while (i < objvec.size()) {
                TrackBlock block = (TrackBlock)objvec.elementAt(i);
                if (block.blockImg != null) {
                    block.blockImg = null;
                }
                ++i;
            }
        }
    }

    public void unloadImages(Track trackObj) {
        this.unloadImagesFromVector(trackObj.trackpieces);
        this.unloadImagesFromVector(trackObj.invisiblepieces);
        this.unloadImagesFromVector(trackObj.markerpieces);
        this.unloadImagesFromVector(trackObj.backgroundpieces);
        this.unloadImagesFromVector(trackObj.solidpieces);
    }
}

