/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libvorbis;

import org.xiph.libvorbis.adj_stereo;
import org.xiph.libvorbis.att3;
import org.xiph.libvorbis.bitrate_manager_info;
import org.xiph.libvorbis.codec_setup_info;
import org.xiph.libvorbis.compandblock;
import org.xiph.libvorbis.highlevel_byblocktype;
import org.xiph.libvorbis.highlevel_encode_setup;
import org.xiph.libvorbis.modes.setup_44;
import org.xiph.libvorbis.noise3;
import org.xiph.libvorbis.noiseguard;
import org.xiph.libvorbis.ovectl_ratemanage2_arg;
import org.xiph.libvorbis.static_codebook;
import org.xiph.libvorbis.ve_setup_data_template;
import org.xiph.libvorbis.vorbis_info;
import org.xiph.libvorbis.vorbis_info_floor1;
import org.xiph.libvorbis.vorbis_info_mapping0;
import org.xiph.libvorbis.vorbis_info_mode;
import org.xiph.libvorbis.vorbis_info_psy;
import org.xiph.libvorbis.vorbis_info_psy_global;
import org.xiph.libvorbis.vorbis_info_residue0;
import org.xiph.libvorbis.vorbis_mapping_template;
import org.xiph.libvorbis.vorbis_residue_template;
import org.xiph.libvorbis.vp_adjblock;

public class vorbisenc {
    private vorbis_info vi;
    private ve_setup_data_template[] setup_list;

    public vorbisenc() {
        setup_44 ve_setup_44_stereo = new setup_44();
        this.setup_list = new ve_setup_data_template[]{ve_setup_44_stereo.data};
    }

    public boolean vorbis_encode_setup_vbr(int channels, int rate, float quality) {
        if ((double)(quality = (float)((double)quality + 1.0E-7)) >= 1.0) {
            quality = 0.9999f;
        }
        if (!this.get_setup_template(channels, rate, quality, 0)) {
            System.out.println("Unable to find setup template - " + channels + " channels, " + rate + " rate, " + quality + " quality");
            return false;
        }
        return this.vorbis_encode_setup_setting(channels, rate);
    }

    public boolean vorbis_encode_init_vbr(vorbis_info _vi, int channels, int rate, float base_quality) {
        if (_vi == null) {
            System.out.println("vorbis_info doesnt exist");
            return false;
        }
        this.vi = _vi;
        if (!this.vorbis_encode_setup_vbr(channels, rate, base_quality)) {
            return false;
        }
        return this.vorbis_encode_setup_init();
    }

    public boolean vorbis_encode_setup_managed(vorbis_info _vi, int channels, int rate, int max_bitrate, int nominal_bitrate, int min_bitrate) {
        this.vi = _vi;
        float tnominal = new Integer(nominal_bitrate).floatValue();
        if ((double)nominal_bitrate <= 0.0) {
            if ((double)max_bitrate > 0.0) {
                nominal_bitrate = (double)min_bitrate > 0.0 ? new Double((double)(max_bitrate + min_bitrate) * 0.5).intValue() : new Double((double)max_bitrate * 0.875).intValue();
            } else if ((double)min_bitrate > 0.0) {
                nominal_bitrate = min_bitrate;
            } else {
                return false;
            }
        }
        if (!this.get_setup_template(channels, rate, nominal_bitrate, 1)) {
            System.out.println("Unable to find setup template - " + channels + " channels, " + rate + " rate, " + nominal_bitrate + " nominal_bitrate");
            return false;
        }
        this.vorbis_encode_setup_setting(channels, rate);
        highlevel_encode_setup hi = this.vi.codec_setup.hi;
        hi.managed = 1;
        hi.bitrate_min = min_bitrate;
        hi.bitrate_max = max_bitrate;
        hi.bitrate_av = new Float(tnominal).intValue();
        hi.bitrate_av_damp = 1.5f;
        hi.bitrate_reservoir = nominal_bitrate * 2;
        hi.bitrate_reservoir_bias = 0.1f;
        return true;
    }

    public boolean vorbis_encode_init(vorbis_info _vi, int channels, int rate, int max_bitrate, int nominal_bitrate, int min_bitrate) {
        if (_vi == null) {
            return false;
        }
        if (!this.vorbis_encode_setup_managed(_vi, channels, rate, max_bitrate, nominal_bitrate, min_bitrate)) {
            return false;
        }
        return this.vorbis_encode_setup_init();
    }

    public Object vorbis_encode_ctl(vorbis_info _vi, int number, Object arg) {
        if (_vi == null) {
            return false;
        }
        codec_setup_info ci = this.vi.codec_setup;
        highlevel_encode_setup hi = ci.hi;
        int setp = number & 0xF;
        if (setp > 0 && hi.set_in_stone > 0) {
            return false;
        }
        switch (number) {
            case 20: {
                ovectl_ratemanage2_arg ai = (ovectl_ratemanage2_arg)arg;
                if (ai == null) {
                    return false;
                }
                ai.management_active = hi.managed;
                ai.bitrate_limit_min_kbps = hi.bitrate_min / 1000;
                ai.bitrate_limit_max_kbps = hi.bitrate_max / 1000;
                ai.bitrate_average_kbps = hi.bitrate_av / 1000;
                ai.bitrate_average_damping = hi.bitrate_av_damp;
                ai.bitrate_limit_reservoir_bits = hi.bitrate_reservoir;
                ai.bitrate_limit_reservoir_bias = hi.bitrate_reservoir_bias;
                return ai;
            }
            case 21: {
                ovectl_ratemanage2_arg ai = (ovectl_ratemanage2_arg)arg;
                if (ai == null) {
                    hi.managed = 0;
                } else {
                    if (ai.bitrate_limit_min_kbps > 0 && ai.bitrate_average_kbps > 0 && ai.bitrate_limit_min_kbps > ai.bitrate_average_kbps) {
                        return false;
                    }
                    if (ai.bitrate_limit_max_kbps > 0 && ai.bitrate_average_kbps > 0 && ai.bitrate_limit_max_kbps < ai.bitrate_average_kbps) {
                        return false;
                    }
                    if (ai.bitrate_limit_min_kbps > 0 && ai.bitrate_limit_max_kbps > 0 && ai.bitrate_limit_min_kbps > ai.bitrate_limit_max_kbps) {
                        return false;
                    }
                    if ((double)ai.bitrate_average_damping <= 0.0) {
                        return false;
                    }
                    if (ai.bitrate_limit_reservoir_bits < 0) {
                        return false;
                    }
                    if ((double)ai.bitrate_limit_reservoir_bias < 0.0) {
                        return false;
                    }
                    if ((double)ai.bitrate_limit_reservoir_bias > 1.0) {
                        return false;
                    }
                    hi.managed = ai.management_active;
                    hi.bitrate_min = ai.bitrate_limit_min_kbps * 1000;
                    hi.bitrate_max = ai.bitrate_limit_max_kbps * 1000;
                    hi.bitrate_av = ai.bitrate_average_kbps * 1000;
                    hi.bitrate_av_damp = ai.bitrate_average_damping;
                    hi.bitrate_reservoir = ai.bitrate_limit_reservoir_bits;
                    hi.bitrate_reservoir_bias = ai.bitrate_limit_reservoir_bias;
                }
                return true;
            }
            case 32: {
                return Float.valueOf(hi.lowpass_kHz);
            }
            case 33: {
                hi.lowpass_kHz = ((Float)arg).floatValue();
                if (hi.lowpass_kHz < 2.0f) {
                    hi.lowpass_kHz = 2.0f;
                }
                if (hi.lowpass_kHz > 99.0f) {
                    hi.lowpass_kHz = 99.0f;
                }
                return true;
            }
            case 48: {
                return Float.valueOf(hi.impulse_noisetune);
            }
            case 49: {
                hi.impulse_noisetune = ((Float)arg).floatValue();
                if (hi.impulse_noisetune > 0.0f) {
                    hi.impulse_noisetune = 0.0f;
                }
                if (hi.impulse_noisetune < -15.0f) {
                    hi.impulse_noisetune = -15.0f;
                }
                return true;
            }
        }
        return true;
    }

    private boolean get_setup_template(int ch, int srate, float req, int q_or_bitrate) {
        int i = 0;
        highlevel_encode_setup hi = this.vi.codec_setup.hi;
        if (q_or_bitrate > 0) {
            req /= (float)ch;
        }
        while (this.setup_list[i] != null) {
            if ((this.setup_list[i].coupling_restriction == -1 || this.setup_list[i].coupling_restriction == ch) && srate >= this.setup_list[i].samplerate_min_restriction && srate <= this.setup_list[i].samplerate_max_restriction) {
                int mappings = this.setup_list[i].mappings;
                float[] map = q_or_bitrate > 0 ? this.setup_list[i].rate_mapping : this.setup_list[i].quality_mapping;
                if (req < map[0]) {
                    ++i;
                    continue;
                }
                if (req > map[this.setup_list[i].mappings]) {
                    ++i;
                    continue;
                }
                int j = 0;
                while (j < mappings) {
                    if (req >= map[j] && req < map[j + 1]) break;
                    ++j;
                }
                hi.setup = this.setup_list[i];
                if (j == mappings) {
                    hi.base_setting = (float)j - 0.001f;
                } else {
                    float low = map[j];
                    float high = map[j + 1];
                    float del = (req - low) / (high - low);
                    hi.base_setting = (float)j + del;
                }
                return true;
            }
            ++i;
        }
        hi.setup = null;
        return false;
    }

    private boolean vorbis_encode_setup_setting(int channels, int rate) {
        codec_setup_info ci = this.vi.codec_setup;
        highlevel_encode_setup hi = ci.hi;
        ve_setup_data_template setup = hi.setup;
        this.vi.version = 0;
        this.vi.channels = channels;
        this.vi.rate = rate;
        int is = new Float(hi.base_setting).intValue();
        float ds = hi.base_setting - (float)is;
        hi.short_setting = hi.base_setting;
        hi.long_setting = hi.base_setting;
        hi.managed = 0;
        hi.impulse_block_p = 1;
        hi.noise_normalize_p = 1;
        hi.stereo_point_setting = hi.base_setting;
        hi.lowpass_kHz = setup.psy_lowpass[is] * (1.0f - ds) + setup.psy_lowpass[is + 1] * ds;
        hi.ath_floating_dB = (float)setup.psy_ath_float[is] * (1.0f - ds) + (float)setup.psy_ath_float[is + 1] * ds;
        hi.ath_absolute_dB = (float)setup.psy_ath_abs[is] * (1.0f - ds) + (float)setup.psy_ath_abs[is + 1] * ds;
        hi.amplitude_track_dBpersec = -6.0f;
        hi.trigger_setting = hi.base_setting;
        int i = 0;
        while (i < 4) {
            hi.block[i] = new highlevel_byblocktype(hi.base_setting, hi.base_setting, hi.base_setting, hi.base_setting);
            ++i;
        }
        return true;
    }

    public boolean vorbis_encode_setup_init() {
        int i0 = 0;
        boolean singleblock = false;
        codec_setup_info ci = this.vi.codec_setup;
        ve_setup_data_template setup = null;
        highlevel_encode_setup hi = ci.hi;
        if (ci == null) {
            System.out.println("vorbis_info.codec_setup_info doesnt exist");
            return false;
        }
        if (hi.impulse_block_p == 0) {
            i0 = 1;
        }
        if (hi.ath_floating_dB > -80.0f) {
            hi.ath_floating_dB = -80.0f;
        }
        if (hi.ath_floating_dB < -200.0f) {
            hi.ath_floating_dB = -200.0f;
        }
        if ((double)hi.amplitude_track_dBpersec > 0.0) {
            hi.amplitude_track_dBpersec = 0.0f;
        }
        if ((double)hi.amplitude_track_dBpersec < -99999.0) {
            hi.amplitude_track_dBpersec = -99999.0f;
        }
        if ((setup = hi.setup) == null) {
            System.out.println("vorbis_info.codec_setup.highlevel_encode_setup.ve_setup_data_template doesnt exist");
            return false;
        }
        hi.set_in_stone = 1;
        this.vorbis_encode_blocksize_setup(hi.base_setting, setup.blocksize_short, setup.blocksize_long);
        if (ci.blocksizes[0] == ci.blocksizes[1]) {
            singleblock = true;
        }
        this.vorbis_encode_floor_setup(hi.short_setting, 0, setup.floor_books, setup.floor_params, setup.floor_short_mapping);
        if (!singleblock) {
            this.vorbis_encode_floor_setup(hi.long_setting, 1, setup.floor_books, setup.floor_params, setup.floor_long_mapping);
        }
        this.vorbis_encode_global_psych_setup(hi.trigger_setting, setup.global_params, setup.global_mapping);
        this.vorbis_encode_global_stereo(hi, setup.stereo_modes);
        this.vorbis_encode_psyset_setup(hi.short_setting, setup.psy_noise_normal_start[0], setup.psy_noise_normal_partition[0], setup.psy_noise_normal_thresh, 0);
        this.vorbis_encode_psyset_setup(hi.short_setting, setup.psy_noise_normal_start[0], setup.psy_noise_normal_partition[0], setup.psy_noise_normal_thresh, 1);
        if (!singleblock) {
            this.vorbis_encode_psyset_setup(hi.long_setting, setup.psy_noise_normal_start[1], setup.psy_noise_normal_partition[1], setup.psy_noise_normal_thresh, 2);
            this.vorbis_encode_psyset_setup(hi.long_setting, setup.psy_noise_normal_start[1], setup.psy_noise_normal_partition[1], setup.psy_noise_normal_thresh, 3);
        }
        this.vorbis_encode_tonemask_setup(hi.block[i0].tone_mask_setting, 0, setup.psy_tone_masteratt, setup.psy_tone_0dB, setup.psy_tone_adj_impulse);
        this.vorbis_encode_tonemask_setup(hi.block[1].tone_mask_setting, 1, setup.psy_tone_masteratt, setup.psy_tone_0dB, setup.psy_tone_adj_other);
        if (!singleblock) {
            this.vorbis_encode_tonemask_setup(hi.block[2].tone_mask_setting, 2, setup.psy_tone_masteratt, setup.psy_tone_0dB, setup.psy_tone_adj_other);
            this.vorbis_encode_tonemask_setup(hi.block[3].tone_mask_setting, 3, setup.psy_tone_masteratt, setup.psy_tone_0dB, setup.psy_tone_adj_long);
        }
        this.vorbis_encode_compand_setup(hi.block[i0].noise_compand_setting, 0, setup.psy_noise_compand, setup.psy_noise_compand_short_mapping);
        this.vorbis_encode_compand_setup(hi.block[1].noise_compand_setting, 1, setup.psy_noise_compand, setup.psy_noise_compand_short_mapping);
        if (!singleblock) {
            this.vorbis_encode_compand_setup(hi.block[2].noise_compand_setting, 2, setup.psy_noise_compand, setup.psy_noise_compand_long_mapping);
            this.vorbis_encode_compand_setup(hi.block[3].noise_compand_setting, 3, setup.psy_noise_compand, setup.psy_noise_compand_long_mapping);
        }
        this.vorbis_encode_peak_setup(hi.block[i0].tone_peaklimit_setting, 0, setup.psy_tone_dBsuppress);
        this.vorbis_encode_peak_setup(hi.block[1].tone_peaklimit_setting, 1, setup.psy_tone_dBsuppress);
        if (!singleblock) {
            this.vorbis_encode_peak_setup(hi.block[2].tone_peaklimit_setting, 2, setup.psy_tone_dBsuppress);
            this.vorbis_encode_peak_setup(hi.block[3].tone_peaklimit_setting, 3, setup.psy_tone_dBsuppress);
        }
        float userbias = 0.0f;
        if (i0 == 0) {
            userbias = hi.impulse_noisetune;
        }
        this.vorbis_encode_noisebias_setup(hi.block[i0].noise_bias_setting, 0, setup.psy_noise_dBsuppress, setup.psy_noise_bias_impulse, setup.psy_noiseguards, userbias);
        this.vorbis_encode_noisebias_setup(hi.block[1].noise_bias_setting, 1, setup.psy_noise_dBsuppress, setup.psy_noise_bias_padding, setup.psy_noiseguards, 0.0f);
        if (!singleblock) {
            this.vorbis_encode_noisebias_setup(hi.block[2].noise_bias_setting, 2, setup.psy_noise_dBsuppress, setup.psy_noise_bias_trans, setup.psy_noiseguards, 0.0f);
            this.vorbis_encode_noisebias_setup(hi.block[3].noise_bias_setting, 3, setup.psy_noise_dBsuppress, setup.psy_noise_bias_long, setup.psy_noiseguards, 0.0f);
        }
        this.vorbis_encode_ath_setup(0);
        this.vorbis_encode_ath_setup(1);
        if (!singleblock) {
            this.vorbis_encode_ath_setup(2);
            this.vorbis_encode_ath_setup(3);
        }
        this.vorbis_encode_map_n_res_setup(hi.base_setting, setup.maps);
        this.vi.bitrate_nominal = hi.bitrate_av > 0 ? hi.bitrate_av : new Float(this.setting_to_approx_bitrate()).intValue();
        this.vi.bitrate_lower = hi.bitrate_min;
        this.vi.bitrate_upper = hi.bitrate_max;
        this.vi.bitrate_window = hi.bitrate_av > 0 ? hi.bitrate_reservoir / hi.bitrate_av : 0;
        if (hi.managed > 0) {
            ci.bi = new bitrate_manager_info(hi.bitrate_av, hi.bitrate_min, hi.bitrate_max, hi.bitrate_reservoir, hi.bitrate_reservoir_bias, hi.bitrate_av_damp);
        }
        return true;
    }

    private void vorbis_encode_blocksize_setup(float s, int[] shortb, int[] longb) {
        codec_setup_info ci = this.vi.codec_setup;
        int is = new Float(s).intValue();
        int blockshort = shortb[is];
        int blocklong = longb[is];
        ci.blocksizes[0] = blockshort;
        ci.blocksizes[1] = blocklong;
    }

    private void vorbis_encode_floor_setup(float s, int block, static_codebook[][] books, vorbis_info_floor1[] in, int[] x) {
        int is = new Float(s).intValue();
        codec_setup_info ci = this.vi.codec_setup;
        vorbis_info_floor1 f = new vorbis_info_floor1(in[x[is]]);
        f.n = ci.blocksizes[block] >> 1;
        int partitions = f.partitions;
        int maxclass = -1;
        int maxbook = -1;
        int i = 0;
        while (i < partitions) {
            if (f.partitionclass[i] > maxclass) {
                maxclass = f.partitionclass[i];
            }
            ++i;
        }
        i = 0;
        while (i <= maxclass) {
            if (f.class_book[i] > maxbook) {
                maxbook = f.class_book[i];
            }
            int n = i;
            f.class_book[n] = f.class_book[n] + ci.books;
            int k = 0;
            while (k < 1 << f.class_subs[i]) {
                if (f.class_subbook[i][k] > maxbook) {
                    maxbook = f.class_subbook[i][k];
                }
                if (f.class_subbook[i][k] >= 0) {
                    int[] nArray = f.class_subbook[i];
                    int n2 = k;
                    nArray[n2] = nArray[n2] + ci.books;
                }
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i <= maxbook) {
            ci.book_param[ci.books++] = books[x[is]][i];
            ++i;
        }
        ci.floor_type[ci.floors] = 1;
        ci.floor_param[ci.floors] = f;
        ++ci.floors;
    }

    private void vorbis_encode_global_psych_setup(float s, vorbis_info_psy_global[] in, float[] x) {
        int is = new Float(s).intValue();
        float ds = s - (float)is;
        codec_setup_info ci = this.vi.codec_setup;
        vorbis_info_psy_global g = ci.psy_g_param = new vorbis_info_psy_global(in[new Float(x[is]).intValue()]);
        ds = x[is] * (1.0f - ds) + x[is + 1] * ds;
        if ((ds -= (float)(is = new Float(ds).intValue())) == 0.0f && is > 0) {
            --is;
            ds = 1.0f;
        }
        int i = 0;
        while (i < 4) {
            g.preecho_thresh[i] = new Double((double)in[is].preecho_thresh[i] * (1.0 - (double)ds) + (double)(in[is + 1].preecho_thresh[i] * ds)).floatValue();
            g.postecho_thresh[i] = new Double((double)in[is].postecho_thresh[i] * (1.0 - (double)ds) + (double)(in[is + 1].postecho_thresh[i] * ds)).floatValue();
            ++i;
        }
        g.ampmax_att_per_sec = ci.hi.amplitude_track_dBpersec;
    }

    private void vorbis_encode_global_stereo(highlevel_encode_setup hi, adj_stereo[] p) {
        float s = hi.stereo_point_setting;
        int is = new Float(s).intValue();
        float ds = s - (float)is;
        codec_setup_info ci = this.vi.codec_setup;
        vorbis_info_psy_global g = ci.psy_g_param;
        if (p != null) {
            g.coupling_prepointamp = (int[])p[is].pre.clone();
            g.coupling_postpointamp = (int[])p[is].post.clone();
            if (hi.managed != 0) {
                int i = 0;
                while (i < 15) {
                    float kHz = new Double((double)p[is].kHz[i] * (1.0 - (double)ds) + (double)(p[is + 1].kHz[i] * ds)).floatValue();
                    g.coupling_pointlimit[0][i] = new Double((double)kHz * 1000.0 / (double)this.vi.rate * (double)ci.blocksizes[0]).intValue();
                    g.coupling_pointlimit[1][i] = new Double((double)kHz * 1000.0 / (double)this.vi.rate * (double)ci.blocksizes[1]).intValue();
                    g.coupling_pkHz[i] = new Float(kHz).intValue();
                    kHz = new Double((double)p[is].lowpasskHz[i] * (1.0 - (double)ds) + (double)(p[is + 1].lowpasskHz[i] * ds)).floatValue();
                    g.sliding_lowpass[0][i] = new Double((double)kHz * 1000.0 / (double)this.vi.rate * (double)ci.blocksizes[0]).intValue();
                    g.sliding_lowpass[1][i] = new Double((double)kHz * 1000.0 / (double)this.vi.rate * (double)ci.blocksizes[1]).intValue();
                    ++i;
                }
            } else {
                float kHz = new Double((double)p[is].kHz[7] * (1.0 - (double)ds) + (double)(p[is + 1].kHz[7] * ds)).floatValue();
                int i = 0;
                while (i < 15) {
                    g.coupling_pointlimit[0][i] = new Double((double)kHz * 1000.0 / (double)this.vi.rate * (double)ci.blocksizes[0]).intValue();
                    g.coupling_pointlimit[1][i] = new Double((double)kHz * 1000.0 / (double)this.vi.rate * (double)ci.blocksizes[1]).intValue();
                    g.coupling_pkHz[i] = new Float(kHz).intValue();
                    ++i;
                }
                kHz = new Double((double)p[is].lowpasskHz[7] * (1.0 - (double)ds) + (double)(p[is + 1].lowpasskHz[7] * ds)).floatValue();
                i = 0;
                while (i < 15) {
                    g.sliding_lowpass[0][i] = new Double((double)kHz * 1000.0 / (double)this.vi.rate * (double)ci.blocksizes[0]).intValue();
                    g.sliding_lowpass[1][i] = new Double((double)kHz * 1000.0 / (double)this.vi.rate * (double)ci.blocksizes[1]).intValue();
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < 15) {
                g.sliding_lowpass[0][i] = ci.blocksizes[0];
                g.sliding_lowpass[1][i] = ci.blocksizes[1];
                ++i;
            }
        }
    }

    private void vorbis_encode_psyset_setup(float s, int[] nn_start, int[] nn_partition, float[] nn_thresh, int block) {
        codec_setup_info ci = this.vi.codec_setup;
        highlevel_encode_setup hi = ci.hi;
        int is = new Float(s).intValue();
        if (block >= ci.psys) {
            ci.psys = block + 1;
        }
        ci.psy_param[block] = new vorbis_info_psy(-1, -140.0f, -140.0f, new float[]{0.0f, 0.0f, 0.0f}, 0.0f, 0.0f, -40.0f, new float[]{0.0f}, 1, -0.0f, 0.5f, 0.5f, 0, 0, 0, new float[][]{{-1.0f}, {-1.0f}, {-1.0f}}, new float[]{-1.0f}, 105.0f, 0, 0, -1, -1, 0.0f);
        vorbis_info_psy p = ci.psy_param[block];
        p.blockflag = block >> 1;
        if (hi.noise_normalize_p != 0) {
            p.normal_channel_p = 1;
            p.normal_point_p = 1;
            p.normal_start = nn_start[is];
            p.normal_partition = nn_partition[is];
            p.normal_thresh = nn_thresh[is];
        }
    }

    private void vorbis_encode_tonemask_setup(float s, int block, att3[] att, int[] max, vp_adjblock[] in) {
        int is = new Float(s).intValue();
        float ds = s - (float)is;
        codec_setup_info ci = this.vi.codec_setup;
        vorbis_info_psy p = ci.psy_param[block];
        p.tone_masteratt[0] = new Double((double)att[is].att[0] * (1.0 - (double)ds) + (double)((float)att[is + 1].att[0] * ds)).floatValue();
        p.tone_masteratt[1] = new Double((double)att[is].att[1] * (1.0 - (double)ds) + (double)((float)att[is + 1].att[1] * ds)).floatValue();
        p.tone_masteratt[2] = new Double((double)att[is].att[2] * (1.0 - (double)ds) + (double)((float)att[is + 1].att[2] * ds)).floatValue();
        p.tone_centerboost = new Double((double)att[is].boost * (1.0 - (double)ds) + (double)(att[is + 1].boost * ds)).floatValue();
        p.tone_decay = new Double((double)att[is].decay * (1.0 - (double)ds) + (double)(att[is + 1].decay * ds)).floatValue();
        p.max_curve_dB = new Double((double)max[is] * (1.0 - (double)ds) + (double)((float)max[is + 1] * ds)).floatValue();
        int i = 0;
        while (i < 17) {
            p.toneatt[i] = new Double((double)in[is].block[i] * (1.0 - (double)ds) + (double)((float)in[is + 1].block[i] * ds)).floatValue();
            ++i;
        }
    }

    private void vorbis_encode_compand_setup(float s, int block, compandblock[] in, float[] x) {
        int is = new Float(s).intValue();
        float ds = s - (float)is;
        codec_setup_info ci = this.vi.codec_setup;
        vorbis_info_psy p = ci.psy_param[block];
        ds = x[is] * (1.0f - ds) + x[is + 1] * ds;
        if ((ds -= (float)(is = new Float(ds).intValue())) == 0.0f && is > 0) {
            --is;
            ds = 1.0f;
        }
        int i = 0;
        while (i < 40) {
            p.noisecompand[i] = new Double((double)in[is].data[i] * (1.0 - (double)ds) + (double)((float)in[is + 1].data[i] * ds)).floatValue();
            ++i;
        }
    }

    private void vorbis_encode_peak_setup(float s, int block, int[] suppress) {
        int is = new Float(s).intValue();
        float ds = s - (float)is;
        codec_setup_info ci = this.vi.codec_setup;
        vorbis_info_psy p = ci.psy_param[block];
        p.tone_abs_limit = new Double((double)suppress[is] * (1.0 - (double)ds) + (double)((float)suppress[is + 1] * ds)).floatValue();
    }

    private void vorbis_encode_noisebias_setup(float s, int block, int[] suppress, noise3[] in, noiseguard[] guard, float userbias) {
        int i;
        int is = new Float(s).intValue();
        float ds = s - (float)is;
        codec_setup_info ci = this.vi.codec_setup;
        vorbis_info_psy p = ci.psy_param[block];
        p.noisemaxsupp = new Double((double)suppress[is] * (1.0 - (double)ds) + (double)((float)suppress[is + 1] * ds)).floatValue();
        p.noisewindowlomin = guard[block].lo;
        p.noisewindowhimin = guard[block].hi;
        p.noisewindowfixed = guard[block].fixed;
        int j = 0;
        while (j < 3) {
            i = 0;
            while (i < 17) {
                p.noiseoff[j][i] = new Double((double)in[is].data[j][i] * (1.0 - (double)ds) + (double)((float)in[is + 1].data[j][i] * ds)).floatValue();
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < 3) {
            float min = p.noiseoff[j][0] + 6.0f;
            i = 0;
            while (i < 17) {
                float[] fArray = p.noiseoff[j];
                int n = i;
                fArray[n] = fArray[n] + userbias;
                if (p.noiseoff[j][i] < min) {
                    p.noiseoff[j][i] = min;
                }
                ++i;
            }
            ++j;
        }
    }

    private void vorbis_encode_ath_setup(int block) {
        codec_setup_info ci = this.vi.codec_setup;
        vorbis_info_psy p = ci.psy_param[block];
        p.ath_adjatt = ci.hi.ath_floating_dB;
        p.ath_maxatt = ci.hi.ath_absolute_dB;
    }

    private int book_dup_or_new(codec_setup_info ci, static_codebook book) {
        int i = 0;
        while (i < ci.books) {
            if (ci.book_param[i] == book) {
                return i;
            }
            ++i;
        }
        return ci.books++;
    }

    private void vorbis_encode_residue_setup(int number, int block, vorbis_residue_template res) {
        int bookid;
        int k;
        codec_setup_info ci = this.vi.codec_setup;
        ci.residue_param[number] = new vorbis_info_residue0(res.res);
        vorbis_info_residue0 r = ci.residue_param[number];
        if (ci.residues <= number) {
            ci.residues = number + 1;
        }
        switch (ci.blocksizes[block]) {
            case 64: 
            case 128: 
            case 256: {
                r.grouping = 16;
                break;
            }
            default: {
                r.grouping = 32;
            }
        }
        ci.residue_type[number] = res.res_type;
        r.end = ci.blocksizes[block] >> 1;
        if (res.res_type == 2) {
            r.end *= this.vi.channels;
        }
        int booklist = 0;
        if (ci.hi.managed != 0) {
            int i = 0;
            while (i < r.partitions) {
                k = 0;
                while (k < 3) {
                    if (res.books_base_managed.books[i][k] != null) {
                        int n = i;
                        r.secondstages[n] = r.secondstages[n] | 1 << k;
                    }
                    ++k;
                }
                ++i;
            }
            r.groupbook = this.book_dup_or_new(ci, res.book_aux_managed);
            ci.book_param[r.groupbook] = res.book_aux_managed;
            i = 0;
            while (i < r.partitions) {
                k = 0;
                while (k < 3) {
                    if (res.books_base_managed.books[i][k] != null) {
                        bookid = this.book_dup_or_new(ci, res.books_base_managed.books[i][k]);
                        r.booklist[booklist++] = bookid;
                        ci.book_param[bookid] = res.books_base_managed.books[i][k];
                    }
                    ++k;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < r.partitions) {
                k = 0;
                while (k < 3) {
                    if (res.books_base.books[i][k] != null) {
                        int n = i;
                        r.secondstages[n] = r.secondstages[n] | 1 << k;
                    }
                    ++k;
                }
                ++i;
            }
            r.groupbook = this.book_dup_or_new(ci, res.book_aux);
            ci.book_param[r.groupbook] = res.book_aux;
            i = 0;
            while (i < r.partitions) {
                k = 0;
                while (k < 3) {
                    if (res.books_base.books[i][k] != null) {
                        bookid = this.book_dup_or_new(ci, res.books_base.books[i][k]);
                        r.booklist[booklist++] = bookid;
                        ci.book_param[bookid] = res.books_base.books[i][k];
                    }
                    ++k;
                }
                ++i;
            }
        }
        float freq = ci.hi.lowpass_kHz * 1000.0f;
        vorbis_info_floor1 f = ci.floor_param[block];
        float nyq = (float)this.vi.rate / 2.0f;
        int blocksize = ci.blocksizes[block] >> 1;
        if (freq > nyq) {
            freq = nyq;
        }
        f.n = new Double(freq / nyq * (float)blocksize).intValue();
        if (res.limit_type != 0 && (freq = ci.hi.managed != 0 ? (float)ci.psy_g_param.coupling_pkHz[14] * 1000.0f : (float)ci.psy_g_param.coupling_pkHz[7] * 1000.0f) > nyq) {
            freq = nyq;
        }
        r.end = ci.residue_type[block] == 2 ? new Double((double)(freq / nyq * (float)blocksize * 2.0f / (float)r.grouping) + 0.9).intValue() * r.grouping : new Double((double)(freq / nyq * (float)blocksize / (float)r.grouping) + 0.9).intValue() * r.grouping;
    }

    private void vorbis_encode_map_n_res_setup(float s, vorbis_mapping_template[] maps) {
        codec_setup_info ci = this.vi.codec_setup;
        int is = new Float(s).intValue();
        int modes = 2;
        vorbis_info_mapping0[] map = maps[is].map;
        vorbis_info_mode[] mode = new vorbis_info_mode[]{new vorbis_info_mode(0, 0, 0, 0), new vorbis_info_mode(1, 0, 0, 1)};
        vorbis_residue_template[] res = maps[is].res;
        if (ci.blocksizes[0] == ci.blocksizes[1]) {
            modes = 1;
        }
        int i = 0;
        while (i < modes) {
            ci.mode_param[i] = new vorbis_info_mode(mode[i]);
            if (i >= ci.modes) {
                ci.modes = i + 1;
            }
            ci.map_type[i] = 0;
            ci.map_param[i] = new vorbis_info_mapping0(map[i]);
            if (i >= ci.maps) {
                ci.maps = i + 1;
            }
            int j = 0;
            while (j < map[i].submaps) {
                this.vorbis_encode_residue_setup(map[i].residuesubmap[j], i, res[map[i].residuesubmap[j]]);
                ++j;
            }
            ++i;
        }
    }

    private float setting_to_approx_bitrate() {
        codec_setup_info ci = this.vi.codec_setup;
        highlevel_encode_setup hi = ci.hi;
        ve_setup_data_template setup = hi.setup;
        int is = new Float(hi.base_setting).intValue();
        float ds = hi.base_setting - (float)is;
        int ch = this.vi.channels;
        float[] r = setup.rate_mapping;
        if (r == null) {
            return -1.0f;
        }
        return (r[is] * (1.0f - ds) + r[is + 1] * ds) * (float)ch;
    }
}

