/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libshout;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import org.xiph.libshout.Base64EncoderDecoder;

public class ShoutClient {
    private Socket socket = null;
    private OutputStream socketOutputStream = null;
    private boolean connected = false;
    private String mount = null;
    private String host = null;
    private int port = 0;
    private String username = null;
    private String password = null;
    private String url = null;
    private String genre = null;
    private String title = null;
    private String desc = null;
    private char[] base64table = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public ShoutClient() {
        this.connected = false;
    }

    public ShoutClient(String host, int port, String mount, String user, String password) {
        this.host = host;
        this.port = port;
        this.mount = mount;
        this.username = user;
        this.password = password;
        this.connected = false;
    }

    public boolean connect(String host, int port, String mount, String user, String password) {
        this.host = host;
        this.port = port;
        this.mount = mount;
        this.username = user;
        this.password = password;
        return this.connect();
    }

    public boolean connect() {
        if (!this.isConnected()) {
            try {
                this.socket = new Socket(this.host, this.port);
                this.socketOutputStream = this.socket.getOutputStream();
                this.socket.setTcpNoDelay(true);
                this.writeHeader();
            }
            catch (UnknownHostException e) {
                this.connected = false;
                System.out.println("Unknown host: " + this.host);
            }
            catch (IOException e) {
                this.connected = false;
                System.out.println("Socket Connection Error: http://" + this.host + ":" + this.port);
                System.out.println(e + "\n");
            }
        }
        return this.connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getMount() {
        return this.mount;
    }

    public void setMount(String mount) {
        this.mount = mount;
    }

    public String getUser() {
        return this.username;
    }

    public void setUser(String user) {
        this.username = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void writeHeader() throws IOException {
        this.socketOutputStream.write(new String("SOURCE " + this.mount + " HTTP/1.0" + "\r\n").getBytes());
        Base64EncoderDecoder base64Encode = new Base64EncoderDecoder(null, "");
        String rawAuth = String.valueOf(this.username) + ":" + this.password;
        String encodedAuth = base64Encode.encodeBase64(this.base64table.toString(), rawAuth);
        this.socketOutputStream.write(new String("Authorization: Basic " + encodedAuth + "\r\n").getBytes());
        this.socketOutputStream.write(new String("User-Agent: libshout/\r\n").getBytes());
        this.socketOutputStream.write(new String("Content-Type: application/ogg\r\n").getBytes());
        this.socketOutputStream.write(new String("ice-url: " + this.url + "\r\n").getBytes());
        this.socketOutputStream.write(new String("ice-public: 1\r\n").getBytes());
        this.socketOutputStream.write(new String("ice-genre: " + this.genre + "\r\n").getBytes());
        this.socketOutputStream.write(new String("ice-name: " + this.title + "\r\n").getBytes());
        this.socketOutputStream.write(new String("ice-description: " + this.desc + "\r\n").getBytes());
        this.socketOutputStream.write(new String("\r\n").getBytes());
        this.socketOutputStream.flush();
        System.out.println("OggCast Header Sent");
        this.connected = this.readHeaderResponse();
    }

    public boolean readHeaderResponse() throws IOException {
        InputStream socketInputStream = this.socket.getInputStream();
        InputStreamReader isr = new InputStreamReader(socketInputStream);
        BufferedReader br = new BufferedReader(isr);
        String responseHeader = br.readLine();
        System.out.println(responseHeader);
        int responseCodeIndex = responseHeader.indexOf(32);
        int responseCode = Integer.parseInt(responseHeader.substring(responseCodeIndex + 1, responseCodeIndex + 4));
        return responseCode >= 200 && responseCode < 300;
    }

    public void write(byte[] foo, int foostart, int foolength, byte[] bar, int barstart, int barlength) {
        try {
            this.socketOutputStream.write(foo, foostart, foolength);
            this.socketOutputStream.write(bar, barstart, barlength);
            this.socketOutputStream.flush();
        }
        catch (IOException e) {
            this.connected = false;
            System.out.println("Socket Connection Error: http://" + this.host + ":" + this.port);
            System.out.println(e);
        }
    }

    public void close() {
        try {
            this.connected = false;
            this.socket.shutdownOutput();
            this.socketOutputStream.close();
            this.socket.close();
            this.socketOutputStream = null;
            this.socket = null;
        }
        catch (Exception e) {
            System.out.println("Socket Connection Error: http://" + this.host + ":" + this.port);
            System.out.println(e);
        }
        System.out.println("Disconnected from: http://" + this.host + ":" + this.port);
    }
}

