/*
 * Decompiled with CFR 0.152.
 */
import com.sun.opengl.util.BufferUtil;
import ddf.minim.AudioPlayer;
import ddf.minim.Controller;
import ddf.minim.Minim;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.sound.sampled.Control;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PVector;

public class Powerslide
extends PApplet {
    public GameBoard board;
    public PFont font;
    public ArrayList balls;
    public boolean FORCE_DEBUG = false;
    public int SHOWING_BOARD = 1;
    public int PLAYING = 2;
    public int STARTING_GAME = 3;
    public int SHOWING_WINNER = 4;
    public int LOADING = 5;
    public int BOARD_LAYOUT = 6;
    public int state;
    public int LEAVE_BEHIND = 1;
    public int FINISH_FIRST = 2;
    public int way_of_win;
    private static final int MAX_BALLS = 8;
    private float time;
    private float time_old;
    private Player[] players;
    private float show_board_x;
    private float[] drawing_coords;
    private boolean RUN_TESTS = false;
    private PImage logo;
    private PImage bg_starting_game;
    private PImage bg_loading;
    private PImage bg_next_slide;
    private Player last_winner = null;
    private int last_points = 0;
    private float game_bg_alpha = 0.0f;
    private int rounds;
    private Minim minim;
    private AudioPlayer[] audio_players;
    private int currently_playing;
    private AudioPlayer player;
    private boolean paused;
    private static final float max_ingame_dist = 0.1f;
    public static final float max_len_to_draw = 2000.0f;
    boolean renderUsingVA = true;

    public void setup() {
        this.size(1280, 720, "processing.opengl.PGraphicsOpenGL");
        this.board = new GameBoard();
        this.font = this.loadFont("Bauhaus93-48.vlw");
        this.balls = new ArrayList();
        this.frameRate(30.0f);
        this.time = this.millis();
        this.logo = this.loadImage("logo.png");
        this.logo.resize(170, 53);
        this.bg_starting_game = this.loadImage("background_starting_game.png");
        this.bg_loading = this.loadImage("bg_loading.png");
        this.bg_loading.resize(1280, 720);
        this.bg_next_slide = this.loadImage("bg_next_slide.png");
        this.background(0);
        this.initMusic();
        Player player = null;
        Player player2 = null;
        try {
            player = new Player(1, 0.0f, 0.5f);
            player2 = new Player(2, 0.0f, 0.5f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.players = new Player[2];
        this.players[0] = player;
        this.players[1] = player2;
        this.state = this.LOADING;
        this.show_board_x = 1.0f;
        this.rounds = 0;
        this.board.addForce(0.0f, 0.0f, 1.0E-4f, 1.0E-4f);
    }

    private void initMusic() {
        this.currently_playing = 2;
        this.paused = false;
        this.audio_players = new AudioPlayer[4];
        this.minim = new Minim((PApplet)this);
        String[] stringArray = new String[]{"When_Time_Stands_Still_by__pk_.mp3", "fusion_of_sound_by_pk__ananasmurska.mp3", "Menace_by__pk_.mp3", "Sound_of_Silence_by__pk_.mp3"};
        int n = 0;
        while (n < stringArray.length) {
            this.audio_players[n] = this.minim.loadFile(stringArray[n], 1024);
            ++n;
        }
        this.player().play();
    }

    private void nextSong() {
        this.player().rewind();
        ++this.currently_playing;
        if (this.currently_playing > this.audio_players.length - 1) {
            this.currently_playing = 0;
        }
        this.player().play();
    }

    private void keepMusicRunning() {
        if (!this.player().isPlaying()) {
            this.nextSong();
        }
    }

    private AudioPlayer player() {
        return this.audio_players[this.currently_playing];
    }

    public void stop() {
        this.minim.stop();
        super.stop();
    }

    public void keyReleased() {
        if (this.state == this.LOADING) {
            return;
        }
        if (this.state == this.PLAYING) {
            PVector pVector = new PVector(0.0f, 0.0f, 0.0f);
            if (this.keyCode == 37) {
                pVector.add(new PVector(-1.0f, 0.0f, 0.0f));
            }
            if (this.keyCode == 38) {
                pVector.add(new PVector(0.0f, -1.0f, 0.0f));
            }
            if (this.keyCode == 39) {
                pVector.add(new PVector(1.0f, 0.0f, 0.0f));
            }
            if (this.keyCode == 40) {
                pVector.add(new PVector(0.0f, 1.0f, 0.0f));
            }
            pVector.normalize();
            this.players[0].removeAcceleration(pVector);
            pVector = new PVector(0.0f, 0.0f, 0.0f);
            if (this.keyCode == 65) {
                pVector.add(new PVector(-1.0f, 0.0f, 0.0f));
            }
            if (this.keyCode == 87) {
                pVector.add(new PVector(0.0f, -1.0f, 0.0f));
            }
            if (this.keyCode == 68) {
                pVector.add(new PVector(1.0f, 0.0f, 0.0f));
            }
            if (this.keyCode == 83) {
                pVector.add(new PVector(0.0f, 1.0f, 0.0f));
            }
            pVector.normalize();
            this.players[1].removeAcceleration(pVector);
        }
    }

    public void keyPressed() {
        if (this.keyCode == 77 && this.player().hasControl((Control.Type)Controller.MUTE)) {
            if (this.player().isMuted()) {
                this.player().unmute();
            } else {
                this.player().mute();
            }
        }
        if (this.state == this.LOADING) {
            return;
        }
        if (this.keyCode == 80) {
            boolean bl = this.paused = !this.paused;
            if (this.player().isPlaying()) {
                this.player().pause();
            } else {
                this.player().play();
            }
        } else if (this.keyCode == 78) {
            this.player().rewind();
            this.player().pause();
            this.nextSong();
        }
        if (this.keyCode == 8) {
            this.endGame();
        }
        if (this.state == this.STARTING_GAME) {
            if (this.keyCode == 10) {
                int n = 0;
                while (n < 8) {
                    this.addBall(this.players[n % 2]);
                    ++n;
                }
                this.state = this.PLAYING;
            }
        } else if (this.state == this.SHOWING_BOARD) {
            if (this.keyCode == 10) {
                this.state = this.STARTING_GAME;
                this.game_bg_alpha = 0.0f;
            }
        } else if (this.state == this.BOARD_LAYOUT) {
            if (this.keyCode == 10) {
                this.state = this.SHOWING_BOARD;
            }
        } else if (this.state == this.SHOWING_WINNER) {
            if (this.keyCode == 10) {
                this.endGame();
            }
        } else if (this.state == this.PLAYING) {
            PVector pVector = new PVector(0.0f, 0.0f, 0.0f);
            if (this.keyCode == 37) {
                pVector.add(new PVector(-1.0f, 0.0f, 0.0f));
            }
            if (this.keyCode == 38) {
                pVector.add(new PVector(0.0f, -1.0f, 0.0f));
            }
            if (this.keyCode == 39) {
                pVector.add(new PVector(1.0f, 0.0f, 0.0f));
            }
            if (this.keyCode == 40) {
                pVector.add(new PVector(0.0f, 1.0f, 0.0f));
            }
            pVector.normalize();
            this.players[0].addAcceleration(pVector);
            if (this.keyCode == 10) {
                this.players[0].addForcePoint();
            } else if (this.keyCode == 16) {
                this.players[0].changeForceDirection();
            }
            pVector = new PVector(0.0f, 0.0f, 0.0f);
            if (this.keyCode == 65) {
                pVector.add(new PVector(-1.0f, 0.0f, 0.0f));
            }
            if (this.keyCode == 87) {
                pVector.add(new PVector(0.0f, -1.0f, 0.0f));
            }
            if (this.keyCode == 68) {
                pVector.add(new PVector(1.0f, 0.0f, 0.0f));
            }
            if (this.keyCode == 83) {
                pVector.add(new PVector(0.0f, 1.0f, 0.0f));
            }
            pVector.normalize();
            this.players[1].addAcceleration(pVector);
            if (this.keyCode == 32) {
                this.players[1].addForcePoint();
            } else if (this.keyCode == 17) {
                this.players[1].changeForceDirection();
            }
        }
    }

    private void addBall(Player player) {
        this.balls.add(new Ball(this.board, player));
    }

    public ArrayList forcePoints() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.players.length) {
            ArrayList arrayList2 = this.players[n].forcePoints();
            if (arrayList2 != null) {
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    arrayList.add(arrayList2.get(n2));
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList;
    }

    public float smallestBallRadius() {
        float f = 100000.0f;
        int n = 0;
        while (n < this.balls.size()) {
            Ball ball = (Ball)this.balls.get(n);
            float f2 = ball.radius();
            if (f2 < f) {
                f = f2;
            }
            ++n;
        }
        return f;
    }

    public float biggestBallRadius() {
        float f = -1.0f;
        int n = 0;
        while (n < this.balls.size()) {
            Ball ball = (Ball)this.balls.get(n);
            float f2 = ball.radius();
            if (f2 > f) {
                f = f2;
            }
            ++n;
        }
        return f;
    }

    public float timeDelta() {
        float f = this.time - this.time_old;
        return f / 1000.0f;
    }

    public void updateAndMoveBalls() {
        Object object;
        int n = 0;
        while (n < this.balls.size()) {
            Ball ball = (Ball)this.balls.get(n);
            ball.updateVelocity();
            ++n;
        }
        ArrayList arrayList = this.forcePoints();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            object = (ForcePoint)arrayList.get(n2);
            ((ForcePoint)object).drag();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.balls.size()) {
            object = (Ball)this.balls.get(n2);
            ((Ball)object).checkCollisions();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.balls.size()) {
            object = (Ball)this.balls.get(n2);
            ((Ball)object).move();
            ++n2;
        }
    }

    public Ball firstBall() {
        if (this.balls.size() < 1) {
            return null;
        }
        Ball ball = null;
        int n = 0;
        while (n < this.balls.size()) {
            Ball ball2 = (Ball)this.balls.get(n);
            if (ball == null || ball2.coords()[0] > ball.coords()[0]) {
                ball = ball2;
            }
            ++n;
        }
        return ball;
    }

    public Ball lastBallForPlayer(Player player) {
        if (this.balls.size() < 1) {
            return null;
        }
        Ball ball = null;
        int n = 0;
        while (n < this.balls.size()) {
            Ball ball2 = (Ball)this.balls.get(n);
            if (ball2.player() == player && (ball == null || ball2.coords()[0] < ball.coords()[0])) {
                ball = ball2;
            }
            ++n;
        }
        return ball;
    }

    public void draw() {
        if (!this.paused) {
            this.keepMusicRunning();
        }
        this.background(0);
        if (this.state == this.PLAYING || this.state == this.STARTING_GAME) {
            this.drawGame();
        } else if (this.state == this.SHOWING_WINNER) {
            this.showWinner();
        } else if (this.state == this.LOADING) {
            this.showLoading();
        } else if (this.state == this.BOARD_LAYOUT) {
            this.showBoardLayout();
        } else {
            this.showBoard();
        }
    }

    private void showBoard() {
        int n = -1;
        float[] fArray = this.board.getCoords(this.show_board_x, 0.5f);
        PVector pVector = new PVector(this.board.endCoords()[0], this.board.endCoords()[1], this.board.endCoords()[2]);
        pVector.normalize();
        pVector.mult(this.show_board_x * this.board.boardlen());
        float f = this.board.boardlen() / 2.0f + (fArray[0] - this.board.boardlen() / 2.0f) / 1.2f;
        float f2 = pVector.z + 800.0f;
        float f3 = fArray[0] + (fArray[0] - this.board.boardlen() / 2.0f);
        float f4 = fArray[1];
        float f5 = pVector.z - 0.3f * (fArray[0] - this.board.boardlen() / 2.0f);
        this.camera(f, 1000.0f, f2, f3, f4, f5, 0.0f, 0.0f, -1.0f);
        this.lights();
        this.board.draw(0.0f, 1.0f);
        this.show_board_x += 0.008f * (float)n;
        if (this.show_board_x < 0.02f) {
            this.state = this.STARTING_GAME;
            this.game_bg_alpha = 0.0f;
        }
    }

    private Player inlead() {
        Player player = null;
        int n = 0;
        while (n < this.players.length) {
            if (player == null || this.players[n].points() > player.points()) {
                player = this.players[n];
            }
            ++n;
        }
        return player;
    }

    private boolean isTie() {
        return this.players[0].points() == this.players[1].points();
    }

    private void drawHUD(PVector pVector) {
        pVector.normalize();
        PVector pVector2 = pVector.get();
        pVector2.mult(-1.0f);
        new PVector(1.0f, 0.0f, 0.0f);
        PVector.angleBetween((PVector)pVector2, (PVector)new PVector(1.0f, 0.0f, 0.0f));
        PVector.angleBetween((PVector)pVector2, (PVector)new PVector(0.0f, 1.0f, 0.0f));
        float f = PVector.angleBetween((PVector)pVector2, (PVector)new PVector(0.0f, 0.0f, 1.0f));
        this.pushMatrix();
        this.rotateZ(-f);
        this.rotateX(-f);
        this.textFont(this.font, 64.0f);
        String string = String.valueOf(this.players[0].points()) + " - " + this.players[1].points();
        if (this.isTie()) {
            this.fill(1);
        } else {
            this.inlead().setFill();
        }
        this.text(string, 300.0f, -200.0f);
        if (this.state == this.PLAYING) {
            this.noFill();
            this.strokeWeight(0.5f);
            this.stroke(0.6f);
            this.translate(150.0f, -180.0f, 0.0f);
            float f2 = 400.0f;
            float f3 = 200.0f;
            this.board.drawCurve(f2, f3);
        }
        this.popMatrix();
    }

    private void drawGame() {
        this.calcDrawingArea();
        float[] fArray = this.drawing_area_coords();
        PVector pVector = this.board.guideline();
        PVector pVector2 = pVector.cross(new PVector(0.0f, -1.0f, 0.0f));
        pVector2.normalize();
        if (this.game_bg_alpha < 1.0f) {
            this.game_bg_alpha += 0.1f;
        }
        this.pushMatrix();
        this.noLights();
        this.tint(1.0f, 1.0f, 1.0f, this.game_bg_alpha);
        float f = 50.0f;
        this.translate(f * pVector2.x, f * pVector2.y, f * pVector2.z);
        float[] fArray2 = this.board.getCoords(fArray[0], 0.5f);
        this.beginShape();
        this.texture(this.bg_starting_game);
        this.textureMode(1);
        this.vertex(fArray2[0] - 4000.0f, 6000.0f, fArray2[2], 0.0f, 0.0f);
        this.vertex(fArray2[0] + 5000.0f, 6000.0f, fArray2[2] + 6000.0f * pVector.z, 0.0f, 1.0f);
        this.vertex(fArray2[0] + 5000.0f, -6000.0f, fArray2[2] + 6000.0f * pVector.z, 1.0f, 1.0f);
        this.vertex(fArray2[0] - 4000.0f, -6000.0f, fArray2[2], 1.0f, 0.0f);
        this.endShape(2);
        this.popMatrix();
        this.time_old = this.time;
        this.time = this.millis();
        this.updateAndMoveBalls();
        this.checkBalls();
        this.colorMode(1);
        if (this.state == this.STARTING_GAME) {
            this.pushMatrix();
            this.translate(-40.0f, 450.0f, 0.0f);
            this.fill(1.0f, 1.0f, 1.0f, 0.4f);
            this.rotateZ(Powerslide.radians((float)270.0f));
            this.rotateX(Powerslide.radians((float)-45.0f));
            this.textFont(this.font, 90.0f);
            this.text("HIT ENTER", 0.0f, 0.0f, 0.0f);
            this.popMatrix();
        }
        this.spotLight(255.0f, 255.0f, 255.0f, 10.0f, 50.0f, 140.0f, -1.0f, 0.0f, -1.0f, (float)Math.PI, 1.0f);
        if (this.state == this.PLAYING) {
            int n = 0;
            while (n < this.players.length) {
                this.players[n].move();
                this.players[n].draw(fArray[0], fArray[1]);
                ++n;
            }
            ArrayList arrayList = this.forcePoints();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                ForcePoint forcePoint = (ForcePoint)arrayList.get(n2);
                forcePoint.draw();
                ++n2;
            }
        }
        this.noLights();
        this.lights();
        this.noStroke();
        int n = 0;
        while (n < this.balls.size()) {
            Ball ball = (Ball)this.balls.get(n);
            ball.draw();
            ++n;
        }
        this.board.draw(fArray[0], fArray[1]);
        this.setCamera(fArray[0], fArray[1]);
        this.cleanOldForces();
    }

    private void calcDrawingArea() {
        Ball ball;
        Ball ball2 = this.firstBall();
        float f = 0.0f;
        float f2 = 1.0f;
        if (ball2 != null) {
            f2 = ball2.coords()[0] + 1000.0f / this.board.boardlen();
        }
        if (ball2 != null && (ball = this.lastBallForPlayer(ball2.player())) != null && ball != ball2) {
            f = ball.coords()[0];
        }
        if (this.balls.size() > 0) {
            float f3 = 2000.0f / this.board.boardlen();
            float f4 = f2 - f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f4 < f3) {
                float f5 = Powerslide.abs((float)(f3 - f4));
                f -= f5;
            } else if (f4 > f3) {
                float f6 = Powerslide.abs((float)(f3 - f4));
                f += f6;
            }
            if (f < 0.0f) {
                f2 += Powerslide.abs((float)f);
                f = 0.0f;
            }
            if (f2 > 1.0f) {
                f -= Powerslide.abs((float)f2);
                f2 = 1.0f;
            }
        }
        this.drawing_coords = new float[2];
        this.drawing_coords[0] = f;
        this.drawing_coords[1] = f2;
    }

    public float[] drawing_area_coords() {
        return this.drawing_coords;
    }

    private void showWinner() {
        this.resetMatrix();
        this.pushMatrix();
        this.camera(0.0f, 0.0f, 1000.0f, 0.0f, 0.1f, 0.1f, 0.0f, 0.0f, 1.0f);
        String string = "Player " + this.last_winner.ID() + " won the round!";
        String string2 = null;
        if (this.way_of_win == this.LEAVE_BEHIND) {
            string2 = "By leaving the opponent ";
            if (this.last_points > 8 / 2 / 2) {
                string2 = String.valueOf(string2) + "BRUTALLY ";
            }
            string2 = String.valueOf(string2) + "behind";
        } else if (this.way_of_win == this.FINISH_FIRST) {
            string2 = "By finishing first";
        }
        this.last_winner.setFill();
        this.textFont(this.font, 140.0f);
        this.text("+" + this.last_points + " points", -900.0f, 35.0f, 0.0f);
        this.textFont(this.font, 80.0f);
        this.text(string, -100.0f, 0.0f, 0.0f);
        this.textFont(this.font, 54.0f);
        this.fill(1.0f, 1.0f, 1.0f, 1.0f);
        this.text(string2, -100.0f, 65.0f, 0.0f);
        if ((float)this.millis() - this.time_old > 5000.0f) {
            float f = (float)this.millis() - this.time_old;
            float f2 = (f - 5000.0f) / 1000.0f;
            this.fill(0.0f, 0.0f, 0.0f, f2);
            this.beginShape();
            this.vertex(-this.width, -this.height, 5.0f);
            this.vertex(this.width, -this.height, 5.0f);
            this.vertex(this.width, this.height, 5.0f);
            this.vertex(-this.width, this.height, 5.0f);
            this.endShape(2);
        }
        this.popMatrix();
        if ((float)this.millis() - this.time_old > 6000.0f) {
            this.endGame();
        }
    }

    private void showBoardLayout() {
        float f = (float)this.millis() - this.time_old;
        float f2 = 1.0f - Powerslide.abs((float)(f - 3000.0f)) / 3000.0f;
        this.pushMatrix();
        this.camera(0.0f, 0.0f, 620.0f, 0.0f, 0.1f, 0.1f, 0.0f, 0.0f, 1.0f);
        this.noStroke();
        this.noTint();
        this.fill(1.0f, 1.0f, 1.0f, f2);
        this.noLights();
        this.pushMatrix();
        this.translate((float)(-this.width) / 2.0f, (float)(-this.height) / 2.0f);
        this.tint(1.0f, 1.0f, 1.0f, f2 * 2.0f);
        this.beginShape();
        this.texture(this.bg_next_slide);
        this.textureMode(1);
        this.vertex(0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        this.vertex(this.width, 0.0f, -1.0f, 1.0f, 0.0f);
        this.vertex(this.width, this.height, -1.0f, 1.0f, 1.0f);
        this.vertex(0.0f, this.height, -1.0f, 0.0f, 1.0f);
        this.endShape(2);
        this.popMatrix();
        this.lights();
        this.stroke(1.0f, 1.0f, 1.0f, f2);
        this.fill(0.4f, 0.6f, 0.3f, f2 * 1.2f);
        this.textFont(this.font, 80.0f);
        this.text("Next slide", 150.0f, -180.0f, 5.0f);
        this.fill(1.0f, 1.0f, 1.0f, f2 * 1.2f);
        this.textFont(this.font, 32.0f);
        this.text("Get ready for round " + (this.rounds + 1) + "!", 155.0f, -150.0f, 5.0f);
        this.fill(1.0f, 1.0f, 1.0f, f2);
        this.translate(-500.0f, -300.0f);
        float f3 = 800.0f;
        float f4 = 600.0f;
        this.board.drawCurve(f3, f4);
        this.popMatrix();
        if (f > 6000.0f) {
            this.state = this.SHOWING_BOARD;
        }
    }

    private void showLoading() {
        float f = 1.0f;
        if (this.millis() > 9000) {
            f = (float)(3000 - (this.millis() - 9000)) / 3000.0f;
        }
        this.pushMatrix();
        this.camera(0.0f, 0.0f, 620.0f, 0.0f, 0.1f, 0.1f, 0.0f, 0.0f, 1.0f);
        this.pushMatrix();
        this.translate((float)(-this.width) / 2.0f, (float)(-this.height) / 2.0f);
        this.tint(1.0f, 1.0f, 1.0f, f * 1.2f);
        this.beginShape();
        this.texture(this.bg_loading);
        this.textureMode(1);
        this.vertex(0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        this.vertex(this.width, 0.0f, -1.0f, 1.0f, 0.0f);
        this.vertex(this.width, this.height, -1.0f, 1.0f, 1.0f);
        this.vertex(0.0f, this.height, -1.0f, 0.0f, 1.0f);
        this.endShape(2);
        this.popMatrix();
        this.textFont(this.font, 68.0f);
        this.stroke(0.0f, 0.0f, 0.0f, 1.0f);
        this.fill(0.4f, 0.6f, 0.3f, f * 1.2f);
        this.text("Powerslide", -500.0f, 42.0f);
        this.tint(1.0f, 1.0f, 1.0f, f * f * f * f * f);
        this.image(this.logo, -457.0f, -48.0f);
        this.popMatrix();
        if (this.millis() > 12000) {
            this.state = this.SHOWING_BOARD;
        }
    }

    private void setCamera(float f, float f2) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        Object object;
        if (this.state == this.STARTING_GAME) {
            object = this.board.endCoords();
            float f9 = 0.07f;
            f8 = 1000.0f + f9 * object[0];
            f7 = 500.0f;
            f6 = 1000.0f + f9 * object[2];
            f5 = f9 * object[0];
            f4 = f9 * object[1];
            f3 = f9 * object[2];
        } else {
            this.firstBall();
            float f10 = f + (f2 - f) / 2.5f;
            f5 = f10 * this.board.boardlen() - 300.0f;
            f4 = 100.0f;
            f3 = this.board.getCoords(f10, 0.0f)[2];
            f8 = f5 + 400.0f;
            f7 = 800.0f;
            f6 = f3 + 1100.0f;
        }
        this.camera(f8, f7, f6, f5, f4, f3, 0.0f, 0.0f, -1.0f);
        this.pushMatrix();
        this.translate(f8, f7, f6);
        object = new PVector(f5 - f8, f4 - f7, f3 - f6);
        object.mult(0.5f);
        this.translate(object.x, object.y, object.z);
        this.drawHUD((PVector)object);
        this.popMatrix();
    }

    private void cleanOldForces() {
        ArrayList arrayList = this.forcePoints();
        float[] fArray = this.drawing_area_coords();
        int n = 0;
        while (n < arrayList.size()) {
            ForcePoint forcePoint = (ForcePoint)arrayList.get(n);
            if (forcePoint.x() < fArray[0] || forcePoint.x() > fArray[1]) {
                forcePoint.player().removeForcePoint(forcePoint);
            }
            ++n;
        }
    }

    private void endGame() {
        this.balls = new ArrayList();
        this.board = new GameBoard();
        int n = 0;
        while (n < this.players.length) {
            this.players[n].reset(0.0f, 0.5f);
            ++n;
        }
        this.show_board_x = 1.0f;
        this.time_old = this.millis();
        this.state = this.BOARD_LAYOUT;
    }

    private void checkBalls() {
        Ball ball = this.firstBall();
        if (ball == null) {
            return;
        }
        int n = 0;
        while (n < this.balls.size()) {
            Ball ball2 = (Ball)this.balls.get(n);
            if (ball2.coords()[0] < this.drawing_area_coords()[0]) {
                this.balls.remove(ball2);
            }
            ++n;
        }
        Player player = null;
        int n2 = 0;
        int n3 = 0;
        if (this.players[0].numOfBalls() > 0 && this.players[1].numOfBalls() < 1) {
            player = this.players[0];
        } else if (this.players[1].numOfBalls() > 0 && this.players[0].numOfBalls() < 1) {
            player = this.players[1];
        }
        if (player != null) {
            n2 = player.numOfBalls();
            n3 = this.LEAVE_BEHIND;
        } else {
            int n4 = 0;
            while (n4 < this.balls.size()) {
                Ball ball3 = (Ball)this.balls.get(n4);
                if (ball3.inGoal()) {
                    player = ball3.player();
                    n2 = 8 / 2;
                    n3 = this.FINISH_FIRST;
                }
                ++n4;
            }
        }
        if (player != null) {
            this.last_winner = player;
            this.last_points = n2;
            this.way_of_win = n3;
            player.addPoints(n2);
            this.time_old = this.millis();
            this.state = this.SHOWING_WINNER;
            ++this.rounds;
        }
    }

    public void fadeToColor(GL gL, float f, float f2, float f3, float f4) {
        gL.glBlendFunc(770, 771);
        gL.glColor4f(f, f2, f3, f4);
        gL.glBegin(7);
        gL.glVertex2f(0.0f, 0.0f);
        gL.glVertex2f((float)this.width, 0.0f);
        gL.glVertex2f((float)this.width, (float)this.height);
        gL.glVertex2f(0.0f, (float)this.height);
        gL.glEnd();
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--present", "--bgcolor=#666666", "--hide-stop", "Powerslide"});
    }

    class Ball {
        private float x;
        private float y;
        private float z;
        private float mass = 0.8f;
        private float radius;
        private PVector forceSum;
        private PVector a;
        private PVector v;
        private GameBoard board;
        private ArrayList collided_with;
        private ArrayList impacts;
        private ArrayList player_forces;
        private Player player;
        private int points;

        public Ball(GameBoard gameBoard, Player player) {
            this.board = gameBoard;
            this.forceSum = new PVector(0.0f, 0.0f, 0.0f);
            this.player_forces = new ArrayList();
            this.a = new PVector(0.0f, 0.0f, 0.0f);
            this.v = new PVector(0.0f, 0.0f, 0.0f);
            this.radius = 15.0f;
            this.place(Powerslide.this.random(0.0f, 1.0f) * 0.01f, Powerslide.this.random(0.0f, 1.0f), 0.0f);
            this.player = player;
            this.points = 0;
        }

        public Player player() {
            return this.player;
        }

        public void place(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
            if (this.x < 0.0f) {
                this.x = 0.0f;
            } else if (this.x > 1.0f) {
                this.x = 1.0f;
            }
            Block block = this.board.blockAt(this.x);
            if (this.x + this.radius / this.board.boardlen() > 1.0f) {
                this.x = 1.0f - this.radius / this.board.boardlen();
            } else if (this.x - this.radius / this.board.boardlen() < 0.0f) {
                this.x = this.radius / this.board.boardlen();
            }
            if (this.y + this.radius / block.getWidth() > 1.0f) {
                this.y = 1.0f - this.radius / block.getWidth();
            } else if (this.y - this.radius / block.getWidth() < 0.0f) {
                this.y = this.radius / block.getWidth();
            }
        }

        public float radius() {
            return this.radius;
        }

        public PVector velocity() {
            return this.v;
        }

        public void addCollision(PVector pVector, Ball ball) {
            this.collided_with.add(ball);
            this.impacts.add(pVector);
        }

        public void addForce(PVector pVector) {
            this.player_forces.add(pVector);
        }

        private void updateVelocityVector() {
            PVector pVector = this.forceSum.get();
            pVector.div(this.mass());
            PVector pVector2 = pVector.get();
            pVector2.mult(0.1f);
            this.v.add(pVector2);
            this.forceSum = new PVector(0.0f, 0.0f, 0.0f);
            this.player_forces = new ArrayList();
        }

        public void updateVelocity() {
            this.collided_with = new ArrayList();
            this.impacts = new ArrayList();
            this.forceSum = new PVector(0.0f, 0.0f, 0.0f);
            Block block = this.board.blockAt(this.x);
            block.addBall(this);
            PVector pVector = block.normal();
            PVector pVector2 = new PVector(0.0f, 0.0f, -1.0f);
            pVector2.mult(9.81f * this.mass);
            pVector.mult(9.81f * this.mass);
            PVector pVector3 = new PVector(0.0f, 0.0f, 0.0f);
            pVector3.add(pVector2);
            pVector3.add(pVector);
            this.forceSum.add(pVector3);
            this.updateVelocityVector();
            this.a = new PVector(0.0f, 0.0f, 0.0f);
        }

        public void checkCollisions() {
            this.board.blockAt(this.x);
            float f = this.radius() + Powerslide.this.biggestBallRadius();
            float f2 = this.x - f / this.board.boardlen();
            float f3 = this.x + f / this.board.boardlen();
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            int n = this.board.blockIndexAt(f2);
            int n2 = this.board.blockIndexAt(f3);
            int n3 = n;
            while (n3 <= n2) {
                ArrayList arrayList = this.board.blockAt(n3).getBalls();
                if (arrayList.size() > 1) {
                    int n4 = 0;
                    while (n4 < arrayList.size()) {
                        Ball ball = (Ball)arrayList.get(n4);
                        if (ball != this && !this.collided_with.contains(ball)) {
                            float[] fArray = ball.coords();
                            float[] fArray2 = this.board.getCoords(fArray[0], fArray[1]);
                            float[] fArray3 = this.board.getCoords(this.x, this.y);
                            PVector pVector = new PVector(fArray3[0], fArray3[1], fArray3[2]);
                            PVector pVector2 = new PVector(fArray2[0], fArray2[1], fArray2[2]);
                            PVector pVector3 = pVector.get();
                            pVector3.sub(pVector2);
                            if (Powerslide.abs((float)pVector3.mag()) - (this.radius + ball.radius()) < this.radius / 4.0f) {
                                PVector pVector4 = this.velocity();
                                pVector4.dot(pVector3.get());
                                pVector4.mult(-1.0f);
                                PVector pVector5 = ball.velocity();
                                pVector5.dot(pVector3.get());
                                PVector pVector6 = pVector4.get();
                                pVector6.sub(pVector5);
                                float f4 = -1.5f * pVector6.mag() / (1.0f / this.mass() + 1.0f / ball.mass());
                                PVector pVector7 = pVector3.get();
                                pVector7.mult(f4);
                                pVector7.dot(pVector3);
                                pVector7.mult(0.4f);
                                pVector7.mult(-1.0f);
                                this.addCollision(pVector7, ball);
                                PVector pVector8 = pVector7.get();
                                pVector8.mult(-1.0f);
                                ball.addCollision(pVector8, this);
                            }
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
        }

        public float mass() {
            return this.mass;
        }

        public void move() {
            PVector pVector;
            PVector pVector2;
            Block block = this.board.blockAt(this.x);
            this.board.getCoords(this.x, this.y);
            if (this.y + this.radius / block.getWidth() > 1.0f) {
                if (this.v.y > 0.0f) {
                    pVector2 = new PVector(0.0f, this.v.y * -1.0f, 0.0f);
                    this.impacts.add(pVector2);
                }
                this.y = 1.0f - this.radius / block.getWidth();
            } else if (this.y - this.radius / block.getWidth() < 0.0f) {
                if (this.v.y < 0.0f) {
                    pVector2 = new PVector(0.0f, this.v.y * -1.0f, 0.0f);
                    this.impacts.add(pVector2);
                }
                this.y = this.radius / block.getWidth();
            }
            int n = 0;
            while (n < this.impacts.size()) {
                pVector = (PVector)this.impacts.get(n);
                pVector.div(this.mass());
                pVector.div(2.0f);
                this.forceSum.add(pVector);
                ++n;
            }
            n = 0;
            while (n < this.player_forces.size()) {
                pVector = (PVector)this.player_forces.get(n);
                this.forceSum.add(pVector);
                ++n;
            }
            this.updateVelocityVector();
            if (this.x + this.radius / this.board.boardlen() >= 1.0f) {
                if (this.v.x > 0.0f) {
                    PVector pVector3 = new PVector(this.v.x * -1.0f, 0.0f, this.v.z * -1.0f);
                    this.v.add(pVector3);
                }
            } else if (this.x - this.radius / this.board.boardlen() < 0.0f && this.v.x < 0.0f) {
                PVector pVector4 = new PVector(this.v.x * -1.0f, 0.0f, this.v.z * -1.0f);
                this.v.add(pVector4);
            }
            this.v.mult(0.96f);
            if (this.impacts.size() > 0) {
                this.v.mult(0.7f * (1.0f / (float)this.impacts.size()));
            }
            PVector pVector5 = this.v.get();
            this.x += pVector5.x / this.board.boardlen();
            this.y += pVector5.y / block.getWidth();
            this.z += pVector5.z;
            this.place(this.x, this.y, this.z);
        }

        public float[] coords() {
            float[] fArray = new float[]{this.x, this.y, this.z};
            return fArray;
        }

        public void draw() {
            Powerslide.this.colorMode(1);
            this.player().setFill();
            Powerslide.this.strokeWeight(1.5f);
            Powerslide.this.stroke(0.0f, 0.0f, 0.0f, 0.1f);
            float[] fArray = this.board.getCoords(this.x, this.y);
            Powerslide.this.pushMatrix();
            Powerslide.this.translate(fArray[0], fArray[1], fArray[2] + 18.0f);
            Powerslide.this.sphere(this.radius);
            Powerslide.this.popMatrix();
            Powerslide.this.stroke(1.0f, 0.0f, 0.0f, 1.0f);
            if (Powerslide.this.FORCE_DEBUG) {
                int n = 0;
                while (n < this.impacts.size()) {
                    PVector pVector = (PVector)this.impacts.get(n);
                    pVector.div(this.mass());
                    Powerslide.this.beginShape();
                    Powerslide.this.vertex(fArray[0], fArray[1], fArray[2]);
                    Powerslide.this.vertex(fArray[0] + 2.0f * pVector.x, fArray[1] + 2.0f * pVector.y, fArray[2] + 2.0f * pVector.z);
                    Powerslide.this.endShape();
                    ++n;
                }
            }
            Powerslide.this.stroke(0);
        }

        public boolean inGoal() {
            return this.board.blockAt(this.x).isGoal();
        }
    }

    class Block {
        private PVector direction;
        private float length;
        private float width;
        private float start_x;
        private float start_y;
        private float start_z;
        private GameBoard board;
        private boolean isGoal;
        private ArrayList balls;

        public Block(GameBoard gameBoard, float f, float f2, PVector pVector, float f3, float f4, float f5, boolean bl) {
            this.length = f;
            this.width = f2;
            this.direction = pVector;
            this.start_x = f3;
            this.start_y = f4;
            this.start_z = f5;
            this.board = gameBoard;
            this.isGoal = bl;
            this.balls = new ArrayList();
        }

        public PVector normal() {
            PVector pVector = new PVector(0.0f, 1.0f, 0.0f);
            pVector = pVector.cross(this.direction);
            pVector.mult(-1.0f);
            pVector.normalize();
            return pVector;
        }

        public void addBall(Ball ball) {
            this.balls.add(ball);
        }

        public ArrayList getBalls() {
            return this.balls;
        }

        public PVector directionScaled() {
            PVector pVector = new PVector(this.direction.x, this.direction.y, this.direction.z);
            pVector.mult(this.length);
            return pVector;
        }

        public PVector directionNormalized() {
            PVector pVector = new PVector(this.direction.x, this.direction.y, this.direction.z);
            pVector.normalize();
            return pVector;
        }

        public float z(float f) {
            PVector pVector = new PVector(this.direction.x, this.direction.y, this.direction.z);
            pVector.mult(f);
            return pVector.z;
        }

        public void draw(float f, float f2) {
            this.balls = new ArrayList();
            float f3 = this.z(this.length);
            PImage pImage = this.board.fluidImg();
            Powerslide.this.textureMode(1);
            Powerslide.this.tint(255.0f, 255.0f, 255.0f);
            Powerslide.this.noStroke();
            if (this.isGoal()) {
                Powerslide.this.tint(255.0f, 0.0f, 0.0f);
            }
            Powerslide.this.beginShape();
            Powerslide.this.texture(pImage);
            Powerslide.this.vertex(0.0f, 0.0f, 0.0f, f, 0.0f);
            Powerslide.this.vertex(0.0f, this.width, 0.0f, f, 1.0f);
            Powerslide.this.vertex(this.length, this.width, f3, f2, 1.0f);
            Powerslide.this.vertex(this.length, 0.0f, f3, f2, 0.0f);
            Powerslide.this.endShape();
            Powerslide.this.fill(1.0f, 0.0f, 0.0f, 0.2f);
            if (this.isGoal) {
                float f4 = 40.0f;
                Powerslide.this.beginShape(16);
                Powerslide.this.vertex(0.0f, 0.0f, 0.0f);
                Powerslide.this.vertex(0.0f, 0.0f, f4);
                Powerslide.this.vertex(this.length, 0.0f, f4 + f3);
                Powerslide.this.vertex(this.length, 0.0f, f3);
                Powerslide.this.vertex(0.0f, this.width, 0.0f);
                Powerslide.this.vertex(0.0f, this.width, f4);
                Powerslide.this.vertex(this.length, this.width, f4 + f3);
                Powerslide.this.vertex(this.length, this.width, f3);
                Powerslide.this.vertex(0.0f, 0.0f, f4);
                Powerslide.this.vertex(0.0f, this.width, f4);
                Powerslide.this.vertex(this.length, this.width, f4 + f3);
                Powerslide.this.vertex(this.length, 0.0f, f4 + f3);
                if (this == this.board.finishEnds()) {
                    Powerslide.this.vertex(this.length, 0.0f, f3);
                    Powerslide.this.vertex(this.length, 0.0f, f4 + f3);
                    Powerslide.this.vertex(this.length, this.width, f4 + f3);
                    Powerslide.this.vertex(this.length, this.width, f3);
                }
                Powerslide.this.endShape();
            }
        }

        public boolean isGoal() {
            return this.isGoal;
        }

        public float getWidth() {
            return this.width;
        }

        public float getLength() {
            return this.length;
        }

        public float[] startCoords() {
            float[] fArray = new float[]{this.start_x, this.start_y, this.start_z};
            return fArray;
        }
    }

    class ForcePoint {
        private float x;
        private float y;
        private int push_direction;
        private Player player;
        private float max_affect_range = 400.0f;

        public ForcePoint(float f, float f2, int n, Player player) {
            this.x = f;
            this.y = f2;
            this.push_direction = n;
            this.player = player;
        }

        public float x() {
            return this.x;
        }

        public void drag() {
            Powerslide.this.board.blockAt(this.x);
            float[] fArray = Powerslide.this.board.getCoords(this.x, this.y);
            PVector pVector = new PVector(fArray[0], fArray[1], fArray[2]);
            int n = 0;
            while (n < Powerslide.this.balls.size()) {
                Ball ball = (Ball)Powerslide.this.balls.get(n);
                float[] fArray2 = ball.coords();
                float[] fArray3 = Powerslide.this.board.getCoords(fArray2[0], fArray2[1]);
                PVector pVector2 = new PVector(fArray3[0], fArray3[1], fArray3[2]);
                PVector pVector3 = pVector.get();
                pVector3.sub(pVector2);
                if (Powerslide.abs((float)pVector3.mag()) < this.max_affect_range) {
                    PVector pVector4 = pVector3.get();
                    pVector4.normalize();
                    pVector4.mult((float)this.push_direction);
                    pVector4.mult(Powerslide.abs((float)(Powerslide.abs((float)pVector3.mag()) - 2000.0f)) / 2000.0f);
                    this.addFluid(ball, pVector4);
                    pVector4.mult(Powerslide.abs((float)pVector4.mag()));
                    pVector4.mult(-14.0f);
                    ball.addForce(pVector4);
                }
                ++n;
            }
        }

        private void addFluid(Ball ball, PVector pVector) {
            float[] fArray = ball.coords();
            float[] fArray2 = Powerslide.this.board.getCoords(fArray[0], fArray[1]);
            float[] fArray3 = Powerslide.this.drawing_area_coords();
            float[] fArray4 = Powerslide.this.board.getCoords(fArray3[0], fArray3[1]);
            float f = (fArray2[0] - fArray4[0]) / 2000.0f;
            Powerslide.this.board.addForce(f, fArray[1], pVector.x * 0.003f, pVector.y * 0.003f);
        }

        public Player player() {
            return this.player;
        }

        public void draw() {
            float f = 6.0f;
            Powerslide.this.pushMatrix();
            Powerslide.this.fill(0.0f, 255.0f, 0.0f);
            Powerslide.this.beginShape();
            this.player.setFill();
            float f2 = this.x - f / Powerslide.this.board.boardlen();
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float[] fArray = Powerslide.this.board.getCoords(f2, this.y);
            Powerslide.this.vertex(fArray[0], fArray[1] + f, fArray[2] + 0.1f);
            Powerslide.this.vertex(fArray[0], fArray[1] - f, fArray[2] + 0.1f);
            f2 = this.x + f / Powerslide.this.board.boardlen();
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            fArray = Powerslide.this.board.getCoords(f2, this.y);
            Powerslide.this.vertex(fArray[0], fArray[1] - f, fArray[2] + 0.1f);
            Powerslide.this.vertex(fArray[0], fArray[1] + f, fArray[2] + 0.1f);
            Powerslide.this.endShape();
            Powerslide.this.popMatrix();
        }
    }

    class GameBoard {
        private float length = 5000.0f;
        private int blocks_num = (int)this.length / 5;
        private static final int BLOCK_RESOLUTION = 5;
        private PVector guideline = new PVector(1.0f, 0.0f, -1.6f);
        private Block[] blocks;
        private final float FLUID_WIDTH = 160.0f;
        float invWidth;
        float invHeight;
        private float aspectRatio;
        private float aspectRatio2;
        private MSAFluidSolver2D fluidSolver;
        private ParticleSystem particleSystem;
        private PImage imgFluid;
        private boolean drawFluid = true;

        public GameBoard() {
            this.guideline.normalize();
            this.initBlocks();
            this.initFluid();
        }

        public PVector guideline() {
            return this.guideline;
        }

        public MSAFluidSolver2D fluidSolver() {
            return this.fluidSolver;
        }

        public float boardlen() {
            return this.length;
        }

        public float[] endCoords() {
            return this.getCoords(1.0f, 0.5f);
        }

        public Block blockAt(int n) {
            if (n < 0 || n >= this.blocks.length) {
                return null;
            }
            return this.blocks[n];
        }

        public int blockIndexAt(float f) {
            if (this.blocks.length <= 0 || f < 0.0f || f > 1.0f) {
                return -1;
            }
            return (int)(f * (float)(this.blocks.length - 1));
        }

        public Block blockAt(float f) {
            int n = this.blockIndexAt(f);
            if (n < 0) {
                return null;
            }
            return this.blocks[(int)(f * (float)(this.blocks.length - 1))];
        }

        public float[] getCoords(float f, float f2) {
            float f3 = f * this.length;
            Block block = this.blockAt(f);
            float[] fArray = block.startCoords();
            float f4 = f3 - fArray[0];
            float f5 = fArray[2] + block.z(f4);
            float[] fArray2 = new float[]{f3, fArray[1] + f2 * block.getWidth(), f5};
            return fArray2;
        }

        private void initFluid() {
            Powerslide.this.hint(2);
            this.invWidth = 5.0E-4f;
            this.invHeight = 0.002f;
            this.aspectRatio = 2000.0f * this.invHeight;
            this.aspectRatio2 = this.aspectRatio * this.aspectRatio;
            this.fluidSolver = new MSAFluidSolver2D(160, 40);
            this.fluidSolver.enableRGB(true).setFadeSpeed(0.08f).setDeltaT(0.5f).setVisc(1.0E-4f);
            this.imgFluid = Powerslide.this.createImage(this.fluidSolver.getWidth(), this.fluidSolver.getHeight(), 2);
            this.particleSystem = new ParticleSystem();
        }

        private void initBlocks() {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            this.blocks = new Block[this.blocks_num];
            float f4 = 2.0f;
            float f5 = 0.0f;
            int n = -1;
            int n2 = 40;
            int n3 = 0;
            while (n3 < this.blocks_num) {
                Block block;
                boolean bl;
                PVector pVector = this.guideline.get();
                if (n3 > n2 && n3 < this.blocks_num - n2) {
                    pVector.add(new PVector(0.0f, 0.0f, f5));
                }
                pVector.normalize();
                boolean bl2 = bl = (float)(this.blocks_num - n3) / (float)this.blocks_num < 0.01f;
                if (bl) {
                    pVector = this.guideline;
                }
                this.blocks[n3] = block = new Block(this, 5.0f, 500.0f, pVector, n3 * 5, f2, f3, bl);
                if ((f5 += 0.1f * (float)n) > f4 || f5 < -1.0f * f4) {
                    n *= -1;
                } else if (Powerslide.this.random(0.0f, 1.0f) > 0.95f) {
                    n *= -1;
                }
                PVector pVector2 = block.directionScaled();
                f += pVector2.x;
                f2 += pVector2.y;
                f3 += pVector2.z;
                ++n3;
            }
        }

        public Block finishStarts() {
            int n = 0;
            while (n < this.blocks.length) {
                if (this.blocks[n].isGoal) {
                    return this.blocks[n];
                }
                ++n;
            }
            return null;
        }

        public Block finishEnds() {
            return this.blocks[this.blocks.length - 1];
        }

        public PImage fluidImg() {
            return this.imgFluid;
        }

        public void draw(float f, float f2) {
            int n;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.fluidSolver.update();
            this.particleSystem.updateAndDraw();
            this.imgFluid.loadPixels();
            int n2 = 0;
            while (n2 < this.fluidSolver.getNumCells()) {
                int n3;
                n = 20;
                this.imgFluid.pixels[n2] = n3 = Powerslide.this.color(1.0f - this.fluidSolver.r[n2] * (float)n, 1.0f - this.fluidSolver.g[n2] * (float)n, 1.0f - this.fluidSolver.b[n2] * (float)n, 0.7f);
                ++n2;
            }
            this.imgFluid.updatePixels();
            Powerslide.this.stroke(255.0f, 255.0f, 255.0f);
            int cfr_ignored_0 = this.imgFluid.width / this.blocks_num;
            n2 = this.blockIndexAt(f2) - this.blockIndexAt(f);
            n = this.blockIndexAt(f);
            while (n <= this.blockIndexAt(f2)) {
                Powerslide.this.pushMatrix();
                Block block = this.blocks[n];
                Powerslide.this.translate(block.startCoords()[0], block.startCoords()[1], block.startCoords()[2]);
                Powerslide.this.fill(255.0f, 255.0f, 255.0f, 1.0f);
                float f3 = (float)(n - this.blockIndexAt(f)) / (float)n2;
                float f4 = (float)(n + 1 - this.blockIndexAt(f)) / (float)n2;
                block.draw(f3, f4);
                if (Powerslide.this.state == Powerslide.this.PLAYING) {
                    if (Powerslide.this.players[0].at() == this.blocks[n]) {
                        Powerslide.this.pushMatrix();
                        Powerslide.this.players[0].setFill();
                        Powerslide.this.translate(0.0f, this.blocks[n].getWidth() + 180.0f, 0.0f);
                        Powerslide.this.rotateZ(Powerslide.radians((float)270.0f));
                        Powerslide.this.rotateX(Powerslide.radians((float)-45.0f));
                        Powerslide.this.textFont(Powerslide.this.font, 50.0f);
                        Powerslide.this.text(Powerslide.this.players[0].forceDirectionToString(), 0.0f, 0.0f, 0.0f);
                        Powerslide.this.popMatrix();
                    }
                    if (Powerslide.this.players[1].at() == this.blocks[n]) {
                        Powerslide.this.pushMatrix();
                        Powerslide.this.players[1].setFill();
                        Powerslide.this.translate(0.0f, -10.0f, 0.0f);
                        Powerslide.this.rotateZ(Powerslide.radians((float)270.0f));
                        Powerslide.this.rotateX(Powerslide.radians((float)-45.0f));
                        Powerslide.this.textFont(Powerslide.this.font, 50.0f);
                        Powerslide.this.text(Powerslide.this.players[1].forceDirectionToString(), 0.0f, 0.0f, 0.0f);
                        Powerslide.this.popMatrix();
                    }
                }
                if (this.blocks[n] == this.finishStarts()) {
                    Powerslide.this.pushMatrix();
                    Powerslide.this.fill(1.0f, 0.0f, 0.0f, 0.4f);
                    Powerslide.this.translate(80.0f, 0.0f, 0.0f);
                    Powerslide.this.rotateZ(Powerslide.radians((float)270.0f));
                    Powerslide.this.rotateX(Powerslide.radians((float)-45.0f));
                    Powerslide.this.textFont(Powerslide.this.font, 64.0f);
                    Powerslide.this.text("Finish", 0.0f, 0.0f, 0.0f);
                    Powerslide.this.popMatrix();
                }
                PVector pVector = this.blocks[n].directionScaled();
                Powerslide.this.translate(5.0f, pVector.y, pVector.z);
                Powerslide.this.popMatrix();
                ++n;
            }
        }

        public void drawCurve(float f, float f2) {
            float[] fArray = this.endCoords();
            float f3 = Powerslide.abs((float)(f2 / fArray[2]));
            float f4 = f / fArray[0];
            PVector pVector = new PVector(f4, f3);
            Block block = null;
            Ball ball = null;
            if (Powerslide.this.state == Powerslide.this.PLAYING) {
                Powerslide.this.drawing_area_coords();
                ball = Powerslide.this.firstBall();
                block = this.blockAt(ball.coords()[0]);
            }
            float f5 = 0.0f;
            float f6 = 0.0f;
            Block cfr_ignored_0 = this.blocks[0];
            float f7 = 0.0f;
            float f8 = 0.0f;
            Powerslide.this.pushMatrix();
            Powerslide.this.beginShape();
            Powerslide.this.noFill();
            Powerslide.this.smooth();
            int n = 1;
            while (n < this.blocks.length) {
                float[] fArray2 = this.blocks[n - 1].startCoords();
                float[] fArray3 = this.blocks[n].startCoords();
                fArray3[0] = fArray3[0] - fArray2[0];
                fArray3[2] = fArray3[2] - fArray2[2];
                PVector pVector2 = new PVector(fArray3[0], fArray3[2]);
                pVector2.x *= pVector.x;
                pVector2.y *= pVector.y;
                Powerslide.this.curveVertex(f7 += pVector2.x, -1.0f * (f8 += pVector2.y));
                if (Powerslide.this.state == Powerslide.this.PLAYING && this.blocks[n] == block) {
                    f5 = f7;
                    f6 = f8;
                }
                ++n;
            }
            Powerslide.this.endShape();
            if (Powerslide.this.state == Powerslide.this.PLAYING) {
                Powerslide.this.noStroke();
                ball.player().setFill();
                Powerslide.this.ellipseMode(3);
                Powerslide.this.ellipse(f5, -1.0f * f6, 15.0f, 15.0f);
            }
            Powerslide.this.popMatrix();
        }

        public void addForce(float f, float f2, float f3, float f4) {
            float f5 = f3 * f3 + f4 * f4 * this.aspectRatio2;
            if (f5 > 0.0f) {
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                } else if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                float f6 = 5.0f;
                float f7 = 30.0f;
                int n = this.fluidSolver.getIndexForNormalizedPosition(f, f2);
                Powerslide.this.colorMode(3, 360.0f, 1.0f, 1.0f);
                float f8 = ((f + f2) * 180.0f + (float)Powerslide.this.frameCount) % 360.0f;
                int n2 = Powerslide.this.color(f8, 1.0f, 1.0f);
                Powerslide.this.colorMode(1, 1.0f);
                int n3 = n;
                this.fluidSolver.rOld[n3] = this.fluidSolver.rOld[n3] + Powerslide.this.red(n2) * f6;
                int n4 = n;
                this.fluidSolver.gOld[n4] = this.fluidSolver.gOld[n4] + Powerslide.this.green(n2) * f6;
                int n5 = n;
                this.fluidSolver.bOld[n5] = this.fluidSolver.bOld[n5] + Powerslide.this.blue(n2) * f6;
                this.particleSystem.addParticles(f * (float)Powerslide.this.width, f2 * (float)Powerslide.this.height, 10, 1.0f - Powerslide.this.red(n2), 1.0f - Powerslide.this.green(n2), 1.0f - Powerslide.this.blue(n2));
                int n6 = n;
                this.fluidSolver.uOld[n6] = this.fluidSolver.uOld[n6] + f3 * f7;
                int n7 = n;
                this.fluidSolver.vOld[n7] = this.fluidSolver.vOld[n7] + f4 * f7;
            }
        }
    }

    class Particle {
        static final float MOMENTUM = 0.5f;
        static final float FLUID_FORCE = 0.6f;
        float x;
        float y;
        float vx;
        float vy;
        float radius;
        float alpha;
        float mass;
        float r;
        float g;
        float b;

        Particle() {
        }

        public void init(float f, float f2, float f3, float f4, float f5) {
            this.x = f;
            this.y = f2;
            this.vx = 0.0f;
            this.vy = 0.0f;
            this.radius = 5.0f;
            this.alpha = Powerslide.this.random(0.3f, 1.0f);
            this.mass = Powerslide.this.random(0.1f, 1.0f);
            this.r = f3;
            this.g = f4;
            this.b = f5;
        }

        public void update() {
            if (this.alpha == 0.0f) {
                return;
            }
            int n = Powerslide.this.board.fluidSolver().getIndexForNormalizedPosition(this.x * Powerslide.this.board.invWidth, this.y * Powerslide.this.board.invHeight);
            this.vx = Powerslide.this.board.fluidSolver().u[n] * (float)Powerslide.this.width * this.mass * 0.6f + this.vx * 0.5f;
            this.vy = Powerslide.this.board.fluidSolver().v[n] * (float)Powerslide.this.height * this.mass * 0.6f + this.vy * 0.5f;
            this.x += this.vx;
            this.y += this.vy;
            if (this.x < 0.0f) {
                this.x = 0.0f;
                this.vx *= -1.0f;
            } else if (this.x > (float)Powerslide.this.width) {
                this.x = Powerslide.this.width;
                this.vx *= -1.0f;
            }
            if (this.y < 0.0f) {
                this.y = 0.0f;
                this.vy *= -1.0f;
            } else if (this.y > (float)Powerslide.this.height) {
                this.y = Powerslide.this.height;
                this.vy *= -1.0f;
            }
            if (this.vx * this.vx + this.vy * this.vy < 1.0f) {
                this.vx = Powerslide.this.random(-1.0f, 1.0f);
                this.vy = Powerslide.this.random(-1.0f, 1.0f);
            }
            this.alpha *= 0.95f;
            if (this.alpha < 0.01f) {
                this.alpha = 0.0f;
            }
        }

        public void draw() {
            float f = this.x / (float)Powerslide.this.width;
            float f2 = this.y / (float)Powerslide.this.height;
            float[] fArray = Powerslide.this.drawing_area_coords();
            if (fArray == null || fArray.length != 2) {
                return;
            }
            f = fArray[0] + (fArray[1] - fArray[0]) * f;
            float f3 = 0.9f;
            Powerslide.this.pushMatrix();
            Powerslide.this.noStroke();
            Powerslide.this.smooth();
            Powerslide.this.fill(this.r, this.g, this.b, this.alpha);
            Powerslide.this.beginShape();
            float f4 = f - f3 / Powerslide.this.board.boardlen();
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            float[] fArray2 = Powerslide.this.board.getCoords(f4, f2);
            Powerslide.this.vertex(fArray2[0], fArray2[1] + f3, fArray2[2] + 0.1f);
            Powerslide.this.vertex(fArray2[0], fArray2[1] - f3, fArray2[2] + 0.1f);
            f4 = f + f3 / Powerslide.this.board.boardlen();
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            fArray2 = Powerslide.this.board.getCoords(f4, f2);
            Powerslide.this.vertex(fArray2[0], fArray2[1] - f3, fArray2[2] + 0.1f);
            Powerslide.this.vertex(fArray2[0], fArray2[1] + f3, fArray2[2] + 0.1f);
            Powerslide.this.endShape();
            Powerslide.this.popMatrix();
        }
    }

    class ParticleSystem {
        FloatBuffer posArray;
        FloatBuffer colArray;
        static final int maxParticles = 5000;
        int curIndex;
        Particle[] particles = new Particle[5000];

        ParticleSystem() {
            int n = 0;
            while (n < 5000) {
                this.particles[n] = new Particle();
                ++n;
            }
            this.curIndex = 0;
            this.posArray = BufferUtil.newFloatBuffer((int)20000);
            this.colArray = BufferUtil.newFloatBuffer((int)30000);
        }

        public void updateAndDraw() {
            int n = 0;
            while (n < 5000) {
                if (this.particles[n].alpha > 0.0f) {
                    this.particles[n].update();
                    this.particles[n].draw();
                }
                ++n;
            }
        }

        public void addParticles(float f, float f2, int n, float f3, float f4, float f5) {
            int n2 = 0;
            while (n2 < n) {
                float f6 = f3;
                float f7 = f4;
                float f8 = f5;
                if (n2 % 2 == 0) {
                    f6 = 1.0f;
                    f7 = 1.0f;
                    f8 = 1.0f;
                }
                this.addParticle(f + Powerslide.this.random(-30.0f, 30.0f), f2 + Powerslide.this.random(-30.0f, 30.0f), f6, f7, f8);
                ++n2;
            }
        }

        public void addParticle(float f, float f2, float f3, float f4, float f5) {
            this.particles[this.curIndex].init(f, f2, f3, f4, f5);
            ++this.curIndex;
            if (this.curIndex >= 5000) {
                this.curIndex = 0;
            }
        }
    }

    class Player {
        public static final int MAX_PLAYERS = 2;
        private static final float FRICTION = 0.05f;
        private static final float MAX_SPEED = 50.0f;
        private int ID;
        private float x;
        private float y;
        private PVector acceleration;
        private PVector[] accelerations;
        private ArrayList force_points;
        private int max_force_points = 3;
        private int points;
        private int force_direction;
        private float size = 10.0f;
        private static final int LEFT = 0;
        private static final int UP = 1;
        private static final int RIGHT = 2;
        private static final int DOWN = 3;

        public Player(int n, float f, float f2) throws Exception {
            if (n < 0 || n > 2) {
                throw new Exception("Player ID not possible");
            }
            this.ID = n;
            this.reset(f, f2);
            this.points = 0;
        }

        public int ID() {
            return this.ID;
        }

        public int numOfBalls() {
            int n = 0;
            int n2 = 0;
            while (n2 < Powerslide.this.balls.size()) {
                Ball ball = (Ball)Powerslide.this.balls.get(n2);
                if (ball.player() == this) {
                    ++n;
                }
                ++n2;
            }
            return n;
        }

        public void reset(float f, float f2) {
            if (f < 0.0f) {
                f = 0.0f;
            } else if (f > 1.0f) {
                f = 1.0f;
            }
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.x = f;
            this.y = f2;
            this.acceleration = new PVector(0.0f, 0.0f, 0.0f);
            this.accelerations = new PVector[4];
            this.force_points = new ArrayList();
            this.force_direction = 1;
            int n = 0;
            while (n < this.accelerations.length) {
                this.accelerations[n] = new PVector(0.0f, 0.0f, 0.0f);
                ++n;
            }
        }

        public void addPoints(int n) {
            this.points += n;
        }

        public int points() {
            return this.points;
        }

        public Block at() {
            float[] fArray = Powerslide.this.drawing_area_coords();
            if (fArray == null) {
                return Powerslide.this.board.blockAt(0);
            }
            float f = fArray[0] + (fArray[1] - fArray[0]) * this.x;
            return Powerslide.this.board.blockAt(f);
        }

        private int getOppositeDirection(int n) {
            if (n == 0) {
                return 2;
            }
            if (n == 2) {
                return 0;
            }
            if (n == 1) {
                return 3;
            }
            return 1;
        }

        public String forceDirectionToString() {
            if (this.force_direction == -1) {
                return "Pulling";
            }
            return "Pushing";
        }

        private int direction(PVector pVector) {
            if (pVector.x < 0.0f) {
                return 0;
            }
            if (pVector.x > 0.0f) {
                return 2;
            }
            if (pVector.y > 0.0f) {
                return 1;
            }
            return 3;
        }

        public void removeAcceleration(PVector pVector) {
            int n = this.direction(pVector);
            this.accelerations[n] = new PVector(0.0f, 0.0f, 0.0f);
        }

        public void addAcceleration(PVector pVector) {
            int n = this.direction(pVector);
            Powerslide.this.board.blockAt(this.x);
            this.accelerations[n] = pVector;
            this.accelerations[this.getOppositeDirection((int)n)] = new PVector(0.0f, 0.0f, 0.0f);
        }

        public void move() {
            PVector pVector;
            Block block = Powerslide.this.board.blockAt(this.x);
            PVector pVector2 = new PVector(0.0f, 0.0f, 0.0f);
            int n = 0;
            while (n < this.accelerations.length) {
                pVector = this.accelerations[n];
                pVector2.add(pVector);
                ++n;
            }
            pVector2.mult(1.2f);
            this.acceleration.add(pVector2);
            PVector pVector3 = this.acceleration.get();
            pVector3.normalize();
            pVector3.mult(-1.0f);
            if (Powerslide.abs((float)this.acceleration.mag()) > 50.0f) {
                this.acceleration.normalize();
                this.acceleration.mult(50.0f);
            }
            pVector3.mult(0.05f * Powerslide.abs((float)this.acceleration.mag()));
            this.acceleration.add(pVector3);
            pVector = this.acceleration.get();
            pVector.mult(3.0f);
            this.x += pVector.x / 2000.0f;
            this.y += pVector.y / block.getWidth();
            this.checkBoundaries();
            Powerslide.this.board.addForce(this.x, this.y, -0.001f * this.acceleration.x, -0.001f * this.acceleration.y);
        }

        private void checkBoundaries() {
            float f = this.size / 2000.0f;
            if (this.x < f) {
                this.x = f;
                this.acceleration.x = 0.0f;
            } else if (this.x > 1.0f - f) {
                this.x = 1.0f - f;
                this.acceleration.x = 0.0f;
            }
            if (this.y < f * 2.0f) {
                this.y = 2.0f * f;
                this.acceleration.y = 0.0f;
            } else if (this.y > 1.0f - 2.0f * f) {
                this.y = 1.0f - 2.0f * f;
                this.acceleration.y = 0.0f;
            }
        }

        public void changeForceDirection() {
            this.force_direction *= -1;
        }

        public void setFill() {
            if (this.ID() == 1) {
                Powerslide.this.fill(0.4f, 0.6f, 0.3f, 1.0f);
            } else {
                Powerslide.this.fill(0.8f, 0.3f, 0.3f, 1.0f);
            }
        }

        public void addForcePoint() {
            float[] fArray = Powerslide.this.drawing_area_coords();
            float f = fArray[0] + (fArray[1] - fArray[0]) * this.x;
            ForcePoint forcePoint = new ForcePoint(f, this.y, this.force_direction, this);
            if (this.force_points.size() >= this.max_force_points) {
                this.force_points.remove(0);
            }
            this.force_points.add(forcePoint);
        }

        public void removeForcePoint(ForcePoint forcePoint) {
            int n = 0;
            while (n < this.force_points.size()) {
                if (forcePoint == this.force_points.get(n)) {
                    this.force_points.remove(n);
                    return;
                }
                ++n;
            }
        }

        public ArrayList forcePoints() {
            return this.force_points;
        }

        public void draw(float f, float f2) {
            float f3 = f + (f2 - f) * this.x;
            Powerslide.this.pushMatrix();
            Powerslide.this.noLights();
            Powerslide.this.lights();
            Powerslide.this.stroke(0.0f, 0.0f, 0.0f, 1.0f);
            this.setFill();
            Powerslide.this.beginShape();
            float f4 = f3 - this.size / Powerslide.this.board.boardlen();
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            float[] fArray = Powerslide.this.board.getCoords(f4, this.y);
            Powerslide.this.vertex(fArray[0], fArray[1] + this.size, fArray[2] + 1.0f);
            Powerslide.this.vertex(fArray[0], fArray[1] - this.size, fArray[2] + 1.0f);
            f4 = f3 + this.size / Powerslide.this.board.boardlen();
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            fArray = Powerslide.this.board.getCoords(f4, this.y);
            Powerslide.this.vertex(fArray[0], fArray[1] - this.size, fArray[2] + 1.0f);
            Powerslide.this.vertex(fArray[0], fArray[1] + this.size, fArray[2] + 1.0f);
            Powerslide.this.endShape();
            Powerslide.this.popMatrix();
        }
    }
}

