
float4x4 g_mWorldViewProjection;    

float g_luminosity;
float g_whiteness;

float g_windowWidth;
float g_windowHeight;

float4 g_color;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs_float_to_onezero( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = (v.vTexcoord)*correcter+float2(1.0/g_windowWidth, 1.0/g_windowHeight); 
//  o.vTexcoord = (1.0-float2(-o.vPosition.x-1.0/g_windowWidth, o.vPosition.y-1.0/g_windowHeight))*0.50*correcter;
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

sampler sm =
sampler_state {
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = CLAMP;
  AddressV = CLAMP;
};

PS_OUT ps_float_to_onezero( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 colorIn = tex2D(sm, In.vTexcoord);
 // float4 result = (1.0-1.0/(hdr_gamma*colorIn*colorIn+1.0));
 
 colorIn *= g_luminosity;
 float lwhite2 = g_whiteness; 
 float4 result = colorIn*(1.0+colorIn/lwhite2)/(1.0+colorIn);
 // float4 result = log(colorIn*hdr_ca)*hdr_cb;
 // float4 result = colorIn;

  result.a = colorIn.a;
 // result.r = 1.0;
  
  o.rt0 = result;
  return o;
}




technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero( );
        PixelShader  = compile ps_3_0 ps_float_to_onezero( );
    }
}

