
float4x4 g_mWorldViewProjection;    

float g_luminosity;
float g_whiteness;

float g_windowWidth;
float g_windowHeight;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs_aa( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = (v.vTexcoord)*correcter+float2(1.0/g_windowWidth, 1.0/g_windowHeight); 
//  o.vTexcoord = (1.0-float2(-o.vPosition.x-1.0/g_windowWidth, o.vPosition.y-1.0/g_windowHeight))*0.50*correcter;
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

texture g_tDepth;
texture g_tNormal;
texture g_tDiffuse;

sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;  
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;  
  AddressU = BORDER;
  AddressV = BORDER;
};

PS_OUT ps_aa( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord);
 // float4 result = (1.0-1.0/(hdr_gamma*colorIn*colorIn+1.0));
 
  float4 od = tex2D(smDepth, In.vTexcoord);
 
  float4 result = 0;
  
  float at = 0.0;
  
 // result = colorIn*at;
 // result.a = 1.0;
  
  
//  float ker[5] = { 0.2550, 0.50, 1.0, 0.50, 0.250 };
  
  float alpha = 0.0;
  float alphaSum = 0.0;

/*
  float ker[3] = { 0.50, 1.0, 0.50 };

  for (int y=0; y<3; y++) {
    for (int x=0; x<3; x++) {
    
      float2 po = In.vTexcoord+0.50*float2((x-3.0)/g_windowWidth, (y-3.0)/g_windowHeight);
      float2 po2 = In.vTexcoord+0.50*float2((x-1.0)/g_windowWidth, (y-1.0)/g_windowHeight);
      
      float4 sd = tex2D(smDepth, po);
      float4 dd = tex2D(smDiffuse, po2);
      float am = (sd.r-od.r);
      am = am*am;
      am -= 0.00001;
      if (am > 0.0) {
	    am = clamp(((am))*1.0, 0.0, 1.0);
	      
	    am = ker[x]*ker[y];
	    result += dd*(am);
	    at += am;
	    
	    alpha += 1.0;
	  }
	  alphaSum += 1.0;
    }
  }
  
  */
  
  float2 samples[4] = {
     float2(-1.0, -0.5),
     float2(-0.5, 1.0),
     float2(1.0, 0.5),
     float2(0.5, -1.0)
  };

  for (int i=0; i<4; i++) {
    float2 po = In.vTexcoord+1.0*(samples[i]*float2(1.0/g_windowWidth, 1.0/g_windowHeight))-float2((2.0)/g_windowWidth, (2.0)/g_windowHeight);
    float2 po2 = In.vTexcoord+1.0*samples[i]*float2(1.0/g_windowWidth, 1.0/g_windowHeight);
  
    float4 sd = tex2D(smDepth, po);
    float4 dd = tex2D(smDiffuse, po2);
    float am = (sd.r-od.r);
    am = am*am;
    am -= 0.00001;
    if (am > 0.0) {
      am = clamp(((am))*1.0, 0.0, 1.0);
      
      am = 1.0;
      result += dd*(am);
      at += am;
    
      alpha += 1.0;
    }
    alphaSum += 1.0;
  }

  
  result = clamp(result/at, 0.0, 1000.0);
  
  result.a = alpha/alphaSum;

  // result.r = 1.0;
 //  result.a = 1.0;
  
  o.rt0 = result;
  return o;
}



PS_OUT ps_aa_plain( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord);
  o.rt0 = colorIn;
  return o;
}


technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_aa( );
        PixelShader  = compile ps_3_0 ps_aa( );
    }
}

technique RenderPlain {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_aa( );
        PixelShader  = compile ps_3_0 ps_aa_plain( );
    }
}



