;Ballman
;by Shiru, 05'2009 for ArtField'2009

; SjASMPlus

    device zxspectrum128

STACK_A     equ #2d28
FP_TO_A     equ #2dd5
STACK_BC    equ #2d2b
FP_TO_BC    equ #2da2
PLOT_SUB    equ #22e5
DRAW_ARC    equ #2394
ATTR_T      equ #5c8f
CL_SC_ALL   equ #0dfe

OP_ADD_B    equ #80
OP_SUB_B    equ #90

    org #6200
 
begin

    di
    ld sp,#6200
 
;   

cls
    xor a
    out (#fe),a
    ld h,#5b
    dec hl
    ld (hl),a
    or (hl)
    jr z,$-3
 
; 

bg_gradient
    ld hl,0
.loop0
    ld bc,15*256+32
    ld a,h
    sub b
    cp 160
    jr nc,.loop1
    ld c,l
.loop1
    push hl
    ld a,h
    cp b
    jr z,.loop2
    cp 175
    jr z,.loop2
    srl a
    add a,l
    add a,208
    cp 128
    jr c,$+3
    cpl
    srl a
    sub c
    jr nc,$+3
.loop2
    xor a
    call getPixAddr
    ld (hl),a
    pop hl
    inc l
    jr nz,.loop1
    dec h
    jr nz,.loop0

; 

draw_title
    ;ld a,6
    ;ld (.xoff),a
.loop0
    ld hl,titleData
.loop1
    xor a
    ld (ATTR_T),a
    ld a,(hl)
    inc hl
    cp 255
    jr z,.loop4
    ld b,(hl)
    inc hl
    push hl
    cp 128
    jr c,.loop2
    cp -25
    jr z,.loop2
    cpl
.xoff=$+1
    sub 6
    ld c,a
    call PLOT_SUB
    jr .loop3
.loop2
    push bc
    call .atobc
    pop af
    push af
    call .atobc
    pop af
    cp 11
    ld a,3
    jr z,$+3
    xor a
    call STACK_A
    call DRAW_ARC
.loop3
    pop hl
    jr .loop1
.atobc
    cp 128
    push af
    jr c,$+4
    neg
    call STACK_A
    pop af
    ret c
    rst #28
    db #1b,#38
    ret
.loop4
    ld hl,.xoff
    dec (hl)
    jr nz,.loop0

;  r*r

gen_rr_table
    ;ld a,16
    ;out (#fd),a
    ld hl,rrTable
.loop0
    ld c,l
    call mulRR
    ld (hl),c
    inc h
    ld (hl),b
    dec h
    inc l
    jr nz,.loop0

;

bg_circles
    ld a,110
.loop0
    ld hl,96*256+160
    push af
    ld b,a
    ld a,4
    call drawCircle
    pop af
    sub 5
    cp 70
    jr nc,.loop0
 
;  

ball_model
    ld hl,ballModel
.loop0
    ld e,(hl)
    ld a,e
    or a
    jr z,.loop5
    inc hl
    ld d,(hl)
    inc hl
    ld b,(hl)
    inc hl
    push hl
    ex de,hl

    push hl
    xor a
    ld (drawCircle.ellipse),a
    ld h,162
    ld a,-6
    call drawCircle
    pop hl
    ld a,4
    ld (drawCircle.ellipse),a

    ld de,ballData
.loop1
    ld a,(de)
    inc de
    or a
    jr z,.loop4
    push bc
    push hl
    push bc
    ld (.loop2),a
    ld (.loop3),a
    ld a,(de)
    inc de
    call mul8
    ld a,h
.loop2
    nop
    ld h,a
    ld a,l
.loop3
    nop
    ld l,a
    pop bc
    ld a,(de)
    inc de
    call mul8
    ld a,(de)
    inc de
    call drawCircle
    pop hl
    pop bc
    jr .loop1
.loop4

    pop hl
    jr .loop0
.loop5

;  

bg_title
    ld hl,15
.loop0
    push hl
    call getPixAddr
    ld bc,48*256+32
    ld (hl),e
    inc l
.loop1
    ld a,(hl)
    add a,c
    ld (hl),a
    inc l
    djnz .loop1
    ld (hl),b
    pop hl
    inc h
    jr nz,.loop0

;    

copy_title
    ld de,#4002
    ld hl,#0810
.loop0
    push hl
    push de
.loop1
    ld b,8
    ld a,(de)
.loop2
    rla
    jr nc,.loop3
    push af
    push hl
    push hl
    call getPixAddr
    ld (hl),0
    pop hl
    inc h
    inc h
    inc l
    inc l
    call getPixAddr
    ld (hl),56
    pop hl
    pop af
.loop3
    inc l
    djnz .loop2
    inc e
    bit 3,e
    jr z,.loop1
    pop hl
    call downHL
    ex de,hl
    pop hl
    inc h
    jr nz,.loop0

;   

render_screen

    ;ld hl,0
    ld l,h
    ld de,#8000+257
    call lineCopy

    ld h,#40
    ld a,l
.loop0
    push af
    push hl
    push hl
    ld hl,#8000+257
    ld de,#8000
    push hl
    push de
    pop ix
    pop iy
    ld bc,257
    ldir
    ld h,a
    ld l,c
    call lineCopy
    pop hl

.loop1
    push hl
    ld de,128
.loop2
    ld bc,0
    bit 7,(ix)
    jr z,.loop3
    ld a,d
    or e
    ld d,a
    ld c,63
.loop3
    ld a,(ix)
    sub c
    ld c,a
    ld h,b
    ld l,c
    call div16
    ld a,(iy+1)
    add a,l
    ld (iy+1),a
    ld h,b
    ld l,c
    add hl,hl
    add hl,bc
    call div16
    ld a,(iy-1)
    add a,l
    ld (iy-1),a
    ld h,b
    ld l,c
    add hl,hl
    add hl,hl
    add hl,bc
    push hl
    call div16
    ld a,(iy)
    add a,l
    ld (iy),a
    ld h,b
    ld l,c
    pop hl
    add hl,bc
    add hl,bc
    call div16
    ld a,(ix+1)
    add a,l
    ld (ix+1),a
    srl e
    inc ix
    inc iy
    jr nz,.loop2
    pop hl
    ld (hl),d
    inc l
    ld a,l
    and #1f
    jr nz,.loop1
    pop hl
 
    call downHL

    pop af
    inc a
    cp 192
    jp nz,.loop0

; 

set_color
    ld hl,colorData
.loop0
    ld a,(hl)
    inc hl
    or a
    jr z,$
    ld e,(hl)
    inc hl
    ld d,(hl)
    inc hl
    ld c,(hl)
    inc hl
    ld b,(hl)
    inc hl
    ex de,hl
.loop1
    push bc
    push hl
    ld b,c
.loop2
    ld (hl),a
    inc hl
    djnz .loop2
    pop hl
    ld c,32
    add hl,bc
    pop bc
    djnz .loop1
    ex de,hl
    jr .loop0

 

;DOWN_HL+ by Spencer Winsent

downHL
    inc h
    ld a,h
    and #07
    ret nz
    ld a,l
    sub #e0
    ld l,a
    sbc a,a
    and #f8
    add a,h
    ld h,a
    ret

;      
;h=Y,l=X

getPixAddr
    exa
    ld a,h
    rlca
    rlca
    and 3
    cp 2
    jr c,$+3
    inc a
    or 16
    out (#fd),a
    ld a,h
    or #c0
    ld h,a
    exa
    ret

;  

lineCopy
    call getPixAddr
    ld bc,256
    ldir
    ret

; 
;h=Y,l=X,b=R,a=

drawCircle
    exa
    ld a,b
    or a
    ret z
    exa
    push bc
    push de
    cp 128
    jr c,.draw0
    neg
    ld (.col1),a
    ld a,10
    jr .draw1
.draw0
    ld (.col0),a
    xor a
.draw1
    ld (.setc),a
    push bc
    ;ld a,16
    ;out (#fd),a
    ld c,b
    call mulRR
    ld (.k),bc
    pop bc
    ld c,b
    ld d,0
.loop0
    push bc
    push hl
    ld b,c
    ld e,0
.loop1
    push bc
    push de
    push hl
    ex de,hl
    ld a,h
    ld h,rrTable/256
    ld e,(hl)
    inc h
    ld d,(hl)
    ld l,a
    ld h,rrTable/256
    ld c,(hl)
    inc h
    ld b,(hl)
    ex de,hl
    add hl,bc
.k=$+1
    ld bc,0
    sbc hl,bc
    pop hl
    pop de
    jr nc,.loop2
    push de
.ellipse=$+1
    jr $+6
    srl d
    srl d
    push hl
    ld a,h
    add a,d
    ld h,a
    ld a,l
    add a,e
    call .setp
    pop hl
    push hl
    ld a,h
    dec a
    sub d
    ld h,a
    ld a,l
    add a,e
    call .setp
    pop hl
    push hl
    ld a,h
    add a,d
    ld h,a
    ld a,l
    dec a
    sub e
    call .setp
    pop hl
    push hl
    ld a,h
    dec a
    sub d
    ld h,a
    ld a,l
    dec a
    sub e
    call .setp
    pop hl
    pop de
.loop2
    pop bc
    inc e
    djnz .loop1
    pop hl
    pop bc
    inc d
    djnz .loop0
    pop de
    pop bc
    ret

.setp
    ld l,a
    call getPixAddr
    ld a,(hl)
.setc=$+1
    jr $+2
.col0=$+1
    add a,0
    cp 64
    jr c,$+4
    ld a,64
    ld (hl),a
    ret

.setp1
.col1=$+1
    sub 0
    jr nc,$+3
    xor a
    ld (hl),a
    ret

; hl  16

div16
    push bc
    ld b,4
.loop0
    srl h
    rr l
    djnz .loop0
    pop bc
    ret

; bc  bc

mulRR
    push hl
    ld b,0
    push bc
    call STACK_BC
    pop bc
    call STACK_BC
    rst #28
    db #04 ;multiply
    db #38 ;end calc
    call FP_TO_BC
    pop hl
    ret

; a  b

mul8
    push hl
    push de
    ld h,0
    ld l,h
    ld d,h
    ld e,a
.loop0
    add hl,de
    djnz .loop0
    or a
    jr z,$+3
    ld b,h
    pop de
    pop hl
    ret

 
titleData
    db 27^255,175
    db 0,-22
    db 25,0
    db 0,11
    db 0,11
    db -25,0
    db 27^255,175-11
    db 25,0
    db 27^255,150-22
    db 16,22
    db 16,-22
    db 30^255,150-18
    db 26,0
    db 27^255,125
    db 0,-22
    db 32,0
    db 0,4
    db 27^255,100
    db 0,-22
    db 32,0
    db 0,4
    db 27^255,75-22
    db 0,22
    db 16,-22
    db 16,22
    db 0,-22
    db 27^255,50-22
    db 16,22
    db 16,-22
    db 30^255,50-18
    db 26,0
    db 27^255,25-22
    db 0,22
    db 32,-22
    db 0,22
    db 255
 
ballData
    db OP_ADD_B,0,255,-64
    db OP_ADD_B,48,180,8
    db OP_SUB_B,64,160,16
    db OP_SUB_B,80,120,16
    db OP_SUB_B,96,64,16
    db OP_SUB_B,96,32,16
    db 0

ballModel
    db 92,94,3
    db 88,88,3
    db 87,80,4
    db 100,73,4
    db 99,85,7
    db 109,83,6
    db 121,79,8
    db 145,103,10
    db 128,131,7
    db 129,70,7
    db 171,104,10
    db 135,59,10
    db 159,90,17
    db 146,44,5
    db 159,68,20
    db 185,60,10
    db 190,73,7
    db 195,83,8
    db 205,77,6
    db 212,70,7
    db 209,58,4
    db 221,61,4
    db 225,70,4
    db 173,44,5
    db 221,79,3
    db 127,119,9
    db 159,39,14
    db 129,154,8
    db 113,159,4
    db 122,160,5
    db 134,160,6
    db 135,110,7
    db 129,142,7
    db 180,111,7
    db 183,153,8
    db 176,160,6
    db 189,160,5
    db 198,158,4
    db 184,141,7
    db 189,120,9
    db 187,131,7
    db 159,43,5
    db 152,37,3
    db 166,37,3
    db 0
 
colorData
    db 4
    dw #5800
    db 9,24
    db 4+64
    dw #5809
    db 23,24
    db 4
    dw #5ac8
    db 24,1
    db 7+64
    dw #5840
    db 32,20
    db 4+48+64
    dw #5802
    db 6,24
    db 7
    dw #5848
    db 1,20
    db 0


end

    align 256
rrTable
    ds 256*2

    display /d,end-begin
    savesna "ballman.sna",begin
    savebin "ballman.bin",begin,end-begin