#include "wiimote.h"
#include "timer.h"
#include "tools.h"
#include "star.h"
#include "main.h"

#define MAX_WIIMOTES 1

wiimote** wiimotes;
struct wiimote_t *wiimote1;
int connected_wiimotes = 0;
int last_wiimote_ticks[MAX_WIIMOTES];

float wiimote_amp_z;
float wiimote_z;
float wiimote_x;
int wiimote_ticks_z = 0;
int wiimote_b;
int wiimote_a;

void init_wiimote()
{
  int found;
  int i;
  
  wiimotes = wiiuse_init(MAX_WIIMOTES);
  
  if (1)
  {
  printf("press 1+2 on the wiimote...\n");
  found = wiiuse_find(wiimotes, MAX_WIIMOTES, 10); 
  printf("%d wiimote(s) found\n", found);
  
  connected_wiimotes = wiiuse_connect(wiimotes, MAX_WIIMOTES);
  if (connected_wiimotes)
    printf("Connected to %i wiimotes (of %i found).\n", connected_wiimotes, found);
  else
    fatal_error("Failed to connect to any wiimote.\n");
  }
  
  for (i=0; i<MAX_WIIMOTES; i++)
  {
    wiiuse_motion_sensing(wiimotes[i], 1);
    last_wiimote_ticks[i] = start_ticks;
  }
  wiimote1 = wiimotes[0];
  wiiuse_toggle_rumble(wiimote1);
  SDL_Delay(500);
  wiiuse_toggle_rumble(wiimote1);
}

void shutdown_wiimote()
{
  wiiuse_cleanup(wiimotes, MAX_WIIMOTES);
}

float prev_x = 0.0;
float prev_x1 = 0.0;
float prev_x2 = 0.0;
float prev_x3 = 0.0;

int last_ticks_z = 0;
int current_ticks_z = 0;


void wiimote_step()
{
  int i;
  struct wiimote_t *wiimote;
  float x, y, z;
  float dt;
  float dx, x1, x2, x3;
  int received_event[MAX_WIIMOTES];
  
  for (i = 0; i < MAX_WIIMOTES; ++i)
    received_event[i] = 0;
  
  //printf("%d %d", current_ticks, frame_ticks);
  while (wiiuse_poll(wiimotes, MAX_WIIMOTES))
  {
    //printf(" event !");
    for (i = 0; i < MAX_WIIMOTES; ++i)
    {
      dt = current_ticks - last_wiimote_ticks[i];
    
      wiimote = wiimotes[i];
      
      switch (wiimote->event)
      {
        case WIIUSE_EVENT:
          received_event[i] = 1;
          
          x = wiimote->gforce.z;
          y = wiimote->gforce.y;
          z = wiimote->gforce.x;
          
          wiimote_b = IS_PRESSED(wiimote, WIIMOTE_BUTTON_B);
          wiimote_a = IS_PRESSED(wiimote, WIIMOTE_BUTTON_A);
          
          wiimote_z = wiimote->gforce.z;
          wiimote_x = wiimote->gforce.x;
          
          dx = x - prev_x;
          x1 = dx / dt;
          x2 = (x1 - prev_x1) / dt;
          x3 = (x2 - prev_x2) / dt;
          
          if (x1 <= 0 && prev_x1 >= 0)
          {
            //printf("%f\n", x2);
            //if (prev_x > 0.1 && x2 < -0.008)
            //if (x2 < -0.005)
            if (prev_x > 0.1 && x2 < -0.0002)
            {
              wiimote_amp_z = prev_x;
              current_ticks_z += 1;
            }
          }
          //if (prev_x3 < 0.0 && x3 > 0.0 && x2 * 500.0 < -0.5)
          //  x_value = -x2 / 10000.0;
          //else
            //x_value = 0.0;
          
          prev_x = x;
          prev_x1 = x1;
          prev_x2 = x2;
          prev_x3 = x3;
          
          on_wiimote_event();
          
          //last_x = x;
          //last_y = x1 * 10.0;
          //last_z = x2 * 100.0;
          
          //printf("%f %f %f\n", last_x, last_y, last_z);
          break;
          
        default:
          break;
      }
    }
  } 
  for (i = 0; i < MAX_WIIMOTES; ++i)
    if (received_event[i])
      last_wiimote_ticks[i] = current_ticks;

  wiimote_ticks_z = current_ticks_z - last_ticks_z;
  last_ticks_z = current_ticks_z;
  
  //printf("\n");
}
