#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include "main.h"

void fatal_error(const char *format, ...)
{
  char        buf[1024];
  va_list     valist;
  int         len;

  va_start(valist, format);
  len = vsnprintf(buf, sizeof(buf), format, valist);
  va_end(valist);

  if ((len <= -1) || (len >= sizeof(buf)))
  {
      len = sizeof(buf) - 1;
      buf[len] = 0;
      buf[len - 1] = buf[len - 2] = buf[len - 3] = '.';
  }
  fprintf(stderr, "Fatal error: ");
  fprintf(stderr, buf);
  fprintf(stderr, "\n");
  error_code = 1;
  shutdown_and_exit();
}

