/*
 * Decompiled with CFR 0.152.
 */
package jhs.uu.washer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import jhs.uu.washer.Clothing;

public class WasherPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final int[] defClothCoords = new int[]{480, 80, 40, 20, 450, 150, 100, 100, 470, 250, 60, 100, 470, 350, 20, 20, 530, 350, 20, 20};
    private static final long serialVersionUID = -8185287977737432758L;
    private static ArrayList<Clothing> clothes;
    private double radius = 0.0;
    private BufferedImage bi;
    private float[] scales = new float[]{1.0f, 1.0f, 1.0f, 0.5f};
    private float[] offsets = new float[4];
    private RescaleOp rop;
    private ArrayList<Image> items = new ArrayList();
    private int w;
    private int h;
    private int increment = 0;
    private boolean isWashing = false;
    private int mx;
    private int my;
    private int mxo;
    private int myo;
    private int mxl;
    private int myl;
    private boolean moving;
    private boolean clicked;
    Image dirt;

    public WasherPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        try {
            this.dirt = ImageIO.read(new File("dirt.gif"));
            clothes = new ArrayList();
            BufferedImage img = ImageIO.read(new File("washer.jpg"));
            this.w = img.getWidth(null);
            this.h = img.getHeight(null);
            this.radius = (double)this.w * 0.25;
            this.bi = new BufferedImage(this.w, this.h, 2);
            Graphics g = this.bi.getGraphics();
            g.drawImage(img, 0, 0, null);
        }
        catch (IOException e) {
            System.out.println("Image could not be read");
            System.exit(1);
        }
        this.setOpacity(0.5f);
    }

    public void loadDefaultClothes(String[] files) {
        if (files.length != 5) {
            System.err.println("Clothes error");
        }
        int i = 0;
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            try {
                System.out.println(file);
                Clothing c = new Clothing(ImageIO.read(new File(file)));
                c.x = defClothCoords[i++];
                c.y = defClothCoords[i++];
                c.w = defClothCoords[i++];
                c.h = defClothCoords[i++];
                clothes.add(c);
            }
            catch (IOException e) {
                System.err.println("Error loading clothing:  " + file);
            }
            ++n2;
        }
    }

    private void addItem(Image item) {
        Image toAdd = item.getScaledInstance((int)(this.radius * 0.2), (int)(this.radius * 0.2), 0);
        this.items.add(toAdd);
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    public void setOpacity(float opacity) {
        this.scales[3] = opacity;
        this.rop = new RescaleOp(this.scales, this.offsets, null);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(Color.black);
        g2d.drawImage(this.bi, this.rop, 0, 0);
        Image[] itemsArray = new Image[1];
        itemsArray = this.items.toArray(itemsArray);
        double[][] coordinates = new double[itemsArray.length][2];
        int n = coordinates.length;
        int i = 0;
        while (i < n) {
            coordinates[i][0] = (double)(this.w / 2) + Math.sin((double)i / (double)n * 360.0 + (double)this.increment) * this.radius;
            coordinates[i][1] = (double)(this.h / 2) + Math.cos((double)i / (double)n * 360.0 + (double)this.increment) * this.radius;
            g2d.drawImage(itemsArray[i], (int)coordinates[i][0], (int)coordinates[i][1], null);
            ++i;
        }
        Line2D.Double l = new Line2D.Double(480.0, 350.0, 500.0, 250.0);
        g2d.draw(l);
        l = new Line2D.Double(500.0, 250.0, 520.0, 350.0);
        g2d.draw(l);
        l = new Line2D.Double(500.0, 250.0, 500.0, 150.0);
        g2d.draw(l);
        l = new Line2D.Double(500.0, 150.0, 530.0, 160.0);
        g2d.draw(l);
        l = new Line2D.Double(530.0, 160.0, 550.0, 180.0);
        g2d.draw(l);
        l = new Line2D.Double(500.0, 150.0, 470.0, 160.0);
        g2d.draw(l);
        l = new Line2D.Double(470.0, 160.0, 450.0, 180.0);
        g2d.draw(l);
        l = new Line2D.Double(500.0, 150.0, 500.0, 140.0);
        g2d.draw(l);
        Ellipse2D.Double h = new Ellipse2D.Double(480.0, 80.0, 40.0, 60.0);
        g2d.draw(h);
        for (Clothing c : clothes) {
            System.out.println("c");
            if (this.clicked) {
                this.clicked = false;
                if (this.isPointInside(this.mx, this.my, c.x, c.y, c.x + c.w, c.y + c.h)) {
                    c.moving = true;
                    this.moving = true;
                } else {
                    this.clicked = true;
                }
            }
            if (c.moving) {
                System.out.println("Dragging a clothing item");
                c.x = this.mx;
                c.y = this.my;
            }
            if (!c.visible) continue;
            g2d.drawImage(c.img, c.x, c.y, c.w, c.h, null);
        }
    }

    private boolean isPointInside(int x, int y, int x1, int y1, int x2, int y2) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public void cycleObjects() {
        ++this.increment;
        if (this.increment > 360) {
            this.increment -= 360;
        }
    }

    public boolean isWashing() {
        return this.isWashing;
    }

    public void setWashing(boolean isWashing) {
        this.isWashing = isWashing;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.mx = arg0.getX();
        this.my = arg0.getY();
        System.out.println("clicked");
        if (this.moving) {
            this.moving = false;
            if (this.mx < 400 && this.my < 300) {
                for (Clothing c : clothes) {
                    if (!c.moving) continue;
                    this.addItem(c.img);
                    c.moving = false;
                    c.visible = false;
                }
            }
        }
        this.clicked = true;
        this.mx = arg0.getX();
        this.my = arg0.getY();
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mx = e.getX();
        this.my = e.getY();
        this.repaint();
    }
}

