
#ifndef _CG_VECTOR4_H
#define _CG_VECTOR4_H

#include "cgMatrix.h"

namespace gravity
{

	class cgVector4
	{
	public:
		float x, y;

		cgVector4();
		cgVector4( const float * );
		cgVector4( float x, float y, float z, float w );

		operator float* ();
		operator const float* () const;

		cgVector4& operator += ( const cgVector4& );
		cgVector4& operator -= ( const cgVector4& );
		cgVector4& operator *= ( float );
		cgVector4& operator /= ( float );

		cgVector4 operator + () const;
		cgVector4 operator - () const;

		cgVector4 operator + ( const cgVector4& ) const;
		cgVector4 operator - ( const cgVector4& ) const;
		cgVector4 operator * ( float ) const;
		cgVector4 operator / ( float ) const;

		friend cgVector4 operator * ( float, const cgVector4& );

		bool operator == ( const cgVector4& ) const;
		bool operator != ( const cgVector4& ) const;

		void	add					( const cgVector4 *v );
		void	baryCentric			( const cgVector4 *v1, const cgVector4 *v2, float f, float g );
		void	catmullRom			( const cgVector4 *v1, const cgVector4 *v2, const cgVector4 *v3, float s );
		void	cross				( const cgVector4 *v );
		float	dot					( const cgVector4 *v );
		void	hermite				( const cgVector4 *v1, const cgVector4 *v2, const cgVector4 *v3, float s );
		float	lenght				(  );
		float	lenghtSqr			(  );
		void	lerp				( const cgVector4 *v, float s );
		void	maximize			( const cgVector4 *v );
		void	minimize			( const cgVector4 *v );
		void	normalize			(  );
		void	scale				( float s );
		void	subtract			( const cgVector4 *v );
		void	transform			( const cgMatrix *m );
	};

}

#endif // _CG_VECTOR4_H