
#ifndef _CG_COLOR_H
#define _CG_COLOR_H

namespace gravity
{

	class cgColor
	{
	public:
		float r, g, b, a;

		cgColor();
		cgColor( const float * );
		cgColor( float r, float g, float b );
		cgColor( float r, float g, float b, float a );

		operator float * ();
		operator const float * () const;

		cgColor& operator += ( const cgColor& );
		cgColor& operator -= ( const cgColor& );
		cgColor& operator *= ( float );
		cgColor& operator /= ( float );

		cgColor operator + () const;
		cgColor operator - () const;

		cgColor operator + ( const cgColor& ) const;
		cgColor operator - ( const cgColor& ) const;
		cgColor operator * ( float ) const;
		cgColor operator / ( float ) const;

		friend cgColor operator * ( float, const cgColor& );

		bool operator == ( const cgColor& ) const;
		bool operator != ( const cgColor& ) const;

		void add				( const cgColor *c );
		void adjustContrast		( float a );
		void adjustSaturation	( float a );
		void clamp				(  );
		void lerp				( const cgColor *c, float s );
		void modulate			( const cgColor *c );
		void negative			(  );
		void scale				( float s );
		void subtract			( const cgColor *c );
	};

}

#endif // _CG_COLOR_H