
#ifndef _TEXTURE_H
#define _TEXTURE_H

#pragma pack(push, bmpData, 1)

//File information header
//provides general information about the file
struct bmpHeader_t
{ 
	unsigned short	type;			// Filetype (should always be 0x4d42)
	unsigned int	size;			// Total file size
	unsigned short	reserved1;		// Unused
	unsigned short	reserved2;		// Unused
	unsigned int	offset;			// Offset to binary data
};

//Bitmap information header
//provides information specific to the image data
struct bmpInfo_t
{
	unsigned int	size;			// Size of info struct (should always be 40)
	int				width;			// Width of the image
	int				height;			// Height of the image
	unsigned short	planes;			// Number of bit planes (should always be 1)
	unsigned short	bitCount;		// Number of bits pr pixel
	unsigned long	compression;	// Compression method
	unsigned long	sizeImage;		// Size of image data. May be 0
	int				resX;			// Horizontal resolution in pixels pr meter
	int				resY;			// Vertical resolution in pixels pr meter
	unsigned long	clrUsed;		// Number of used colors from palette (may be 0 on 24 bit)
	unsigned long	clrImportant;	// Number of important color indexes (0 if all are important)
};

//Colour palette (the order is important and is intended to be reversed for rgb)
struct bmpPalette_t
{
	unsigned char	blue; 
	unsigned char	green; 
	unsigned char 	red; 
	unsigned char	reserved; 
};

#pragma pack(pop, bmpData)

class texture_c
{
private:
public:
	texture_c();
	~texture_c();

	int  loadBMP		(const char* filename, bool alpha = false);
	void unload			();

};


/*class manager_c
{
private:
	unsigned int*	textures;

public:
	manager_c();
	~manager_c();
};*/


extern texture_c texloader;

#endif // _TEXTURE_H