
uniform sampler2D base_texture;

varying vec2 texCoord;

varying vec3 Normal;
varying vec3 Light;
varying vec3 HalfVector;

void main(void)
{

vec4 base_color = texture2D(base_texture, texCoord);

Normal = normalize(Normal);

float Diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse * max(dot(Normal, Light),0.0);

float Ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
Ambient += gl_LightModel.ambient * gl_FrontMaterial.ambient;

float Specular = gl_FrontMaterial.specular * gl_LightSource[0].specular * pow(max(dot(Normal,HalfVector),0.0), gl_FrontMaterial.shininess);

gl_FragColor = Ambient + (Diffuse * base_color) + Specular;
//gl_FragColor = Ambient + (Diffuse * vec4(1,1,1,1)) + Specular;

}


  