attribute vec3 att1;
attribute vec3 att2;

varying vec3 v1;
varying vec3 v2;
varying vec3 norm;

varying vec3 pos;
varying vec3 LightDir0;
varying vec3 LightDir1;
varying vec3 LightDir2;

void main ()
{
	gl_Position = ftransform();

	pos = vec3(gl_ModelViewMatrix * gl_Vertex);

	LightDir0  = normalize(gl_LightSource[0].position.xyz - pos);
	LightDir1  = normalize(gl_LightSource[1].position.xyz - pos);
	LightDir2  = normalize(gl_LightSource[2].position.xyz - pos);

	v1   = gl_NormalMatrix * att1;
	v2   = gl_NormalMatrix * att2;
	norm = gl_NormalMatrix * gl_Normal;

	gl_TexCoord[0] = gl_MultiTexCoord0;
}