#extension GL_ARB_texture_rectangle : enable

uniform sampler2DRect tex0;
uniform float prog;			// interpolation

void main ()
{
	vec4 frag = texture2DRect(tex0, gl_TexCoord[0].st);
	vec4 invfrag = vec4(1.0) - frag;

	frag = (frag * prog) + (invfrag * (1.0 - prog));

	float lum = (frag.r + frag.g + frag.b) / 3.0; // Quick
	float add = 1.0 - lum;

	gl_FragColor = vec4(frag.rgb + vec3(add*0.3), frag.a);
}