varying vec3 v1;
varying vec3 v2;
varying vec3 norm;
varying vec3 pos;

varying vec3 LightDir0;
varying vec3 LightDir1;
varying vec3 LightDir2;

uniform sampler2D tex0;
uniform sampler2D tex1;

void main ()
{
	vec4 frag = texture2D(tex0, gl_TexCoord[0].st);
	vec3 nmap = texture2D(tex1, gl_TexCoord[0].st).xyz;

	vec3 normLightDir = normalize(LightDir0);

	mat3 ts = mat3(normalize(v1), normalize(v2), normalize(norm));

	float diffuse, specular, reflected;
	float att, dist;
	vec3 acc = vec3(0.0);



	/*
		Expand normals to correct range
	*/
	nmap = nmap * vec3(2.0) - vec3(1.0);
	nmap = ts * normalize(nmap);
	nmap = normalize(nmap);

	/*
		Calculate attenuation for light #0
	*/
	dist = distance(pos, gl_LightSource[0].position.xyz);
	att =  1.0 / ((0.02*dist) + (0.008*dist*dist));

	/*
		Calculate diffuse and specular lighting for light #0
		Clamp the factors to 0.0 - 1.0
	*/
	diffuse = max(dot(nmap, normLightDir), 0.0);
	reflected = max(normalize(reflect(-normLightDir, nmap)).z, 0.0);
	specular  = pow(reflected, 4.0);

	acc = frag.rgb * vec3(0.2, 0.3, 0.8) * (diffuse + specular + 0.1) * att;




	normLightDir = normalize(LightDir1);

	/*
		Calculate attenuation for light #1
	*/
	dist = distance(pos, gl_LightSource[1].position.xyz);
	att =  1.0 / ((0.02*dist) + (0.008*dist*dist));

	/*
		Calculate diffuse and specular lighting for light #1
		Clamp the factors to 0.0 - 1.0
	*/
	diffuse = max(dot(nmap, normLightDir), 0.0);
	reflected = max(normalize(reflect(-normLightDir, nmap)).z, 0.0);
	specular  = pow(reflected, 4.0);

	acc += frag.rgb * vec3(1.0, 0.3, 0.4) * (diffuse + specular + 0.1) * att;




	normLightDir = normalize(LightDir2);

	/*
		Calculate attenuation for light #2
	*/
	dist = distance(pos, gl_LightSource[2].position.xyz);
	att =  1.0 / ((0.02*dist) + (0.008*dist*dist));

	/*
		Calculate diffuse and specular lighting for light #2
		Clamp the factors to 0.0 - 1.0
	*/
	diffuse = max(dot(nmap, normLightDir), 0.0);
	reflected = max(normalize(reflect(-normLightDir, nmap)).z, 0.0);
	specular  = pow(reflected, 4.0);

	acc += frag.rgb * vec3(0.3, 0.7, 0.4) * (diffuse + specular + 0.1) * att;

	gl_FragColor = vec4(acc.r, acc.g, acc.b, 0.0);
}