function timeFormat(t) {
	t += 0.000001;
	var min = Math.floor(t / 60000);
	var ms = t % 60000;
	var sec = (ms / 1000).toFixed(1)
	if (ms < 10000 && min > 0) sec = '0' + sec;
	if (min > 0) {
		return min + ':' + sec
	} else {
		return sec
	}
}
function log10(x) {
	return Math.log(x) / Math.log(10);
}

var mouseMoveAction = null;
var timelineViewportXBeforeDrag = null;
var actorBirthTimeBeforeDrag = null;
var actorDeathTimeBeforeDrag = null;
var mouseXBeforeDrag = null;
var currentlyEditedActor;
var draggedTimelineSpan;

function Timeline(selector, controller) {
	this.controller = controller;
	this.viewport = $(selector);
	this.viewport.addClass('timeline_viewport');
	this.viewport.html('<ul class="toolbar">\
	<li><a href="javascript:void(0)" class="zoom_in">zoom in</a></li>\
	<li><a href="javascript:void(0)" class="zoom_out">zoom out</a></li>\
	<li><a href="javascript:void(0)" class="zoom_fully_out">zoom fully out</a></li>\
	<li class="spacer"></li>\
	<li class="li_play"><a href="javascript:void(0)" class="play">play</a></li>\
	<li class="li_pause"><a href="javascript:void(0)" class="pause">pause</a></li>\
	<li><a href="javascript:void(0)" class="stop">stop</a></li>\
	<li class="spacer"></li>\
	<li><a href="javascript:void(0)" class="export_script">export script</a></li>\
</ul>\
<div class="timeline"><div class="caret"></div></div>\
<div class="scrollbar"><div class="slider"></div></div>');
	
	this.pixelsPerMs = 0.1;
	this.totalDuration = controller.duration();
	this.viewportStartTime = 0;

	this.eventListeners = {redraw: []};

	/* create editors for each child of rootActor (which will tend to cause timeline spans to be created).
		Should really be done in the controller rather than here, but meh... */
	if (this.controller.rootActor.children) {
		for (var i = 0; i < this.controller.rootActor.children.length; i++) {
			var actor = this.controller.rootActor.children[i];
			editor = editorClasses[actor.type] || GenericEditor;
			new editor(actor, this);
		}
	}

	this.caret = $('.caret', this.viewport);

	this.zoomFullyOut();

	var timeline = this;
	$(window).resize(function() {timeline.adjustViewportSize()});

	$('.scrollbar', this.viewport).mousedown(function(e) {
		var newSliderMidpoint = e.clientX - $(this).offset().left;
		timeline.moveScrollbarSlider(newSliderMidpoint);
	}).drag(null, function(e) {
		var newSliderMidpoint = e.clientX - $(this).offset().left;
		timeline.moveScrollbarSlider(newSliderMidpoint);
	});

	$('.timeline', this.viewport).mousedown(function(e) {
		var viewportX = e.clientX - timeline.viewport.offset().left;
		timeline.controller.seek(viewportX / timeline.pixelsPerMs + timeline.viewportStartTime);
	}).drag(null, function(e) {
		var viewportX = e.clientX - timeline.viewport.offset().left;
		var t = viewportX / timeline.pixelsPerMs + timeline.viewportStartTime;
		timeline.controller.seek(t < 0 ? 0 : t); /* TODO: probably want to stop going off the end too. Couldn't make that work for now though. *shrug* */
	});
	
	this.controller.addEventListener('seek', function(t) {timeline.plotCaretPosition(t)});
	this.controller.addEventListener('tick', function(t) {timeline.plotCaretPosition(t)});

/*	$('.timeline', this.viewport).mousedown(function(e) {
		mouseXBeforeDrag = e.clientX;
		timelineViewportXBeforeDrag = timeline.viewportStartTime * timeline.pixelsPerMs;
		mouseMoveAction = 'dragTimeline';
		$(this).css({cursor: 'move'});
	}) */

	$('.toolbar .zoom_in', this.viewport).click(function() {
		timeline.pixelsPerMs = timeline.pixelsPerMs * 2;
		timeline.redraw();
	})
	$('.toolbar .zoom_out', this.viewport).click(function() {
		timeline.pixelsPerMs = timeline.pixelsPerMs / 2;
		timeline.redraw();
	})
	$('.toolbar .zoom_fully_out', this.viewport).click(function() {
		timeline.zoomFullyOut();
	})

	$('.toolbar .play', this.viewport).click(function() {
		timeline.controller.play();
	});
	this.controller.addEventListener('play', function() {
		$('.toolbar .li_play', timeline.viewport).hide();
		$('.toolbar .li_pause', timeline.viewport).show();
	});
	
	$('.toolbar .pause', this.viewport).click(function() {
		timeline.controller.pause();
	});
	$('.toolbar .li_pause', this.viewport).hide();
	this.controller.addEventListener('stop', function() {
		$('.toolbar .li_pause', timeline.viewport).hide();
		$('.toolbar .li_play', timeline.viewport).show();
	});
	$('.toolbar .stop', this.viewport).click(function() {
		timeline.controller.stop();
	});
	$('.toolbar .export_script', this.viewport).click(function() {
		exportScript(timeline.controller);
	});
}
Timeline.prototype.addEventListener = function(event, callback) {
	this.eventListeners[event].push(callback);
}
Timeline.prototype.fireEvent = function(event, param) {
	/* TODO: multiple parameters? */
	var listeners = this.eventListeners[event];
	for (var i = 0; i < listeners.length; i++) {
		listeners[i](param);
	}
}
Timeline.prototype.redraw = function() {
	this.plotGraduations();
	this.plotCaretPosition(this.controller.currentTime());
	$('.timeline', this.viewport).css({width: this.totalDuration * this.pixelsPerMs});
	this.fireEvent('redraw');
	this.adjustViewportSize();
	this.scrollToTime(this.viewportStartTime);
}
Timeline.prototype.adjustViewportSize = function() {
	var timelineWidth = this.totalDuration * this.pixelsPerMs;
	var scrollbarWidth = $('.scrollbar', this.viewport).width();
	var viewportWidth = this.viewport.width();
	var sliderWidth = scrollbarWidth * Math.min(1, viewportWidth / timelineWidth);
	$('.scrollbar .slider', this.viewport).css({width: sliderWidth});
}

/* Determine an appropriate ms spacing between graduations for the current value of pixelsPerMs */
Timeline.prototype.msPerGraduation = function() {
	/* want to choose the smallest of ... 0.1, 0.2, 0.5, 1, 2, 5, 10, 20, 50 ... such that
pixelsPerMs * msPerGraduation (i.e. pixelsPerGraduation) > 200 */
	var a = log10(200/this.pixelsPerMs) + 0.000001;
	var fracA = a - Math.floor(a);
	if (fracA > log10(5)) {
		return Math.pow(10, Math.floor(a) + log10(5));
	} else if (fracA > log10(2)) {
		return Math.pow(10, Math.floor(a) + log10(2));
	} else {
		return Math.pow(10, Math.floor(a) + log10(1));
	}
}
Timeline.prototype.plotGraduations = function() {
	$('.timeline .graduation', this.viewport).remove();
	/* bypass jQuery here for performance */
	var timeline = $('.timeline', this.viewport).get(0);
	var mspg = this.msPerGraduation();
	for (var t = 0; t <= this.totalDuration; t += mspg) {
		var graduation = document.createElement('div');
		graduation.className = 'graduation';
		graduation.style.left = (t * this.pixelsPerMs) + 'px';
		graduation.appendChild(document.createTextNode(timeFormat(t)));
		timeline.appendChild(graduation);
	}
}
Timeline.prototype.plotCaretPosition = function(t) {
	this.caret.css({left: t * this.pixelsPerMs});
}

Timeline.prototype.scrollToTime = function(t) {
	t = Math.max(0, t);
	var viewportDuration = this.viewport.width() / this.pixelsPerMs;
	t = Math.min(this.totalDuration - viewportDuration, t);
	$('.timeline', this.viewport).css({left: -(t * this.pixelsPerMs)});
	var scrollbarWidth = $('.scrollbar', this.viewport).width();
	$('.scrollbar .slider', this.viewport).css({left: scrollbarWidth * (t / this.totalDuration)});
	this.viewportStartTime = t;
}
Timeline.prototype.moveScrollbarSlider = function(newSliderMidpoint) {
	var newViewportMidpointTime = this.totalDuration * (newSliderMidpoint / $('.scrollbar', this.viewport).width());
	var viewportDuration = this.viewport.width() / this.pixelsPerMs;
	var newViewportStartTime = newViewportMidpointTime - viewportDuration/2;
	/* newViewportStartTime = Math.max(0, newViewportStartTime);
	newViewportStartTime = Math.min(this.totalDuration - viewportDuration, newViewportStartTime); */
	this.scrollToTime(newViewportStartTime);
}
Timeline.prototype.zoomFullyOut = function() {
	this.pixelsPerMs = this.viewport.width() / this.totalDuration;
	this.redraw();
	this.scrollToTime(0);
}
Timeline.prototype.addSpan = function(span) {
	this.spanCount = this.spanCount || 0;
	$('.timeline', this.viewport).append(span);
	// span.css({top: 12 + this.spanCount * 12});
	this.spanCount++;
}

var currentEditor;

function exportScript(controller) {
	if ($('#script_export:hidden').length) {
		$('#script_export').val(controller.script()).show();
	} else {
		$('#script_export').hide();
	}
}
