var CIRCLE_STEPS = 24;
var circleTable = [];
SceneGraph = function(children) {
	this.children = children;
}
SceneGraph.prototype.load = function() {
	/* calculate circle table */
	for (var i = 0; i < CIRCLE_STEPS; i++) {
		circleTable[i] = [
			Math.sin(i * 2 * Math.PI / CIRCLE_STEPS),
			0,
			Math.cos(i * 2 * Math.PI / CIRCLE_STEPS)
		]
	}

	var loaders = [];
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].load) loaders.push(this.children[i].load());
		this.children[i].parent = this;
	}
	if (loaders.length == 0) {
		return true;
	} else {
		return deferUntilAllCompleted(loaders);
	}
}
SceneGraph.prototype.render = function(stage) {
	for (var i = 0; i < this.children.length; i++) {
		this.children[i].render(stage);
	}
}
SceneGraph.prototype.addChild = function(child) {
	this.children.push(child);
}
SceneGraph.prototype.removeChild = function(child) {
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i] == child) {
			this.children.splice(i, 1);
			return;
		}
	}
}

SceneGraph.objects = {};
SceneGraph.objects.polygon = function(vertices, opts) {
	this.vertices = vertices;
	this.opts = opts || {};
	this.opts.fillStyle = this.opts.fillStyle || 'white';
}
SceneGraph.objects.polygon.prototype.render = function(stage) {
	stage.ctx.fillStyle = this.opts.fillStyle;
	stage.polygon(this.vertices);
}
SceneGraph.objects.strokedPolygon = function(vertices, opts) {
	this.vertices = vertices;
	this.opts = opts || {};
	this.opts.strokeStyle = this.opts.strokeStyle || 'white';
	this.opts.lineWidth = this.opts.linewidth || 1;
}
SceneGraph.objects.strokedPolygon.prototype.render = function(stage) {
	stage.ctx.strokeStyle = this.opts.strokeStyle;
	stage.ctx.lineWidth = this.opts.lineWidth;
	stage.strokedPolygon(this.vertices);
}
SceneGraph.objects.circle = function(centre, radius, opts) {
	this.centre = centre;
	this.radius = radius;
	this.opts = opts || {};
	this.opts.strokeStyle = this.opts.strokeStyle || 'white';
	this.opts.lineWidth = this.opts.lineWidth || 1;
}
SceneGraph.objects.circle.prototype.render = function(stage) {
	stage.ctx.strokeStyle = this.opts.strokeStyle;
	stage.ctx.lineWidth = this.opts.lineWidth;
	var vertices = [];
	for (var i = 0; i < CIRCLE_STEPS; i++) {
		vertices[i] = [
			circleTable[i][0] * this.radius + this.centre[0],
			this.centre[1],
			circleTable[i][2] * this.radius + this.centre[2]
		]
	}
	stage.strokedPolygon(vertices);
}

SceneGraph.objects.sprite = function(imageId, pos, w, h) {
	this.imageId = imageId;
	this.pos = pos;
	this.w = w || 1;
	this.h = h || 1;
}
SceneGraph.objects.sprite.prototype.load = function() {
	this.image = ImageLoader.images[this.imageId];
}
SceneGraph.objects.sprite.prototype.render = function(stage) {
	stage.putSprite3d(this.image, this.pos, this.w, this.h);
}
