function Keyframe(v, i) {
	this.t = v[0];
	this.i = i;
	this.v = [v[1], v[2], v[3]];
	this.eventListeners = {'change': [], 'changeTime': []}
}
Keyframe.prototype.setV = function(v) {
	this.v = v;
	this.fireEvent('change', v);
}
Keyframe.prototype.setT = function(t) {
	this.t = t;
	if (this.spline != null) this.spline.seek(this.spline.t);
	this.fireEvent('changeTime', t);
}
Keyframe.prototype.toScript = function() {
	return '[' + this.t + ',' + this.v[0] + ',' + this.v[1] + ',' + this.v[2] + ']';
}
Keyframe.prototype.bind = function(event, callback) {
	this.eventListeners[event].push(callback);
}
Keyframe.prototype.unbind = function(event, callback) {
	for (i = 0; i < this.eventListeners[event].length; i++) {
		if (this.eventListeners[event][i] == callback) {
			this.eventListeners[event].splice(i, 1);
			return;
		}
	}
}
Keyframe.prototype.fireEvent = function(event, param) {
	/* TODO: multiple parameters? */
	var listeners = this.eventListeners[event];
	for (var i = 0; i < listeners.length; i++) {
		listeners[i](param);
	}
}

function Spline(points) {
	this.type = 'spline';
	this.points = [];
	for (var i = 0; i < points.length; i++) {
		this.points[i] = new Keyframe(points[i], i);
		this.points[i].spline = this;
	}
	this.t = 0; /* current time */
	this.i = 0; /* current index into points list (i.e. the control point we have just crossed) */
	this.eventListeners = {addPoint: []}
}
Spline.prototype.seek = function(t) {
	this.i = 0;
	this.t = t;
	/* find what index we're on at time t */
	while (this.points[this.i+1] != null && this.points[this.i+1].t < this.t) this.i++;
}
Spline.prototype.tick = function(t) {
	this.t = t;
	while (this.points[this.i+1] != null && this.points[this.i+1].t < this.t) this.i++;
}
Spline.prototype.value = function() {
	var p1 = this.points[this.i];
	var p2 = this.points[this.i+1];
	if (p2 == null) return p1.v; /* t is past the end of the list of points;
		this can legitimately happen if there is only one control point (at t=0) */

	/* s = how far along points[i]..points[i+1] we are, expressed as a fraction */
	s = (this.t - p1.t) / (p2.t - p1.t);

	var t1, t2;
	if (this.i < 1) {
		var p3 = this.points[this.i+2];
		if (p3 == null) {
			/* this means that there are only two control points; in such a case, we interpolate */
			return [
				p1.v[0]*(1-s) + p2.v[0] * s,
				p1.v[1]*(1-s) + p2.v[1] * s,
				p1.v[2]*(1-s) + p2.v[2] * s
			];
		}
		var ts = (p2.t - p1.t) / (p3.t - p1.t);
		t1 = t2 = [(p3.v[0] - p1.v[0]) * ts, (p3.v[1] - p1.v[1]) * ts, (p3.v[2] - p1.v[2]) * ts];
	} else if (this.i < this.points.length - 2) {
		var p0 = this.points[this.i-1];
		var p3 = this.points[this.i+2];
		/* compute tangent scale factors to compensate for different time intervals */
		/* ts1/td2 were originally multiplied by 2, but if we don't do that we don't have to multiply t1/t2 by 0.5 later */
		var ts1 = (p2.t - p1.t) / (p2.t - p0.t);
		var td2 = (p2.t - p1.t) / (p3.t - p1.t);
		t1 = [(p2.v[0] - p0.v[0]) * ts1, (p2.v[1] - p0.v[1]) * ts1, (p2.v[2] - p0.v[2]) * ts1];
		t2 = [(p3.v[0] - p1.v[0]) * td2, (p3.v[1] - p1.v[1]) * td2, (p3.v[2] - p1.v[2]) * td2];
	} else {
		var p0 = this.points[this.i-1];
		var ts = (p2.t - p1.t) / (p2.t - p0.t);
		t1 = t2 = [(p2.v[0] - p0.v[0]) * ts, (p2.v[1] - p0.v[1]) * ts, (p2.v[2] - p0.v[2]) * ts];
	}

	var s2 = s*s;
	var s3 = s2*s;
	var h1 = 2*s3 - 3*s2 + 1;
	var h2 = -2*s3 + 3*s2;
	var h3 = s3 - 2*s2 + s;
	var h4 = s3 - s2;
	
	return [
		h1*p1.v[0] + h2*p2.v[0] + h3*t1[0] + h4*t2[0],
		h1*p1.v[1] + h2*p2.v[1] + h3*t1[1] + h4*t2[1],
		h1*p1.v[2] + h2*p2.v[2] + h3*t1[2] + h4*t2[2]
	]
}
Spline.prototype.addPoint = function() {
	var v = this.value();
	var kf = new Keyframe([this.t, v[0], v[1], v[2]], this.i+1);
	kf.spline = this;
	this.points.splice(this.i+1, 0, kf);
	for (var j = this.i + 2; j < this.points.length; j++) {
		this.points[j].i++;
	}
	this.fireEvent('addPoint', kf);
	var v = this.value();
}
Spline.prototype.toScript = function() {
	var pointsScript = [];
	for (var i = 0; i < this.points.length; i++) {
		pointsScript.push(this.points[i].toScript())
	}
	return 'new Spline([' + pointsScript.join(',') + '])';
}
Spline.prototype.addEventListener = function(event, callback) {
	this.eventListeners[event].push(callback);
}
Spline.prototype.fireEvent = function(event, param) {
	/* TODO: multiple parameters? */
	var listeners = this.eventListeners[event];
	for (var i = 0; i < listeners.length; i++) {
		listeners[i](param);
	}
}

function Constant(v) {
	this.type = 'constant';
	this.v = v;
}
Constant.prototype.value = function() {return this.v;}
Constant.prototype.toScript = function() {
	return 'new Constant(' + JSON.stringify(this.v) + ')';
}
