function Typewriter(chars, opts) {
	this.type = 'typewriter';
	this.opts = opts || {};
	this.opts.birthTime = this.opts.birthTime || 0;
	this.opts.top = this.opts.top || 64;
	this.opts.left = this.opts.left || 64;
	this.chars = chars;
}
Typewriter.prototype.load = function() {
	this.canvas = document.createElement('canvas');
	this.canvas.width = stage.canvas.width;
	this.canvas.height = 200;
	this.ctx = this.canvas.getContext('2d');

	var result = new Deferred();
	this.font = new Image();
	var typewriter = this;
	this.font.onload = function() {
		result.setResult(true);
	}
	this.font.src = 'demo/font.png';
	return result;
}
Typewriter.prototype.startup = function() {
	this.ctx.clearRect(0,0,this.canvas.width, 200);
	this.nextCharIndex = 0;
	this.x = 0;
	this.y = 0;
}
Typewriter.prototype.seek = function(t) {
	this.startup();
	this.tick(t);
}
Typewriter.prototype.tick = function(t) {
	var nextchar;
	while ( (nextchar = this.chars[this.nextCharIndex]) != null && nextchar.time <= t) {
		var fontOffset = (nextchar.charCode - 32) * 56;
		this.ctx.drawImage(this.font, fontOffset, 0, 56, 136, this.x,this.y, 19, 45);
		if (nextchar.newline) {
			this.x = 0;
			this.y += 45;
		} else {
			this.x += 19;
		}
		this.nextCharIndex++;
	}
	this.paint();
}
Typewriter.prototype.paint = function() {
	stage.enqueueDrawImage(-3, this.canvas,this.opts.left,this.opts.top);
}
Typewriter.prototype.toScript = function() {
	return "new Typewriter(\n" + JSON.stringify(this.chars) + ", " + JSON.stringify(this.opts) + ")";
}

/* cut-and-paste ahoy! Not enough time to refactor Typewriter to support multiple fonts... */
function WomanTypewriter(chars, opts) {
	this.type = 'womantypewriter';
	this.opts = opts || {};
	this.opts.birthTime = this.opts.birthTime || 0;
	this.opts.top = this.opts.top || 64;
	this.opts.left = this.opts.left || 64;
	this.chars = chars;
}
WomanTypewriter.prototype.load = function() {
	this.canvas = document.createElement('canvas');
	this.canvas.width = stage.canvas.width;
	this.canvas.height = 200;
	this.ctx = this.canvas.getContext('2d');

	var result = new Deferred();
	this.font = new Image();
	var typewriter = this;
	this.font.onload = function() {
		result.setResult(true);
	}
	this.font.src = 'demo/font2.png';
	return result;
}
WomanTypewriter.prototype.startup = function() {
	this.ctx.clearRect(0,0,this.canvas.width, 200);
	this.nextCharIndex = 0;
	this.x = 0;
	this.y = 0;
}
WomanTypewriter.prototype.seek = function(t) {
	this.startup();
	this.tick(t);
}
WomanTypewriter.prototype.tick = function(t) {
	var nextchar;
	while ( (nextchar = this.chars[this.nextCharIndex]) != null && nextchar.time <= t) {
		var fontOffset = (nextchar.charCode - 32) * 56;
		this.ctx.drawImage(this.font, fontOffset, 0, 56, 136, this.x,this.y, 19, 45);
		if (nextchar.newline) {
			this.x = 0;
			this.y += 45;
		} else {
			this.x += 19;
		}
		this.nextCharIndex++;
	}
	this.paint();
}
WomanTypewriter.prototype.paint = function() {
	stage.enqueueDrawImage(-3, this.canvas,this.opts.left,this.opts.top);
}
WomanTypewriter.prototype.toScript = function() {
	return "new WomanTypewriter(\n" + JSON.stringify(this.chars) + ", " + JSON.stringify(this.opts) + ")";
}