var easeOutElasticTable = [];
var spawnDuration = 1000;

function BlokeSpawner(times, opts) {
	this.type = 'blokespawner';
	this.times = times;
	this.opts = opts;
}
BlokeSpawner.prototype.load = function() {
	var easeFunction = function(t) {
		if (t==0) return 0;  if ((t/=spawnDuration)==1) return 1; var p=spawnDuration*.3;
		var a=1; var s=p/4;
		return a*Math.pow(2,-10*t) * Math.sin( (t*spawnDuration-s)*(2*Math.PI)/p ) + 1;
	}
	for (var t = 0; t < spawnDuration; t++) {
		easeOutElasticTable[t] = easeFunction(t);
	}
	var scene = scenes[this.opts.scene];
	var blokes = [];
	for (var i = 0; i < this.times.length; i++) {
		var bloke = new RandomBloke(scene, {birthTime: this.times[i], runAwayAt: this.opts.runAwayAt - this.times[i], runAwayFrom: this.opts.runAwayFrom});
		blokes.push(bloke);
	}
	this.sequence = new Sequence(blokes, {birthTime: this.opts.birthTime || 0, deathTime: this.opts.deathTime});
}
BlokeSpawner.prototype.startup = function() { this.sequence.startup() };
BlokeSpawner.prototype.teardown = function() { this.sequence.teardown() };
BlokeSpawner.prototype.seek = function(t) {
	this.sequence.seek(t);
}
BlokeSpawner.prototype.tick = function(t) {
	this.sequence.tick(t);
}
BlokeSpawner.prototype.toScript = function() {
	return "new BlokeSpawner(" + JSON.stringify(this.times) + ',' + JSON.stringify(this.opts) + ')';
}

function RandomBloke(scene, opts) {
	this.scene = scene;
	this.opts = opts || {};
	var hasGoodPosition = false;
	while(!hasGoodPosition) {
		this.x = Math.random() * 12 - 6; /* TODO: preserve random seed */
		this.z = Math.random() * 12 - 6;
		hasGoodPosition = (this.x - this.opts.runAwayFrom[0]) * (this.x - this.opts.runAwayFrom[0]) + (this.z - this.opts.runAwayFrom[2]) * (this.z - this.opts.runAwayFrom[2]) > 0.3;
	};
	this.sprite = new SceneGraph.objects.sprite('greyMan', [this.x, 0.25, this.z], 0.194, 0.501);
	this.sprite.load();
}
RandomBloke.prototype.seek = RandomBloke.prototype.tick = function(t) {
	if (t < spawnDuration) {
		this.sprite.h = 0.501 * easeOutElasticTable[Math.floor(t)];
	} else {
		this.sprite.h = 0.501;
	}
	if (t < this.opts.runAwayAt) {
		this.sprite.pos = [this.x, 0.25, this.z];
	} else {
		var runProportion = Math.min(1, (t - this.opts.runAwayAt) / 16000);
		runProportion = 1 - (1-runProportion)*(1-runProportion);
		var displacement = [
			this.x - this.opts.runAwayFrom[0],
			0,
			this.z - this.opts.runAwayFrom[2],
		]
		var repulsion = 1 + runProportion * 1.2 / (Math.sqrt(displacement[0]*displacement[0] + displacement[2]*displacement[2]) + 0.01);
		this.sprite.pos = [
			this.opts.runAwayFrom[0] + repulsion * displacement[0],
			0.25,
			this.opts.runAwayFrom[2] + repulsion * displacement[2]
		];
	}
}
RandomBloke.prototype.startup = function() {
	this.scene.addChild(this.sprite);
}
RandomBloke.prototype.teardown = function() {
	this.scene.removeChild(this.sprite);
}

function Wanderer(position, opts) {
	this.type = 'wanderer';
	this.position = position; this.position.parent = this;
	this.opts = opts || {};
	this.scene = scenes[this.opts.scene];
	this.opts.width = this.opts.width || 0.194;
	this.opts.height = this.opts.height || 0.501;
}
Wanderer.prototype.load = function() {
	this.sprite = new SceneGraph.objects.sprite(this.opts.sprite, this.position.value(), this.opts.width, this.opts.height);
	this.sprite.load();
	return true;
}
Wanderer.prototype.seek = function(t) {
	this.position.seek(t);
	this.draw(t);
}
Wanderer.prototype.tick = function(t) {
	this.position.tick(t);
	this.draw(t);
}
Wanderer.prototype.draw = function(t) {
	if (this.opts.spawn && t < spawnDuration) {
		this.sprite.h = this.opts.height * easeOutElasticTable[Math.floor(t)];
	} else {
		this.sprite.h = this.opts.height;
	}
	this.sprite.pos = this.position.value();
}
Wanderer.prototype.startup = function() {
	this.scene.addChild(this.sprite);
}
Wanderer.prototype.teardown = function() {
	this.scene.removeChild(this.sprite);
}
Wanderer.prototype.toScript = function() {
	out = "new Wanderer(\n";
	out += "\t" + this.position.toScript() + ",\n";
	out += "\t" + JSON.stringify(this.opts) + ")";
	return out;
}

var spotlightEaseDuration = 6000;
var spotlightSize = 3.5;
function Spotlight(centre, opts) {
	this.type = 'spotlight';
	this.centre = centre;
	this.opts = opts || {}
	this.opts.radius = this.opts.radius || spotlightSize;
	this.scene = scenes[this.opts.scene];
	this.model = new SceneGraph.objects.circle(this.centre, 0, {strokeStyle: '#444444', lineWidth: 2});
}
Spotlight.prototype.startup = function() {
	this.scene.addChild(this.model);
}
Spotlight.prototype.teardown = function() {
	this.scene.removeChild(this.model);
}
Spotlight.prototype.tick = Spotlight.prototype.seek = function(t) {
	if (t < spotlightEaseDuration) {
		this.model.radius = this.opts.radius * (t / spotlightEaseDuration);
	} else {
		this.model.radius = this.opts.radius;
	}
}
Spotlight.prototype.toScript = function() {
	out = "new Spotlight(" + JSON.stringify(this.centre) + ", " + JSON.stringify(this.opts) + ")";
	return out;
}

function Gateway(opts) {
	this.type = 'gateway';
	this.opts = opts || {};
	this.scene = scenes[this.opts.scene];
//	this.model = new SceneGraph.objects.polygon([[-19,0,-2],[-19,8,-2],[-19,8,2],[-19,0,2]], {fillStyle: '#000000'})
	this.model = new SceneGraph.objects.polygon([[-10,0,-1],[-10,4,-1],[-10,4,1],[-10,0,1]], {fillStyle: '#222222'})
}
Gateway.prototype.startup = function() {
	this.scene.addChild(this.model);
}
Gateway.prototype.teardown = function() {
	this.scene.removeChild(this.model);
}
Gateway.prototype.toScript = function() {
	out = "new Gateway(" + JSON.stringify(this.opts) + ")";
	return out;
}
