uniform sampler2D Texture0;
varying vec2 texCoord;
uniform float viewportWidth;
uniform float viewportHeight;
uniform float contrast;
uniform float brightness;

void main(void)
{
	float xs = 1.0/viewportWidth;
	float ys = 1.0/viewportHeight;
	vec4 sum;

	sum = texture2D( Texture0, clamp(vec2(texCoord.x, texCoord.y), 0.0, 1.0));

	sum += texture2D( Texture0, clamp(vec2(texCoord.x - xs, texCoord.y), 0.0, 1.0));
	sum += texture2D( Texture0, clamp(vec2(texCoord.x + xs, texCoord.y), 0.0, 1.0));
	sum += texture2D( Texture0, clamp(vec2(texCoord.x, texCoord.y - ys), 0.0, 1.0));
	sum += texture2D( Texture0, clamp(vec2(texCoord.x, texCoord.y + ys), 0.0, 1.0));

	sum += texture2D( Texture0, clamp(vec2(texCoord.x - xs*2.0, texCoord.y), 0.0, 1.0));
	sum += texture2D( Texture0, clamp(vec2(texCoord.x + xs*2.0, texCoord.y), 0.0, 1.0));
	sum += texture2D( Texture0, clamp(vec2(texCoord.x, texCoord.y - ys*2.0), 0.0, 1.0));
	sum += texture2D( Texture0, clamp(vec2(texCoord.x, texCoord.y + ys*2.0), 0.0, 1.0));
	
	
   gl_FragColor = (sum / 9.0);
}
