float4x4 matWorldViewProjection; 
texture tex0; 
float alpha;
sampler tex = sampler_state
{
	texture = (tex0); 
	AddressU = Wrap; 
	AddressV = Wrap; 
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;  
};

void vs_tex(in float4 ipos : POSITION,
			in float2 itex : TEXCOORD0,
			out float4 opos : POSITION,
			out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection); 
	otex = itex; 
};

float4 ps_tex(in float2 itex : TEXCOORD0) : COLOR0
{
	return tex2D(tex, itex)*alpha; 
};

technique yo
{
	pass br
	{
		VertexShader = compile vs_2_0 vs_tex();
		PixelShader = compile ps_2_0 ps_tex(); 
	}
}