float4x4 matWorldViewProjection;

texture tex0;
float tile = 1.f;
float alpha = 1.f;

sampler2D samp = sampler_state
{
	texture = (tex0);
	AddressU = Wrap;
	AddressV = Wrap;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
};

void vs_texture_safe(in float4 ipos : POSITION,
				in float2 itex : TEXCOORD0,
				out float4 opos : POSITION,
				out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	if(otex.y<0) otex.y = abs(otex.y);	
};

void vs_texture(in float4 ipos : POSITION,
				in float2 itex : TEXCOORD0,
				out float4 opos : POSITION,
				out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
};

void vs_texture_tile(in float4 ipos : POSITION,
				in float2 itex : TEXCOORD0,
				out float4 opos : POSITION,
				out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex*tile;
//	otex.x *= tile; 
};

float4 ps_texture(in float2 tex: TEXCOORD0) : COLOR0
{
	//return float4(tex.y, 0.f, 0.f, 0.f);
	return tex2D(samp, tex);
};

float4 ps_texture_alpha(in float2 tex: TEXCOORD0) : COLOR0
{
	//return float4(tex.y, 0.f, 0.f, 0.f);
	return tex2D(samp, tex)*alpha;
};

technique boy
{
	pass base
	{
		vertexshader = compile vs_2_0 vs_texture();
		pixelshader  = compile ps_2_0 ps_texture();
	}

	pass tile
	{
		vertexshader = compile vs_2_0 vs_texture_tile();
		pixelshader  = compile ps_2_0 ps_texture();
	}

	pass safe
	{
		vertexshader = compile vs_2_0 vs_texture_safe();
		pixelshader  = compile ps_2_0 ps_texture();
	}

	pass alpha
	{
		vertexshader = compile vs_2_0 vs_texture();
		pixelshader  = compile ps_2_0 ps_texture_alpha();
	}
};