
pi = math.pi
sin = math.sin
cos = math.cos
floor = math.floor
min = math.min

-------------------------------------------------------------------------------
--	Runtime
-------------------------------------------------------------------------------

rt = { min=1, max=-1, funcs={}, absframe=0,
	timestack = { { frame=0, waitframe=0 } } }

rt.co = coroutine.create(function()
	while true do

		if rt.timestack[1].frame >= rt.timestack[1].waitframe then
			coroutine.yield()
		end

		for i = rt.min, rt.max do
			if rt.funcs[i] then
				if rt.funcs[i].numf > 0 then
					-- reltime:
					rt.funcs[i].func(rt.timestack[1].frame, unpack(rt.funcs[i].args))
					-- abstime:
					-- rt.funcs[i].func(rt.absframe, unpack(rt.funcs[i].args))
					rt.funcs[i].numf = rt.funcs[i].numf - 1
				end
			end
		end

		rt.timestack[1].frame = rt.timestack[1].frame + 1
		rt.absframe = rt.absframe + 1

		vsync()
	
	end	
end)
	
function resettime()
 	rt.absframe = 0
	rt.timestack[1].frame = 0
end

function waitabs(f)
	if f < 0 then f = 1000000000 end
	if f > rt.timestack[1].frame then
		rt.timestack[1].waitframe = f
		coroutine.resume(rt.co)
	end
end

function wait(f)
	if f < 0 then f = 1000000000 end
	if f > 0 then
		rt.timestack[1].waitframe = rt.timestack[1].frame + f
		coroutine.resume(rt.co)
	end
end

function sync(qid)
	while qsync(qid) == false do
		setborder(0.6,0,0.6)
		wait(1)
	end
	setborder(0,0,0.4)
end

function call(slot, func, numf, ...)
	if numf < 0 then numf = 1000000000 end
	if numf > 0 then
		if slot < rt.min then rt.min = slot end
		if slot > rt.max then rt.max = slot end
		rt.funcs[slot] = {}
		rt.funcs[slot].func = func;
		rt.funcs[slot].numf = numf;
		rt.funcs[slot].args = arg;
	end
end

function kill(...)
	if arg.n == 0 then
		for i = rt.min, rt.max do
			rt.funcs[i] = nil
		end
		rt.min = 1
		rt.max = -1
	else
		for i = 1, arg.n do
			rt.funcs[arg[i]] = nil
			if arg[i] == rt.min then rt.min = rt.min + 1 end
			if arg[i] == rt.max then rt.max = rt.max - 1 end
		end
	end
end

function pushtime()
	table.insert(rt.timestack, 1, { frame = 0, waitframe = 0 })	
end

function poptime()
	local f = rt.timestack[1].frame
	table.remove(rt.timestack, 1) 
	rt.timestack[1].frame = rt.timestack[1].frame + f
end

-------------------------------------------------------------------------------

coroutine.resume(rt.co)
