//-------------------------------------------------------------------
//
//
//-------------------------------------------------------------------

//-------------------------------------------------------------------
// p[^
//-------------------------------------------------------------------

// ˉes
float4x4	projMat;
float		blendRate;


// eNX`Tv

// V[CO@J[obt@
sampler2D srcCBuf0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};
// V[CP@J[obt@
sampler2D srcCBuf1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};
// V[CO@Zobt@
sampler2D srcZBuf0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};
// V[CP@Zobt@
sampler2D srcZBuf1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};
// V[CO@[Nobt@
sampler2D workBuf0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};
// V[CP@[Nobt@
sampler2D workBuf1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};

float shTime0 : TIME_RATE_0;// V[C0̎
float shTime1 : TIME_RATE_1;// V[C1̎
float shTimeEffect : TIME_RATE_EFFECT;// ̃GtFNg̎


//-------------------------------------------------------------------
// VS
//-------------------------------------------------------------------
void VS(	float4 in_pos			: POSITION	,
				float2 in_texcoord		: TEXCOORD0	,
				out float4 out_pos		: POSITION	,
				out float4 out_col		: COLOR		,
				out float2 out_texcoord	: TEXCOORD0 ,
				out float2 out_e		: TEXCOORD1		 )
{
	// pos
	out_pos = mul( projMat, in_pos );

	// texcoord
	out_texcoord = in_texcoord;
	
	// Fade Effect
	float fadetm = 0.28f;
	out_col = float4(1.0f, 0.0f, 1.0f, 1.0f);
	if ((shTimeEffect > fadetm) && (shTimeEffect <= fadetm + 0.025f))
	{
		float w = ((shTimeEffect - fadetm)*40.0f + 1.0f);
		out_col.r = w;
		out_col.g = (w - 1.0f);
		out_e = 1.0f;
	}
	else if((shTimeEffect > fadetm + 0.025f) && (shTimeEffect <= fadetm + 0.05f))
	{
		float w = ((fadetm + 0.05f - shTimeEffect)*40.0f + 1.0f);
		out_col.r = w;
		out_col.g = (w - 1.0f);
		out_e = 2.0f;
	}
	
	if (shTimeEffect > fadetm + 0.025f)
	{
		out_e = 2.0f;
	}
	else
	{
		out_e = 1.0f;
	}
	
}


#define DOF_FocalScale  1.0f
#define DOF_FocalOffset  1.0f

#define SAMPLE_NUM 16
#define BLUR_WIDTH 0.03f
//-------------------------------------------------------------------
// PS
//-------------------------------------------------------------------
void BlurPS_s0(float4 in_col		: COLOR		,
			 float2 samplePos	: TEXCOORD0	,
			 out float4 out_col	: COLOR		)
{
	float4 tmpColor = 0;

	//
	float2 tblSample00 = float2(-0.007500, 0);
	float2 tblSample01 = float2(-0.006562, 0);
	float2 tblSample02 = float2(-0.005625, 0);
	float2 tblSample03 = float2(-0.004687, 0);
	float2 tblSample04 = float2(-0.003750, 0);
	float2 tblSample05 = float2(-0.002812, 0);
	float2 tblSample06 = float2(-0.001875, 0);
	float2 tblSample07 = float2(-0.000937, 0);
	float2 tblSample08 = float2(0.000000, 0);
	float2 tblSample09 = float2(0.000937, 0);
	float2 tblSample10 = float2(0.001875, 0);
	float2 tblSample11 = float2(0.002812, 0);
	float2 tblSample12 = float2(0.003750, 0);
	float2 tblSample13 = float2(0.004687, 0);
	float2 tblSample14 = float2(0.005625, 0);
	float2 tblSample15 = float2(0.006562, 0);
	//
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample00 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample01 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample02 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample03 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample04 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample05 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample06 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample07 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample08 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample09 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample10 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample11 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample12 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample13 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample14 );
	tmpColor += tex2D(srcCBuf0, samplePos + tblSample15 );
	
	tmpColor /= (float)SAMPLE_NUM;
	out_col = tmpColor;
}

void BlurPS_w0(float4 in_col		: COLOR		,
			 float2 samplePos	: TEXCOORD0	,
			 out float4 out_col	: COLOR		)
{
	float4 tmpColor = 0;
	//
	float2 tblSample00 = float2(0, -0.007500);
	float2 tblSample01 = float2(0, -0.006562);
	float2 tblSample02 = float2(0, -0.005625);
	float2 tblSample03 = float2(0, -0.004687);
	float2 tblSample04 = float2(0, -0.003750);
	float2 tblSample05 = float2(0, -0.002812);
	float2 tblSample06 = float2(0, -0.001875);
	float2 tblSample07 = float2(0, -0.000937);
	float2 tblSample08 = float2(0, 0.000000);
	float2 tblSample09 = float2(0, 0.000937);
	float2 tblSample10 = float2(0, 0.001875);
	float2 tblSample11 = float2(0, 0.002812);
	float2 tblSample12 = float2(0, 0.003750);
	float2 tblSample13 = float2(0, 0.004687);
	float2 tblSample14 = float2(0, 0.005625);
	float2 tblSample15 = float2(0, 0.006562);
	//
	tmpColor += tex2D(workBuf0, samplePos + tblSample00 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample01 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample02 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample03 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample04 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample05 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample06 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample07 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample08 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample09 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample10 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample11 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample12 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample13 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample14 );
	tmpColor += tex2D(workBuf0, samplePos + tblSample15 );
	
	tmpColor /= (float)SAMPLE_NUM;
	out_col = tmpColor;
}


void DepthBlend_s0w1(float4 in_col		: COLOR		,
			 float2 samplePos	: TEXCOORD0	,
			 float2 in_e		: TEXCOORD1	,
			 out float4 out_col	: COLOR		)
{
	
	float4 scol = tex2D(srcCBuf0, samplePos);
	float4 bcol = tex2D(workBuf1, samplePos);
	float d = max(0, min(1,pow(tex2D(srcZBuf0, samplePos).r*1.2f, 4)* DOF_FocalScale - DOF_FocalOffset));
	//out_col = float4(d,d,d,1);
	out_col = lerp(scol, bcol, d);
	
	// Ore Filter
	out_col *= out_col;
	
	// Fade Effect
	/*
	float fadetm = 0.28f;
	if ((shTimeEffect > fadetm) && (shTimeEffect <= fadetm + 0.025f))
	{
		float w = ((shTimeEffect - fadetm)*40.0f + 1.0f);
		out_col = out_col * w + (w - 1.0f); 
	}
	else if((shTimeEffect > fadetm + 0.025f) && (shTimeEffect <= fadetm + 0.05f))
	{
		float w = ((fadetm + 0.05f - shTimeEffect)*40.0f + 1.0f);
		out_col = out_col * w + (w - 1.0f);
		out_col *= 2.0f;
	}
	else if(shTimeEffect > fadetm + 0.05f)
	{
		out_col *= 2.0f;
	}*/
	out_col.rgb = (out_col.rgb * in_col.r + in_col.g) * in_e.r;

}


void copyAsIsPS(float4 in_col		: COLOR		,
			 float2 samplePos	: TEXCOORD0	,
			 out float4 out_col	: COLOR		)
{
	out_col = tex2D(workBuf0, samplePos);
}


//-------------------------------------------------------------------
// eNjbN
//-------------------------------------------------------------------
technique sm_glsl
{
	pass P0
	{
		VertexProgram   = compile glslv VS();
		FragmentProgram = compile glslf BlurPS_s0();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
	pass P1
	{
		VertexProgram   = compile glslv VS();
		FragmentProgram = compile glslf BlurPS_w0();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
	pass P2
	{
		VertexProgram   = compile glslv VS();
		FragmentProgram = compile glslf DepthBlend_s0w1();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
}
