#extension GL_ARB_texture_rectangle : enable
uniform sampler2DRect tex0;
uniform float blend;


float step(float x) {
  return 1.0 / (1.0 + exp(-x*50.0));
}

void main() {
  
  vec2 screenpos = gl_TexCoord[0].xy;

  float e = 0;
  for (int i = - 1; i < 2; ++i) 
    for (int j = - 1; j < 2; ++j) {

      if (i != 0 && j != 0)  {
	e += texture2DRect( tex0, screenpos + vec2(i,j) ).a;

      }

    }

  vec4 c = texture2DRect( tex0, screenpos);
  float k = 0.0;

  if (c.r > .2) {
    k = (cos(screenpos.x)*0.5+0.5 + sin(screenpos.y)*0.5+0.5);
    //k = 1.0-step(mod(screenpos.x - screenpos.y, 3.0)/3.0  - 0.5 );
  }

  float center = c.a;
  float t = e - center*15.0;

  if (t < 0)
    t= 0.0;


  float f = t+k;
  vec4 color = c * blend + vec4(.7,.7,.7,t+k) * (1.0-blend);

  gl_FragColor = color;
}
