#include "_shared.fx"

float4x4 wMatrix 	: World
<
	string UIWidget="None";
>;
float4x4 wvMatrix	: WorldView
<
	string UIWidget="None";
>;

float4x4 wvpMatrix 	: WorldViewProjection
<
	string UIWidget="None";
>;

float4 g_MaterialAmbientColor
<
    string UIName =  "Material Ambient";
    string UIWidget = "Color";
> = {0.1f,0.1f,0.1f,1.0f};

float4 g_MaterialDiffuseColor
<
    string UIName =  "Material Diffuse";
    string UIWidget = "Color";
> = { 1.0f, 1.0f, 1.0f, 0.0f };
float shadowFactor
<
	string UIName = "Shadow Influence";
> = 0.5f;

float ColA;
Texture2D texture0;

struct VS_INPUT
{
    float3 vPos		: POSITION;
    float3 normal	: NORMAL;
	float2 uvCoord	: TEXCOORD0;
	uint fq			: TEXCOORD1;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
    float3 lightDir	: TEXCOORD0;
    float3 normal	: TEXCOORD1;
	float3 depth	: TEXCOORD2;
	float4 LampPos[3] : TEXCOORD3;
	float2 uvCoord	: TEXCOORD6;
	float  colorLerp: TEXCOORD7; 
};

struct VS_GLOW_OUTPUT
{
	float4 Position	: SV_POSITION;
	float  colorLerp: TEXCOORD0; 
};

VS_GLOW_OUTPUT RenderGlowVS( VS_INPUT In )
{
	VS_GLOW_OUTPUT Out;
    Out.Position = mul(float4(In.vPos,1.0f), wvpMatrix);
	Out.colorLerp = saturate(fftData.Load(uint3(In.fq,0,0))*80.0f)*ColA;
    return Out;
}


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
    float4x4 wvLampMatrix = mul(wMatrix,lvMatrix);
	float4 lampSpace = mul(float4(In.vPos,1.0f),wvLampMatrix);
    float4 LampPos = mul(lampSpace,pMatrices[0]);
	Out.LampPos[0].xyzw = float4(0.5f*float2(LampPos.x,-LampPos.y)/LampPos.w+float2(0.5f,0.5f),LampPos.z,LampPos.w);
	LampPos = mul(lampSpace,pMatrices[1]);
	Out.LampPos[1].xyzw = float4(0.5f*float2(LampPos.x,-LampPos.y)/LampPos.w+float2(0.5f,0.5f),LampPos.z,LampPos.w);
	LampPos = mul(lampSpace,pMatrices[2]);
	Out.LampPos[2].xyzw = float4(0.5f*float2(LampPos.x,-LampPos.y)/LampPos.w+float2(0.5f,0.5f),LampPos.z,LampPos.w);
	
    Out.normal = mul( float4(In.normal,0.0f), wMatrix );
    float3 vWorld = mul( float4(In.vPos,1.0f), wMatrix );
    Out.lightDir = normalize(lightPos - vWorld.xyz);
    Out.Position = mul(float4(In.vPos,1.0f), wvpMatrix);
	Out.depth = float3(mul(float4(In.vPos,1.0f), wvMatrix).z,dot(Out.lightDir,Out.normal), abs(Out.Position.x)*1544141.0f+abs(Out.Position.y)*348866.0f);
	Out.uvCoord = In.uvCoord;
	Out.colorLerp = saturate(fftData.Load(uint3(In.fq,0,0))*80.0f)*ColA;
    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;
	
	float factor = 0.0f;
	if( In.depth.y > 0.0f )
	{
		int i;
		for( i = 0; i < 3; i++ )
			if( In.depth.x < splitPlanes[i] )
				break;
		
		uint screenPs = uint(In.depth.z)%256;
		float pxDepth = In.LampPos[i].z/In.LampPos[i].w + depthBias;
		
		for(int j =0; j<16; j++ )
		{
			float2 offset = noiseTex.Load(int3(j,screenPs,0)).xy;
			factor += shadowmap.SampleLevel(ShadowSampler, float3(In.LampPos[i].xy+offset,i), 0).x>pxDepth?0.0625f:0.0f;
		}
	}
	
	In.normal = normalize( In.normal );
	In.lightDir = normalize( In.lightDir );
	
	float dif = max( 0.0f, dot( In.normal, In.lightDir ) )*lerp(1.0f,factor,shadowFactor);
	float4 finalColor = g_MaterialDiffuseColor*dif + g_MaterialAmbientColor;
	Out.finalColor = texture0.Sample(LinearSampler,In.uvCoord)*finalColor;//pow( finalColor, 1/2.2f );
	Out.finalColor.rgb = lerp(Out.finalColor.rgb,float3(0.949f,0.349f,0.125f),In.colorLerp);
    return Out;
}

PS_OUTPUT RenderGlowPS( VS_GLOW_OUTPUT In )
{ 
	PS_OUTPUT Out;
	Out.finalColor.rgb = float3(0.949f,0.349f,0.125f)*In.colorLerp;
    return Out;
}

technique10 ps20
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );

		SetDepthStencilState( Depth, 0 );
	SetRasterizerState( Multisampled );
    }
}

technique10 glow
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderGlowVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderGlowPS() ) );

		SetDepthStencilState( Depth, 0 );
		SetRasterizerState( NotMultisampled );
		SetBlendState( NoBlending, float4(0,0,0,0), 0xffffffff );
    }
}