#include "_shared.fx"

float ColA;
float4 g_MaterialAmbientColor;

float4x4 wvpMatrix 	: WorldViewProjection;

struct VS_INPUT
{
    float3 vPos : POSITION;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
    Out.Position = mul(float4(In.vPos,1.0f), wvpMatrix);

    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;

	Out.finalColor = float4(g_MaterialAmbientColor.rgb,ColA*g_MaterialAmbientColor.a);

    	return Out;
}


technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
	SetDepthStencilState( Depth, 0 );
	SetBlendState( Blending, float4(0,0,0,0), 0xffffffff );
	SetRasterizerState( Multisampled );
    }
}